/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import shz.Help;
import shz.IOHelp;
import shz.PRException;
import shz.Validator;
import shz.constant.ArrayConstant;

public final class Coder {
    private Coder() {
        throw new IllegalStateException();
    }

    private static MessageDigest getInstance(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw PRException.of(e);
        }
    }

    public static byte[] hash(byte[] bytes, String algorithm) {
        MessageDigest instance = Coder.getInstance(algorithm);
        instance.update(bytes);
        return instance.digest();
    }

    public static String hexEncode(byte[] bytes) {
        if (Validator.isEmpty(bytes)) {
            return "";
        }
        char[] chars = new char[bytes.length << 1];
        int idx = 0;
        for (byte b : bytes) {
            chars[idx++] = ArrayConstant.CHAR_ARRAY_16[b >>> 4 & 0xF];
            chars[idx++] = ArrayConstant.CHAR_ARRAY_16[b & 0xF];
        }
        return new String(chars);
    }

    public static byte[] hexDecode(String s) {
        if (Validator.isBlank(s)) {
            return ArrayConstant.EMPTY_BYTE_ARRAY;
        }
        if ((s.length() & 1) != 0) {
            throw new IllegalArgumentException(Help.format("\u975e\u6cd5\u5341\u516d\u8fdb\u5236\u7f16\u7801,\u957f\u5ea6%d", s.length()));
        }
        byte[] bytes = new byte[s.length() >>> 1];
        for (int i = 0; i < s.length(); i += 2) {
            int h = Character.digit(s.charAt(i), 16);
            int l = Character.digit(s.charAt(i + 1), 16);
            if (h < 0 || l < 0) {
                throw new IllegalArgumentException(Help.format("%d\u6216%d\u4f4d\u7f6e\u51fa\u73b0\u975e\u6cd5\u5b57\u7b26", i, i + 1));
            }
            bytes[i >>> 1] = (byte)(h << 4 | l);
        }
        return bytes;
    }

    public static String md5(byte[] bytes) {
        return Coder.hexEncode(Coder.hash(bytes, "MD5"));
    }

    public static String sha256(byte[] bytes) {
        return Coder.hexEncode(Coder.hash(bytes, "SHA-256"));
    }

    public static String hmacSha1(byte[] bytes, byte[] key) {
        Mac mac;
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw PRException.of(e);
        }
        return Coder.hexEncode(mac.doFinal(bytes));
    }

    public static byte[] hash(InputStream is, String algorithm) {
        MessageDigest instance = Coder.getInstance(algorithm);
        IOHelp.read(is, (buffer, len) -> instance.update((byte[])buffer, 0, (int)len));
        return instance.digest();
    }

    public static String md5(InputStream is) {
        return Coder.hexEncode(Coder.hash(is, "MD5"));
    }

    public static byte[] hash(File file, String algorithm) {
        return Coder.hash(IOHelp.getBis(file), algorithm);
    }

    public static String md5(File file) {
        return Coder.hexEncode(Coder.hash(file, "MD5"));
    }

    public static String unicodeEncode(String s) {
        if (Validator.isBlank(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() * 6);
        for (int i = 0; i < s.length(); ++i) {
            sb.append("\\u");
            String hex = Integer.toHexString(s.charAt(i));
            if (hex.length() != 4) {
                if (hex.length() == 2) {
                    sb.append("00");
                } else if (hex.length() == 1) {
                    sb.append("000");
                } else {
                    sb.append("0");
                }
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String unicodeDecode(String s) {
        if (Validator.isBlank(s)) {
            return s;
        }
        char[] buffer = new char[Math.min(1024, s.length())];
        AtomicInteger bufferOffset = new AtomicInteger();
        char[] array4 = new char[4];
        AtomicInteger array4Offset = new AtomicInteger();
        AtomicReference<Character> last = new AtomicReference<Character>();
        StringBuilder sb = new StringBuilder();
        Coder.unicodeDecode0(s, buffer, bufferOffset, array4, array4Offset, last, sb::append);
        if (bufferOffset.get() > 0) {
            sb.append(buffer, 0, bufferOffset.get());
        }
        if (array4Offset.get() > 0) {
            sb.append(array4, 0, array4Offset.get());
        }
        if (last.get() != null) {
            sb.append(last.get());
        }
        return sb.toString();
    }

    private static void unicodeDecode0(String s, char[] buffer, AtomicInteger bufferOffset, char[] array4, AtomicInteger array4Offset, AtomicReference<Character> last, Consumer<char[]> consumer) {
        int i;
        int len = last.get() == null ? s.length() : s.length() + 1;
        if (array4Offset.get() > 0) {
            int min = Math.min(4 - array4Offset.get(), len);
            for (i = 0; i < min; ++i) {
                array4[array4Offset.getAndIncrement() + i] = Coder.getChar(s, i, last);
            }
            if (array4Offset.get() == 4) {
                Coder.addBuffer(buffer, bufferOffset, Coder.parseChar(array4), consumer);
                array4Offset.set(0);
            } else {
                last.set(null);
                return;
            }
        }
        while (i < len - 1) {
            char next;
            char cur = Coder.getChar(s, i, last);
            if (cur != '\\' || (next = Coder.getChar(s, i + 1, last)) != 'u' && next != 'U') {
                Coder.addBuffer(buffer, bufferOffset, cur, consumer);
                ++i;
                continue;
            }
            int min = Math.min(len, (i += 2) + 4);
            int mark = i;
            while (i < min) {
                array4[i - mark] = Coder.getChar(s, i, last);
                ++i;
            }
            if (min < mark + 4) {
                array4Offset.set(i - mark);
                break;
            }
            Coder.addBuffer(buffer, bufferOffset, Coder.parseChar(array4), consumer);
        }
        if (i == len - 1) {
            last.set(Character.valueOf(Coder.getChar(s, i, last)));
        } else {
            last.set(null);
        }
    }

    private static char getChar(String s, int i, AtomicReference<Character> last) {
        if (last.get() == null) {
            return s.charAt(i);
        }
        if (i == 0) {
            return last.get().charValue();
        }
        return s.charAt(i - 1);
    }

    private static char parseChar(char[] array4) {
        return (char)Integer.parseInt(new String(array4), 16);
    }

    private static void addBuffer(char[] buffer, AtomicInteger bufferOffset, char c, Consumer<char[]> consumer) {
        if (bufferOffset.get() == buffer.length) {
            consumer.accept(buffer);
            bufferOffset.set(0);
        }
        buffer[bufferOffset.getAndIncrement()] = c;
    }

    public static String urlEncode(String url, Charset charset) {
        try {
            return URLEncoder.encode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw PRException.of(e);
        }
    }

    public static String urlEncode(String url) {
        return Coder.urlEncode(url, StandardCharsets.UTF_8);
    }

    public static String urlDecode(String url, Charset charset) {
        try {
            return URLDecoder.decode(url, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw PRException.of(e);
        }
    }

    public static String urlDecode(String url) {
        return Coder.urlDecode(url, StandardCharsets.UTF_8);
    }
}

