/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import shz.model.Sphere;

public class CoordinateHelp {
    private static final double ee = 0.006693421622965943;
    private static final double x_pi = 52.35987755982988;

    private CoordinateHelp() {
        throw new IllegalStateException();
    }

    public static Point2D.Double gps84ToGcj02(double lon, double lat) {
        if (Sphere.outOfChina(lon, lat)) {
            return new Point2D.Double(lon, lat);
        }
        double radLat = lat * (Math.PI / 180);
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        Point2D.Double gcj02 = CoordinateHelp.transform(lon - 105.0, lat - 35.0);
        gcj02.x = CoordinateHelp.setScale(lon + gcj02.x * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI));
        gcj02.y = CoordinateHelp.setScale(lat + gcj02.y * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI));
        return gcj02;
    }

    private static Point2D.Double transform(double lon, double lat) {
        Point2D.Double point = new Point2D.Double();
        double sqrt = Math.sqrt(Math.abs(lon));
        point.x = 300.0 + lon + 2.0 * lat + 0.1 * lon * lon + 0.1 * lon * lat + 0.1 * sqrt;
        point.y = -100.0 + 2.0 * lon + 3.0 * lat + 0.2 * lat * lat + 0.1 * lon * lat + 0.2 * sqrt;
        double v = (20.0 * Math.sin(6.0 * lon * Math.PI) + 20.0 * Math.sin(2.0 * lon * Math.PI)) * 2.0 / 3.0;
        point.x += v;
        point.y += v;
        point.x += (20.0 * Math.sin(lon * Math.PI) + 40.0 * Math.sin(lon / 3.0 * Math.PI)) * 2.0 / 3.0;
        point.x += (150.0 * Math.sin(lon / 12.0 * Math.PI) + 300.0 * Math.sin(lon / 30.0 * Math.PI)) * 2.0 / 3.0;
        point.y += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        point.y += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
        return point;
    }

    private static double setScale(double val) {
        BigDecimal result = new BigDecimal(Double.toString(val));
        if (result.scale() > 6) {
            result = result.setScale(6, 4);
        }
        return result.doubleValue();
    }

    public static Point2D.Double gcj02ToGps84(double lon, double lat) {
        Point2D.Double gcj02 = CoordinateHelp.gps84ToGcj02(lon, lat);
        Point2D.Double gps84 = new Point2D.Double();
        gps84.x = CoordinateHelp.setScale(lon * 2.0 - gcj02.x);
        gps84.y = CoordinateHelp.setScale(lat * 2.0 - gcj02.y);
        return gps84;
    }

    public static Point2D.Double gcj02ToBd09(double lon, double lat) {
        double z = Math.sqrt(lon * lon + lat * lat) + 2.0E-5 * Math.sin(lat * 52.35987755982988);
        double theta = Math.atan2(lat, lon) + 3.0E-6 * Math.cos(lon * 52.35987755982988);
        Point2D.Double bd09 = new Point2D.Double();
        bd09.x = CoordinateHelp.setScale(z * Math.cos(theta) + 0.0065);
        bd09.y = CoordinateHelp.setScale(z * Math.sin(theta) + 0.006);
        return bd09;
    }

    public static Point2D.Double bd09ToGcj02(double lon, double lat) {
        double x = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        Point2D.Double gcj02 = new Point2D.Double();
        gcj02.x = CoordinateHelp.setScale(z * Math.cos(theta));
        gcj02.y = CoordinateHelp.setScale(z * Math.sin(theta));
        return gcj02;
    }
}

