/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Stream;
import shz.FileHelp;
import shz.ToList;
import shz.ToSet;

public final class DllHelp {
    private DllHelp() {
        throw new IllegalStateException();
    }

    public static void load(String path, boolean tryFind, long timeout) {
        Optional.ofNullable(FileHelp.findFile(path, tryFind, null, null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout)).ifPresent(f -> DllHelp.load0(f.getAbsolutePath()));
    }

    private static boolean load0(String path) {
        boolean flag = true;
        try {
            System.load(path);
        }
        catch (Throwable t) {
            flag = false;
        }
        return flag;
    }

    public static void load(String path) {
        DllHelp.load(path, true, 0L);
    }

    public static void load(Set<String> paths, boolean tryFind, long timeout) {
        Optional.ofNullable(FileHelp.findFiles(paths, tryFind, false, null, null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout)).ifPresent(fs -> DllHelp.load0(ToSet.collect(fs.stream().map(File::getAbsolutePath))));
    }

    private static void load0(Collection<String> paths) {
        List<String> errors = ToList.collect(paths.stream().filter(s -> !DllHelp.load0(s)));
        if (!errors.isEmpty() && errors.size() != paths.size()) {
            DllHelp.load0(errors);
        }
    }

    public static void load(Set<String> paths) {
        DllHelp.load(paths, true, 0L);
    }

    public static void loadFromFolder(String path, boolean tryFind, boolean iteration, long timeout) {
        File findFile = FileHelp.findFile(path, tryFind, null, null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout);
        if (findFile != null && findFile.isDirectory()) {
            if (iteration) {
                DllHelp.load0(DllHelp.getFromFolder(findFile, new LinkedList<String>()));
            } else {
                Optional.ofNullable(findFile.listFiles(File::isFile)).ifPresent(fs -> DllHelp.load0(ToSet.collect(((Stream)Arrays.stream(fs).parallel()).filter(f -> f.getName().toLowerCase().endsWith(".dll")).map(File::getAbsolutePath))));
            }
        }
    }

    private static List<String> getFromFolder(File folder, List<String> list) {
        Optional.ofNullable(folder.listFiles()).ifPresent(fs -> Arrays.stream(fs).forEach(f -> {
            if (f.isDirectory()) {
                DllHelp.getFromFolder(f, list);
            } else if (f.getName().toLowerCase().endsWith(".dll")) {
                list.add(f.getAbsolutePath());
            }
        }));
        return list;
    }

    public static void loadFromFolder(String path) {
        DllHelp.loadFromFolder(path, true, true, 0L);
    }

    public static void loadFromURL(URL url, boolean tryFind, boolean regex, Set<String> paths, long timeout) {
        Optional.ofNullable(FileHelp.findFilesFromURL(url, tryFind, regex, paths, timeout)).ifPresent(fs -> DllHelp.load0(ToSet.collect(fs.stream().map(File::getAbsolutePath))));
    }

    public static void loadFromURL(Set<String> paths) {
        DllHelp.loadFromURL(null, true, false, paths, 0L);
    }
}

