/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shz.Coder;
import shz.Help;
import shz.IOHelp;
import shz.PRException;
import shz.RegexHelp;
import shz.Serializer;
import shz.ToList;
import shz.ToSet;
import shz.Validator;
import shz.ZipHelp;
import shz.msg.ServerFailureMsg;

public final class FileHelp {
    private static final int offset = 10;
    private static final int mask = 1023;
    private static final int N = 1;
    private static final int M = 2;
    private static final int S = 4;
    private static final int OK = 8;
    public static final String F_R = "r";
    public static final String F_RW = "rw";
    public static final String F_RWS = "rws";
    public static final String F_RWD = "rwd";

    private FileHelp() {
        throw new IllegalStateException();
    }

    public static File fromUrl(URL url, Charset charset) {
        return new File(Coder.urlDecode(url.getFile(), charset));
    }

    public static File fromUrl(URL url) {
        return FileHelp.fromUrl(url, StandardCharsets.UTF_8);
    }

    public static File fromCls(Class<?> cls, Charset charset) {
        return FileHelp.fromUrl(cls.getProtectionDomain().getCodeSource().getLocation(), charset);
    }

    public static File fromCls(Class<?> cls) {
        return FileHelp.fromCls(cls, StandardCharsets.UTF_8);
    }

    public static File findFile(String path, boolean tryFind, List<String> includes, Set<String> excludes, Executor executor, long timeout) {
        if (Validator.isBlank(path)) {
            return null;
        }
        String path_ = Coder.urlDecode(path, StandardCharsets.UTF_8);
        File file = new File(path_);
        if (file.exists()) {
            return file;
        }
        if (!tryFind) {
            return null;
        }
        AtomicBoolean stop = new AtomicBoolean();
        if (executor == null || timeout <= 0L) {
            return FileHelp.tryFind(path_, includes, excludes, stop);
        }
        try {
            File file2 = CompletableFuture.supplyAsync(() -> FileHelp.tryFind(path_, includes, excludes, stop), executor).get(timeout, TimeUnit.MILLISECONDS);
            return file2;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw PRException.of(e);
        }
        finally {
            stop.set(true);
        }
    }

    private static File tryFind(String path, List<String> includes, Set<String> excludes, AtomicBoolean stop) {
        List<File> includes_;
        char[] array = FileHelp.format(path);
        File include = FileHelp.getInclude(array);
        List<File> list = includes_ = include == null ? FileHelp.getIncludes(includes) : Collections.singletonList(include);
        if (Validator.isEmpty(includes_)) {
            return null;
        }
        Set<char[]> excludes_ = FileHelp.getExcludes(excludes);
        if (excludes_ != null && Validator.isEmpty(includes_ = ToList.explicitCollect(includes_.stream().filter(f -> !FileHelp.contains(f, excludes_, false)), includes_.size()))) {
            return null;
        }
        File result = null;
        for (File file : includes_) {
            if (!stop.get() && (result = FileHelp.tryFind(file, array, excludes_, stop)) == null) continue;
            break;
        }
        return result;
    }

    private static char[] format(String path) {
        char[] array;
        int idx;
        StringBuilder sb = new StringBuilder(path.length());
        int prev1 = 32;
        int prev2 = 32;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (prev1 == 47) continue;
                sb.append('/');
                prev2 = prev1;
                prev1 = 47;
                continue;
            }
            if (c == '*') {
                if (prev1 == 42 && prev2 == 42) continue;
                sb.append('*');
                prev2 = prev1;
                prev1 = 42;
                continue;
            }
            sb.append(c);
            prev2 = prev1;
            prev1 = c;
        }
        path = sb.toString().replaceAll("^(\\*\\*/){2,}", "**/").replaceAll("(/\\*\\*){2,}/", "/**/");
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if ((idx = Help.indexOf(':', array = path.toCharArray())) <= 0 || !FileHelp.isWindows()) {
            return array;
        }
        for (int i = 0; i < idx; ++i) {
            if (Character.isUpperCase(array[i])) continue;
            array[i] = Character.toUpperCase(array[i]);
        }
        return array;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    private static File getInclude(char[] array) {
        boolean win = FileHelp.isWindows();
        if (win && (array[0] == '/' || Help.indexOf(':', array) == -1)) {
            return null;
        }
        if (!win && array[0] != '/') {
            return null;
        }
        int end = -1;
        for (int i = 0; i < array.length && array[i] != '*'; ++i) {
            if (array[i] != '/') continue;
            end = i;
        }
        if (end == -1) {
            return null;
        }
        File file = new File(new String(array, 0, end + 1));
        return file.exists() ? file : null;
    }

    private static List<File> getIncludes(List<String> includes) {
        List<File> includes_;
        if (Validator.nonBlank(includes) && Validator.nonEmpty(includes_ = ToList.explicitCollect(includes.stream().filter(Validator::nonBlank).map(e -> Coder.urlDecode(e, StandardCharsets.UTF_8)).map(File::new).filter(File::exists), includes.size()))) {
            return includes_;
        }
        if (FileHelp.isWindows()) {
            return ToList.explicitCollect(Stream.of(System.getProperty("user.dir"), System.getProperty("user.home"), "C:", "D:", "E:", "F:", "G:", "H:").map(File::new), 8);
        }
        return ToList.explicitCollect(Stream.of(System.getProperty("user.dir"), System.getProperty("user.home"), System.getProperty("file.separator")).map(File::new), 3);
    }

    private static Set<char[]> getExcludes(Set<String> excludes) {
        if (Validator.isBlank(excludes)) {
            return null;
        }
        return ToSet.explicitCollect(excludes.parallelStream().filter(Validator::nonBlank).map(e -> Coder.urlDecode(e, StandardCharsets.UTF_8)).map(FileHelp::format), excludes.size());
    }

    private static File tryFind(File file, char[] path, Set<char[]> excludes, AtomicBoolean stop) {
        File file_;
        if (stop.get()) {
            return null;
        }
        if (FileHelp.equals(FileHelp.format(file.getAbsolutePath()), path)) {
            return file;
        }
        if (file.isFile()) {
            return null;
        }
        Object[] listFiles = file.listFiles(f -> f.isFile() && !FileHelp.contains(f, excludes, false));
        if (Validator.nonEmpty(listFiles) && (file_ = (File)Arrays.stream(listFiles).filter(f -> FileHelp.equals(FileHelp.format(f.getAbsolutePath()), path)).findAny().orElse(null)) != null) {
            return file_;
        }
        listFiles = file.listFiles(f -> f.isDirectory() && !FileHelp.contains(f, excludes, false));
        if (Validator.isEmpty(listFiles)) {
            return null;
        }
        return Arrays.stream(listFiles).map(f -> FileHelp.tryFind(f, path, excludes, stop)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean equals(char[] file, char[] path) {
        int i;
        int checkTail = FileHelp.checkTail(file, path);
        if (checkTail == 1) {
            return false;
        }
        int plen = FileHelp.spLen(path);
        if (plen == 1) {
            return checkTail == 4 || FileHelp.spLen(file) == 1;
        }
        int checkHead = FileHelp.checkHead(file, path);
        if (checkHead == 1) {
            return false;
        }
        if (plen == 2) {
            return checkTail == 4 || checkHead == 4 || FileHelp.spLen(file) == 2;
        }
        int flen = FileHelp.spLen(file);
        int[] fsps = FileHelp.sps(file, flen);
        int[] psps = FileHelp.sps(path, plen);
        int[][] dp = new int[flen][plen];
        dp[0][0] = checkHead;
        int[] nArray = dp[0];
        nArray[0] = nArray[0] | 8;
        for (i = 1; i < flen; ++i) {
            dp[i][0] = FileHelp.match(file, fsps[i] >> 10, fsps[i] & 0x3FF, path, psps[0] >> 10, psps[0] & 0x3FF);
            if (dp[i][0] == 1) break;
            int[] nArray2 = dp[i];
            nArray2[0] = nArray2[0] | 8;
        }
        int j = 1;
        while (j < plen) {
            dp[0][j] = FileHelp.match(file, fsps[0] >> 10, fsps[0] & 0x3FF, path, psps[j] >> 10, psps[j] & 0x3FF);
            if (dp[0][j] == 1) break;
            int[] nArray3 = dp[0];
            int n = j++;
            nArray3[n] = nArray3[n] | 8;
        }
        for (i = 1; i < flen; ++i) {
            for (int j2 = 1; j2 < plen; ++j2) {
                dp[i][j2] = FileHelp.match(file, fsps[i] >> 10, fsps[i] & 0x3FF, path, psps[j2] >> 10, psps[j2] & 0x3FF);
                if (dp[i][j2] == 1) continue;
                int[] nArray4 = dp[i];
                int n = j2;
                nArray4[n] = nArray4[n] | dp[i - 1][j2 - 1];
                if ((dp[i][j2] & 4) == 0 && (dp[i][j2 - 1] & 4) == 0) continue;
                int[] nArray5 = dp[i];
                int n2 = j2;
                nArray5[n2] = nArray5[n2] | dp[i][j2 - 1];
                int[] nArray6 = dp[i];
                int n3 = j2;
                nArray6[n3] = nArray6[n3] | dp[i - 1][j2];
            }
        }
        return (dp[flen - 1][plen - 1] & 8) != 0;
    }

    private static int checkTail(char[] file, char[] path) {
        if (path.length < 2) {
            return 1;
        }
        int PL = FileHelp.lastSp(path);
        PL = PL == -1 ? 0 : PL + 1;
        return FileHelp.match(file, FileHelp.lastSp(file) + 1, file.length, path, PL, path.length);
    }

    private static int lastSp(char[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != '/') continue;
            return i;
        }
        return -1;
    }

    private static int match(char[] file, int FL, int FR, char[] path, int PL, int PR) {
        if (file[FR - 1] != path[PR - 1] && path[PR - 1] != '*') {
            return 1;
        }
        try {
            if (file[FL] != path[PL] && path[PL] != '*') {
                return 1;
            }
        }
        catch (Throwable t) {
            System.out.println(new String(file));
            return 1;
        }
        if (PR - PL == 1) {
            return path[PL] == '*' ? 2 : (FR - FL > 1 || file[FL] != path[PL] ? 1 : 2);
        }
        if (PR - PL == 2) {
            if (path[PL] == '*' && path[PL + 1] == '*') {
                return 4;
            }
            if (FR - FL != 2) {
                return 1;
            }
            if (path[PL + 1] == '*') {
                return file[FL] == path[PL] ? 2 : 1;
            }
            if (path[PL] == '*') {
                return file[FL + 1] == path[PL + 1] ? 2 : 1;
            }
            return file[FL] == path[PL] && file[FL + 1] == path[PL + 1] ? 2 : 1;
        }
        boolean[][] dp = new boolean[FR - FL][PR - PL];
        dp[0][0] = true;
        for (int i = 1; i < FR - FL; ++i) {
            for (int j = 1; j < PR - PL; ++j) {
                if (file[i + FL] != path[j + PL] && path[j + PL] != '*') continue;
                boolean[] blArray = dp[i];
                int n = j;
                blArray[n] = blArray[n] | dp[i - 1][j - 1];
                if (path[j - 1 + PL] != '*' || path[j + PL] != '*' && (j < 2 || path[j - 2 + PL] != '*')) continue;
                boolean[] blArray2 = dp[i];
                int n2 = j;
                blArray2[n2] = blArray2[n2] | dp[i][j - 1];
                boolean[] blArray3 = dp[i];
                int n3 = j;
                blArray3[n3] = blArray3[n3] | dp[i - 1][j];
            }
        }
        return dp[FR - FL - 1][PR - PL - 1] ? 2 : 1;
    }

    private static int spLen(char[] array) {
        int len = 1;
        int idx = 0;
        while ((idx = FileHelp.nextSp(array, idx)) != -1) {
            ++len;
        }
        return len;
    }

    private static int nextSp(char[] array, int idx) {
        for (int i = idx + 1; i < array.length; ++i) {
            if (array[i] != '/') continue;
            return i;
        }
        return -1;
    }

    private static int checkHead(char[] file, char[] path) {
        int[] fsps = FileHelp.sps(file, 1);
        int[] psps = FileHelp.sps(path, 1);
        return FileHelp.match(file, fsps[0] >> 10, fsps[0] & 0x3FF, path, psps[0] >> 10, psps[0] & 0x3FF);
    }

    private static int[] sps(char[] array, int len) {
        int[] sps = new int[len];
        int L = array[0] == '/' ? 1 : 0;
        int R = FileHelp.nextSp(array, L);
        R = R == -1 ? array.length : R;
        sps[0] = (L << 10) + R;
        int i = 1;
        while (i < len) {
            sps[i] = R + 1 << 10;
            R = (R = FileHelp.nextSp(array, R + 1)) == -1 ? array.length : R;
            int n = i++;
            sps[n] = sps[n] + R;
        }
        return sps;
    }

    private static boolean contains(File file, Set<char[]> paths, boolean remove) {
        if (paths == null) {
            return false;
        }
        char[] array = FileHelp.format(file.getAbsolutePath());
        Iterator<char[]> it = paths.iterator();
        while (it.hasNext()) {
            if (!FileHelp.equals(array, it.next())) continue;
            if (remove) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    public static File findFile(String path, long timeout) {
        return FileHelp.findFile(path, true, null, null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout);
    }

    public static File findFile(String path) {
        return FileHelp.findFile(path, true, null, null, null, 0L);
    }

    public static Set<File> findFiles(Set<String> paths, boolean tryFind, boolean regex, List<String> includes, Set<String> excludes, Executor executor, long timeout) {
        if (Validator.isBlank(paths)) {
            return Collections.emptySet();
        }
        Set<String> paths_ = ToSet.explicitCollect(paths.stream().filter(Validator::nonBlank).map(e -> Coder.urlDecode(e, StandardCharsets.UTF_8)), paths.size());
        Stream<File> filter = paths_.stream().map(File::new).filter(File::exists);
        Set<File> result = filter.collect(Collectors.toSet());
        if (!tryFind || !regex && result.size() == paths_.size()) {
            return result;
        }
        if (!result.isEmpty()) {
            paths_.removeAll(ToSet.explicitCollect(result.stream().map(File::getAbsolutePath), result.size()));
        }
        AtomicBoolean stop = new AtomicBoolean();
        if (executor == null || timeout <= 0L) {
            FileHelp.tryFinds(paths_, regex, includes, excludes, result, stop);
        } else {
            try {
                CompletableFuture.runAsync(() -> FileHelp.tryFinds(paths_, regex, includes, excludes, result, stop), executor).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e2) {
                throw PRException.of(e2);
            }
            finally {
                stop.set(true);
            }
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    private static void tryFinds(Set<String> paths, boolean regex, List<String> includes, Set<String> excludes, Set<File> result, AtomicBoolean stop) {
        Set<char[]> set = ToSet.explicitCollect(paths.stream().map(FileHelp::format), paths.size());
        List<File> includes_ = ToList.explicitCollect(set.stream().map(FileHelp::getInclude).filter(Objects::nonNull), set.size());
        if (includes_.size() != set.size()) {
            if (includes_.isEmpty()) {
                includes_ = FileHelp.getIncludes(includes);
            } else {
                includes_.addAll(FileHelp.getIncludes(includes));
            }
        }
        if (includes_.isEmpty()) {
            return;
        }
        Set<char[]> excludes_ = FileHelp.getExcludes(excludes);
        if (excludes_ != null && (includes_ = ToList.collect(includes_.stream().filter(f -> !FileHelp.contains(f, excludes_, false)))).isEmpty()) {
            return;
        }
        for (File file : includes_) {
            if (stop.get()) break;
            FileHelp.tryFinds(file, set, regex, excludes_, result, stop);
            if (regex || !set.isEmpty()) continue;
            break;
        }
    }

    private static void tryFinds(File file, Set<char[]> paths, boolean regex, Set<char[]> excludes, Set<File> result, AtomicBoolean stop) {
        if (stop.get() || !regex && paths.isEmpty()) {
            return;
        }
        Object[] listFiles = file.listFiles(f -> f.isFile() && !FileHelp.contains(f, excludes, false));
        if (Validator.nonEmpty(listFiles)) {
            Arrays.stream(listFiles).filter(f -> FileHelp.contains(f, paths, !regex)).forEach(result::add);
        }
        if (Validator.isEmpty(listFiles = file.listFiles(f -> f.isDirectory() && !FileHelp.contains(f, excludes, false)))) {
            return;
        }
        Arrays.stream(listFiles).forEach(f -> {
            if (FileHelp.contains(f, paths, !regex)) {
                result.add((File)f);
            } else {
                FileHelp.tryFinds(f, paths, regex, excludes, result, stop);
            }
        });
    }

    public static Set<File> findFiles(Set<String> paths, long timeout) {
        return FileHelp.findFiles(paths, true, false, null, null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout);
    }

    public static Set<File> findFiles(Set<String> paths) {
        return FileHelp.findFiles(paths, true, false, null, null, null, 0L);
    }

    public static String getFileType(String hexStr) {
        switch (hexStr) {
            case "FFD8FF": {
                return "jpg";
            }
            case "89504E": {
                return "png";
            }
            case "474946": {
                return "jif";
            }
            case "49492A": {
                return "tif";
            }
            case "424D": {
                return "bmp";
            }
            case "414331": {
                return "dwg";
            }
            case "384250": {
                return "psd";
            }
            case "7B5C72": {
                return "rtf";
            }
            case "3C3F78": {
                return "xml";
            }
            case "68746D": {
                return "html";
            }
            case "44656C": {
                return "eml";
            }
            case "CFAD12": {
                return "dbx";
            }
            case "214244": {
                return "pst";
            }
            case "D0CF11": {
                return "xls doc";
            }
            case "537461": {
                return "mdb";
            }
            case "FF5750": {
                return "wpd";
            }
            case "252150": {
                return "eps ps";
            }
            case "255044": {
                return "pdf";
            }
            case "AC9EBD": {
                return "qdf";
            }
            case "E38285": {
                return "pwl";
            }
            case "504B03": {
                return "zip";
            }
            case "526172": {
                return "rar";
            }
            case "574156": {
                return "wav";
            }
            case "415649": {
                return "avi";
            }
            case "2E7261": {
                return "ram";
            }
            case "2E524D": {
                return "rm";
            }
            case "000001": {
                return "mpg";
            }
            case "6D6F6F": {
                return "mov";
            }
            case "3026B2": {
                return "asf";
            }
            case "4D5468": {
                return "mid";
            }
            case "706163": {
                return "java";
            }
            case "CAFEBA": {
                return "class";
            }
        }
        return "txt";
    }

    public static String getFileType(byte[] bytes) {
        if (Validator.isEmpty(bytes)) {
            return null;
        }
        int len = Math.min(bytes.length, 3);
        StringBuilder sb = new StringBuilder(6);
        for (int i = 0; i < len; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return FileHelp.getFileType(sb.toString().toUpperCase());
    }

    public static String getFileType(InputStream is) {
        Validator.requireNon(!is.markSupported());
        is.mark(3);
        byte[] bytes = new byte[3];
        try {
            int len = is.read(bytes, 0, 3);
            if (len < 3) {
                bytes = Arrays.copyOf(bytes, len);
            }
            is.reset();
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        return FileHelp.getFileType(bytes);
    }

    public static Set<File> findFilesFromURL(URL url, boolean tryFind, boolean regex, Set<String> paths, long timeout) {
        url = url == null ? Thread.currentThread().getContextClassLoader().getResource("") : url;
        Objects.requireNonNull(url);
        String protocol = url.getProtocol();
        try {
            File file;
            URLConnection conn = url.openConnection();
            if ("jar".equals(protocol)) {
                JarFile jarFile = ((JarURLConnection)conn).getJarFile();
                return FileHelp.findFiles(ToSet.collect(paths.stream().map(e -> "**/" + e)), tryFind, regex, Collections.singletonList(ZipHelp.getFileFromJarFile(jarFile, 1024, paths)), null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout);
            }
            if ("file".equals(protocol)) {
                file = FileHelp.fromUrl(conn.getURL());
            } else {
                InputStream is = conn.getInputStream();
                file = FileHelp.fromUrl(url);
                IOHelp.read(is, IOHelp.getBos(file));
            }
            if (file.isDirectory()) {
                return FileHelp.findFiles(paths, tryFind, regex, Collections.singletonList(file.getAbsolutePath()), null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout);
            }
            if (paths.size() > 1) {
                return null;
            }
            if (FileHelp.equals(file, paths.iterator().next())) {
                return Collections.singleton(file);
            }
        }
        catch (IOException e2) {
            throw PRException.of(e2);
        }
        return Collections.emptySet();
    }

    public static Set<File> findFilesFromURL(Set<String> paths) {
        return FileHelp.findFilesFromURL(null, true, false, paths, 0L);
    }

    public static boolean equals(File file, String path) {
        return FileHelp.equals(FileHelp.format(file.getAbsolutePath()), FileHelp.format(path));
    }

    public static void readBytes(File file, long offset, long size, int dataSize, Collection<byte[]> bytes) {
        IOHelp.read(IOHelp.getBis(file), offset, size, dataSize, bytes, null);
    }

    public static void readBytes(File file, Collection<byte[]> bytes) {
        FileHelp.readBytes(file, 0L, 0L, 1024, bytes);
    }

    public static void readBytes(File file, long offset, long size, int dataSize, byte[] bytes, int dataOffset) {
        IOHelp.read(IOHelp.getBis(file), offset, size, dataSize, bytes, dataOffset, null);
    }

    public static void readBytes(File file, byte[] bytes) {
        FileHelp.readBytes(file, 0L, 0L, 1024, bytes, 0);
    }

    public static byte[] readBytes(File file, long offset, long size, int dataSize) {
        return IOHelp.read(IOHelp.getBis(file), offset, size, dataSize, null);
    }

    public static byte[] readBytes(File file) {
        return FileHelp.readBytes(file, 0L, 0L, 1024);
    }

    public static <T> T readObject(File file, long offset, long size, int dataSize) {
        return Serializer.deserialize(IOHelp.read(IOHelp.getBis(file), offset, size, dataSize, null));
    }

    public static <T> T readObject(File file) {
        return FileHelp.readObject(file, 0L, 0L, 1024);
    }

    public static void readString(File file, Consumer<String> consumer) {
        IOHelp.read(IOHelp.getBr(file), consumer);
    }

    public static void readString(File file, Collection<String> strings) {
        IOHelp.read(IOHelp.getBr(file), strings::add);
    }

    public static String readString(File file) {
        StringWriter sw = new StringWriter();
        IOHelp.read(IOHelp.getBr(file), sw);
        return sw.toString();
    }

    public static void writeBytes(File file, boolean append, Collection<byte[]> bytes) {
        IOHelp.write(IOHelp.getBos(FileHelp.checkWriteFile(file), append, 8192), bytes);
    }

    public static File checkWriteFile(File file) {
        ServerFailureMsg.requireNon(file == null, "\u5199\u51fa\u6587\u4ef6\u4e3a\u7a7a");
        File parentFile = file.getParentFile();
        ServerFailureMsg.requireNon(parentFile == null || !parentFile.mkdirs() && !parentFile.exists(), "\u5199\u51fa\u6587\u4ef6\u7236\u6587\u4ef6\u4e0d\u5b58\u5728");
        ServerFailureMsg.requireNon(!parentFile.canWrite(), "\u5199\u51fa\u6587\u4ef6\u7236\u6587\u4ef6\u4e0d\u53ef\u5199");
        return file;
    }

    public static void writeBytes(File file, Collection<byte[]> bytes) {
        FileHelp.writeBytes(file, false, bytes);
    }

    public static void writeBytes(File file, boolean append, byte[] bytes) {
        IOHelp.write(IOHelp.getBos(FileHelp.checkWriteFile(file), append, 8192), bytes);
    }

    public static void writeBytes(File file, byte[] bytes) {
        FileHelp.writeBytes(file, false, bytes);
    }

    public static void writeChars(File file, boolean append, char[] chars) {
        IOHelp.write(IOHelp.getBw(FileHelp.checkWriteFile(file), append, 8192), chars);
    }

    public static void writeChars(File file, char[] chars) {
        FileHelp.writeChars(file, false, chars);
    }

    public static void writeString(File file, boolean append, Collection<String> strings) {
        IOHelp.write(IOHelp.getBw(FileHelp.checkWriteFile(file), append, 8192), strings);
    }

    public static void writeString(File file, Collection<String> strings) {
        FileHelp.writeString(file, false, strings);
    }

    public static void writeObject(File file, boolean append, Object data) {
        IOHelp.write(new DataOutputStream(IOHelp.getBos(FileHelp.checkWriteFile(file), append, 8192)), Serializer.serialize(data));
    }

    public static void writeObject(File file, Object data) {
        FileHelp.writeObject(file, false, data);
    }

    public static void copy(File src, File des, int dataSize) {
        IOHelp.read(IOHelp.getBis(src, 8192), IOHelp.getBos(des, false, 8192), dataSize, null, null);
    }

    public static void copy(File src, File des) {
        FileHelp.copy(src, des, 1024);
    }

    public static void copyText(File src, File des) {
        IOHelp.read(IOHelp.getBr(src, 8192), IOHelp.getBw(des, false, 8192));
    }

    public static void copy(Set<File> srcs, File des, int dataSize) {
        File desFile = FileHelp.checkCopyFile(des);
        srcs.parallelStream().filter(Objects::nonNull).filter(f -> f.exists() && f.isFile() && f.canRead()).forEach(f -> {
            File new_folder = new File(desFile, Help.uuid());
            if (new_folder.mkdirs()) {
                IOHelp.read(IOHelp.getBis(f, 8192), IOHelp.getBos(new File(new_folder, f.getName()), false, 8192), dataSize, null, null);
            }
        });
    }

    public static File checkCopyFile(File file) {
        ServerFailureMsg.requireNon(file == null, "\u62f7\u8d1d\u8f93\u51fa\u6587\u4ef6\u4e3a\u7a7a");
        ServerFailureMsg.requireNon(!file.mkdirs() && !file.exists(), "\u62f7\u8d1d\u8f93\u51fa\u6587\u4ef6\u4e0d\u5b58\u5728");
        ServerFailureMsg.requireNon(!file.canWrite(), "\u62f7\u8d1d\u8f93\u51fa\u6587\u4ef6\u4e0d\u53ef\u5199");
        ServerFailureMsg.requireNon(!file.isDirectory(), "\u62f7\u8d1d\u8f93\u51fa\u6587\u4ef6\u4e0d\u662f\u76ee\u5f55");
        return file;
    }

    public static void copy(Set<File> srcs, File des) {
        FileHelp.copy(srcs, des, 1024);
    }

    public static void copyText(Set<File> srcs, File des) {
        File desFile = FileHelp.checkCopyFile(des);
        srcs.parallelStream().filter(Objects::nonNull).filter(f -> f.exists() && f.isFile() && f.canRead()).forEach(f -> IOHelp.read(IOHelp.getBr(f, 8192), IOHelp.getBw(new File(desFile, Help.uuid() + "-copy-" + f.getName()), false, 8192)));
    }

    public static void copyFolder(File src, File des, Set<String> excludes, int dataSize) {
        FileHelp.copyFolder0(src, FileHelp.checkCopyFile(des), FileHelp.getExcludes(excludes), dataSize);
    }

    private static void copyFolder0(File oldFolder, File newFolder, Set<char[]> excludes, int dataSize) {
        Optional.ofNullable(oldFolder.listFiles(f -> !FileHelp.contains(f, excludes, false))).ifPresent(fs -> {
            if (newFolder.mkdirs() || newFolder.exists()) {
                ((Stream)Arrays.stream(fs).parallel()).forEach(f -> {
                    if (f.isFile()) {
                        IOHelp.read(IOHelp.getBis(f, 8192), IOHelp.getBos(new File(newFolder, f.getName()), false, 8192), dataSize, null, null);
                    } else {
                        FileHelp.copyFolder0(f, new File(newFolder, f.getName()), excludes, dataSize);
                    }
                });
            }
        });
    }

    public static void copyFolder(File src, File des) {
        FileHelp.copyFolder(src, des, null, 1024);
    }

    public static void copyFolder(File file) {
        FileHelp.copyFolder0(file, FileHelp.getDcf(file), null, 1024);
    }

    private static File getDcf(File file) {
        File des;
        String name = file.getName();
        int idx = name.indexOf(".");
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        if ((des = new File(file.getParentFile(), name + "-copy")).exists()) {
            FileHelp.deleteFile(des, null);
        }
        return des.mkdirs() ? des : null;
    }

    public static void copyFolder(Set<File> srcs, File des, Set<String> excludes, int dataSize) {
        File desFile = FileHelp.checkCopyFile(des);
        Set<char[]> excludes_ = FileHelp.getExcludes(excludes);
        srcs.parallelStream().filter(Objects::nonNull).filter(f -> f.exists() && f.isDirectory() && f.canRead()).forEach(f -> FileHelp.copyFolder0(f, new File(desFile, Help.uuid() + "-copy-" + f.getName()), excludes_, dataSize));
    }

    public static void copyFolder(Set<File> srcs, File des) {
        FileHelp.copyFolder(srcs, des, null, 1024);
    }

    public static void copyFolder(Set<File> files) {
        FileHelp.copyFolder(files, FileHelp.getDcf(files), null, 1024);
    }

    private static File getDcf(Set<File> files) {
        return new File(System.getProperty("user.dir"), Coder.md5(Arrays.toString(files.toArray()).getBytes()));
    }

    public static void deleteFile(File file, Set<String> excludes) {
        if (file == null) {
            return;
        }
        Set<char[]> excludes_ = FileHelp.getExcludes(excludes);
        if (FileHelp.contains(file, excludes_, false)) {
            return;
        }
        FileHelp.deleteFile0(file, excludes_);
    }

    private static void deleteFile0(File file, Set<char[]> excludes) {
        if (file.isFile()) {
            ServerFailureMsg.requireNon(!file.delete(), "\u5220\u9664\u6587\u4ef6%s\u5f02\u5e38", file.getAbsolutePath());
        } else {
            Optional.ofNullable(file.listFiles(f -> !FileHelp.contains(f, excludes, false))).ifPresent(fs -> ((Stream)Arrays.stream(fs).parallel()).forEach(f -> FileHelp.deleteFile0(f, excludes)));
        }
    }

    public static void deleteFile(File file) {
        FileHelp.deleteFile(file, null);
    }

    public static void deleteFile(String path, Set<String> excludes) {
        FileHelp.deleteFile(FileHelp.findFile(path), excludes);
    }

    public static void deleteFile(String path) {
        FileHelp.deleteFile(FileHelp.findFile(path), null);
    }

    public static void deleteFile(Set<String> paths, Set<String> excludes) {
        Set<char[]> excludes_ = FileHelp.getExcludes(excludes);
        paths.parallelStream().map(File::new).filter(f -> f.exists() && f.canExecute()).forEach(f -> FileHelp.deleteFile0(f, excludes_));
    }

    public static void deleteFile(Set<String> paths) {
        FileHelp.deleteFile(paths, null);
    }

    public static RandomAccessFile getRandomAccessFile(File file, String mode) {
        try {
            return new RandomAccessFile(file, mode);
        }
        catch (FileNotFoundException e) {
            throw PRException.of(e);
        }
    }

    public static void consumer(File file, Consumer<File> consumer) {
        if (file.isFile()) {
            consumer.accept(file);
            return;
        }
        Optional.ofNullable(file.listFiles()).ifPresent(fs -> ((Stream)Arrays.stream(fs).parallel()).forEach(f -> {
            if (f.isFile()) {
                consumer.accept((File)f);
            } else {
                FileHelp.consumer(f, consumer);
            }
        }));
    }

    public static void consumer(File src, File des, BiConsumer<File, File> consumer) {
        FileHelp.consumer0(src, FileHelp.checkCopyFile(des), consumer);
    }

    private static void consumer0(File src, File des, BiConsumer<File, File> consumer) {
        if (src.isFile()) {
            consumer.accept(src, des);
            return;
        }
        Optional.ofNullable(src.listFiles()).ifPresent(fs -> ((Stream)Arrays.stream(fs).parallel()).forEach(f -> {
            if (f.isFile()) {
                consumer.accept((File)f, des);
            } else {
                FileHelp.consumer0(f, new File(des, f.getName()), consumer);
            }
        }));
    }

    public static void consumer(File file, BiConsumer<File, File> consumer) {
        FileHelp.consumer0(file, FileHelp.getDcf(file), consumer);
    }

    public static void copyAndUpdate(File src, File des, Function<String, String> update) {
        FileHelp.copyAndUpdate0(src, FileHelp.checkCopyFile(des), update);
    }

    private static void copyAndUpdate0(File src, File des, Function<String, String> update) {
        FileHelp.consumer0(src, des, (s, d) -> {
            if (d.mkdirs() || d.exists()) {
                IOHelp.read(IOHelp.getBr(s), IOHelp.getBw(new File((File)d, s.getName())), update, null);
            }
        });
    }

    public static void copyAndUpdate(File file, Function<String, String> update) {
        FileHelp.copyAndUpdate0(file, FileHelp.getDcf(file), update);
    }

    public static void copyAndUpdate(File src, File des, String regex, String newStr) {
        FileHelp.copyAndUpdate(src, des, (String l) -> RegexHelp.isMatch(l, regex) ? l.replaceAll(regex, newStr) : l);
    }

    public static void copyAndUpdate(File src, String regex, String newStr) {
        FileHelp.copyAndUpdate(src, (String l) -> RegexHelp.isMatch(l, regex) ? l.replaceAll(regex, newStr) : l);
    }

    public static void updateJavaFileImport(File src, File des, String oldStr, String newStr) {
        FileHelp.copyAndUpdate0(src, FileHelp.checkCopyFile(des), (String l) -> RegexHelp.isMatch(l, "^(?:package|import) [a-z0-9]+(?:\\.[a-z0-9]+)*(?:.[a-zA-Z0-9]+)+;\\s*") ? l.replaceFirst(oldStr, newStr) : l);
    }

    public static void updateJavaFileImport(File src, String oldStr, String newStr) {
        FileHelp.updateJavaFileImport(src, FileHelp.getDcf(src), oldStr, newStr);
    }

    public static void replace(File src, File des, String regex, Function<Matcher, String> func) {
        FileHelp.copyAndUpdate0(src, FileHelp.checkCopyFile(des), (String l) -> RegexHelp.replace(l, regex, func));
    }

    public static void replace(File src, String regex, Function<Matcher, String> func) {
        FileHelp.copyAndUpdate0(src, FileHelp.getDcf(src), (String l) -> RegexHelp.replace(l, regex, func));
    }

    public static void copyAndUpdate(File src, File des, BiConsumer<String, BufferedWriter> update) {
        FileHelp.copyAndUpdate0(src, FileHelp.checkCopyFile(des), update);
    }

    private static void copyAndUpdate0(File src, File des, BiConsumer<String, BufferedWriter> update) {
        FileHelp.consumer0(src, des, (s, d) -> {
            if (d.mkdirs() || d.exists()) {
                IOHelp.read(IOHelp.getBr(s), IOHelp.getBw(new File((File)d, s.getName())), update);
            }
        });
    }

    public static void copyAndUpdate(File src, BiConsumer<String, BufferedWriter> update) {
        FileHelp.copyAndUpdate0(src, FileHelp.getDcf(src), update);
    }

    public static void formatJavaFile(File src, File des) {
        FileHelp.copyAndUpdate0(src, FileHelp.checkCopyFile(des), (String s, BufferedWriter w) -> {
            try {
                String str = s.trim();
                if (str.length() == 0) {
                    return;
                }
                switch (str.charAt(0)) {
                    case '*': 
                    case '/': {
                        return;
                    }
                }
                switch (str.charAt(str.length() - 1)) {
                    case ';': 
                    case '{': 
                    case '}': {
                        break;
                    }
                    default: {
                        str = str + " ";
                    }
                }
                w.write(str);
            }
            catch (IOException e) {
                throw PRException.of(e);
            }
        });
    }

    public static void formatJavaFile(File src) {
        FileHelp.formatJavaFile(src, FileHelp.getDcf(src));
    }

    public static MatchInfo matchFiles(File file, Function<String, List<Integer>> func) {
        MatchInfo matchInfo = new MatchInfo();
        FileHelp.consumer(file, (File f) -> FileHelp.matchColumns(f, func, matchInfo));
        return matchInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void matchColumns(File file, Function<String, List<Integer>> func, MatchInfo matchInfo) {
        BufferedReader br = IOHelp.getBr(file);
        MatchFileInfo matchFileInfo = new MatchFileInfo(file.getAbsolutePath());
        matchInfo.matchFileInfo.add(matchFileInfo);
        int row = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++row;
                List<Integer> columns = func.apply(line);
                if (!Validator.nonEmpty(columns)) continue;
                matchFileInfo.matchColumnInfo.add(new MatchColumnInfo(row, columns));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (!matchFileInfo.matchColumnInfo.isEmpty()) {
                matchInfo.totalFiles(matchInfo.totalFiles + 1);
                matchInfo.totalRows(matchInfo.totalRows + matchFileInfo.matchColumnInfo.size());
                matchInfo.totalColumns(matchInfo.totalColumns + matchFileInfo.matchColumnInfo.parallelStream().map(ci -> ci.columns().size()).reduce(Integer::sum).orElse(0));
            } else {
                matchInfo.matchFileInfo.remove(matchInfo.matchFileInfo.size() - 1);
            }
            IOHelp.close(br);
        }
    }

    public static MatchInfo findByContains(File file, String target) {
        return FileHelp.matchFiles(file, line -> {
            int index = line.indexOf(target);
            if (index == -1) {
                return null;
            }
            return FileHelp.getLineColumnsOfStr(line, target, new LinkedList<Integer>(), 0);
        });
    }

    private static List<Integer> getLineColumnsOfStr(String line, String target, List<Integer> columns, int offset) {
        int index = line.indexOf(target);
        if (index == -1) {
            return columns;
        }
        columns.add(index + 1 + offset);
        return FileHelp.getLineColumnsOfStr(line.substring(index + target.length()), target, columns, offset += index + target.length());
    }

    public static String formatPath(String path) {
        if (Validator.isBlank(path)) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path.length());
        FileHelp.append(sb, path);
        return sb.toString();
    }

    private static void append(StringBuilder sb, String path) {
        boolean mark = true;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c != '/' && c != '\\') {
                sb.append(c);
                mark = true;
                continue;
            }
            if (!mark) continue;
            sb.append('/');
            mark = false;
        }
    }

    public static String jointPath(String prefix, String path) {
        if (Validator.isBlank(prefix)) {
            return FileHelp.formatPath(path);
        }
        if (Validator.isBlank(path)) {
            return FileHelp.formatPath(prefix);
        }
        StringBuilder sb = new StringBuilder(prefix.length() + path.length() + 1);
        FileHelp.append(sb, prefix);
        char c = path.charAt(0);
        if (sb.charAt(sb.length() - 1) == '/') {
            if (c == '/' || c == '\\') {
                sb.deleteCharAt(sb.length() - 1);
            }
        } else if (c != '/' && c != '\\') {
            sb.append('/');
        }
        FileHelp.append(sb, path);
        return sb.toString();
    }

    public static final class MatchInfo {
        private int totalFiles;
        private int totalRows;
        private int totalColumns;
        private final List<MatchFileInfo> matchFileInfo = new LinkedList<MatchFileInfo>();

        public int totalFiles() {
            return this.totalFiles;
        }

        public void totalFiles(int totalFiles) {
            this.totalFiles = totalFiles;
        }

        public int totalRows() {
            return this.totalRows;
        }

        public void totalRows(int totalRows) {
            this.totalRows = totalRows;
        }

        public int totalColumns() {
            return this.totalColumns;
        }

        public void totalColumns(int totalColumns) {
            this.totalColumns = totalColumns;
        }

        public List<MatchFileInfo> matchFileInfo() {
            return this.matchFileInfo;
        }

        public String toString() {
            return "MatchInfo{totalFiles=" + this.totalFiles + ", totalRows=" + this.totalRows + ", totalColumns=" + this.totalColumns + ", matchFileInfo=" + this.matchFileInfo + '}';
        }
    }

    public static final class MatchFileInfo {
        private final String path;
        private final List<MatchColumnInfo> matchColumnInfo;

        public MatchFileInfo(String path) {
            this.path = path;
            this.matchColumnInfo = new LinkedList<MatchColumnInfo>();
        }

        public String path() {
            return this.path;
        }

        public List<MatchColumnInfo> matchColumnInfo() {
            return this.matchColumnInfo;
        }

        public String toString() {
            return "MatchFileInfo{path='" + this.path + '\'' + ", matchColumnInfo=" + this.matchColumnInfo + '}';
        }
    }

    public static final class MatchColumnInfo {
        private final int row;
        private final List<Integer> columns;

        public MatchColumnInfo(int row, List<Integer> columns) {
            this.row = row;
            this.columns = columns;
        }

        public int row() {
            return this.row;
        }

        public List<Integer> columns() {
            return this.columns;
        }

        public String toString() {
            return "MatchColumnInfo{row=" + this.row + ", columns=" + this.columns + '}';
        }
    }
}

