/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import shz.AccessibleHelp;
import shz.PRException;
import shz.Response;
import shz.ToList;
import shz.ToMap;
import shz.Validator;
import shz.constant.ArrayConstant;
import shz.constant.NullConstant;
import shz.enums.IEnum;
import shz.handler.translate.TranslateEnum;
import shz.handler.translate.TranslateName;
import shz.handler.translate.TranslateType;
import shz.msg.ServerFailure;
import shz.stack.LArrayStack;

public final class Help {
    private static final char[] DIGIT = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static final char[] INDEX = new char[]{'\u62fe', '\u4f70', '\u4edf', '\u4e07', '\u4ebf'};
    private static final char[] UNIT = new char[]{'\u5143', '\u89d2', '\u5206'};
    private static final char I = '\u6574';
    private static final Map<Class<?>, Map<String, TranslateEnum>> TRANSLATE_ENUM_CACHE = new ConcurrentHashMap(128);

    private Help() {
        throw new IllegalStateException();
    }

    public static String uuid(boolean replace) {
        String uuid = UUID.randomUUID().toString();
        return replace ? uuid.replaceAll("-", "") : uuid;
    }

    public static String uuid() {
        return Help.uuid(true);
    }

    public static String randomString(char[] array, int len) {
        StringBuilder sb = new StringBuilder(len);
        ThreadLocalRandom.current().ints(len, 0, array.length).forEach(i -> sb.append(array[i]));
        return sb.toString();
    }

    public static String randomString(int len) {
        return Help.randomString(ArrayConstant.CHAR_ARRAY_62, len);
    }

    public static String randomNumber(int len) {
        StringBuilder sb = new StringBuilder(len);
        ThreadLocalRandom.current().ints(len, 0, 10).forEach(sb::append);
        return sb.toString();
    }

    public static double setScale(double val, int scale) {
        BigDecimal result = new BigDecimal(Double.toString(val));
        if (result.scale() > scale) {
            result = result.setScale(scale, 4);
        }
        return result.doubleValue();
    }

    public static String increment(String s, char[] arrayX) {
        char[] array = s.toCharArray();
        if (array.length == 0) {
            return s;
        }
        return Help.increment0(array, array.length - 1, arrayX);
    }

    private static String increment0(char[] array, int idx, char[] arrayX) {
        int index = Help.indexOf(array[idx], arrayX);
        if (index != arrayX.length - 1) {
            array[idx] = arrayX[index + 1];
            return new String(array);
        }
        if (idx == 0) {
            array[0] = arrayX[0];
            return arrayX[1] + new String(array);
        }
        array[idx] = arrayX[0];
        return Help.increment0(array, idx - 1, arrayX);
    }

    public static int indexOf(char c, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T t, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], t)) continue;
            return i;
        }
        return -1;
    }

    public static String increment(String s) {
        return Help.increment(s, ArrayConstant.CHAR_ARRAY_62);
    }

    public static String decrement(String s, char[] arrayX) {
        char[] array = s.toCharArray();
        if (array.length == 0) {
            return s;
        }
        return Help.decrement0(array, array.length - 1, arrayX);
    }

    private static String decrement0(char[] array, int idx, char[] arrayX) {
        int index = Help.indexOf(array[idx], arrayX);
        if (index != 0) {
            array[idx] = arrayX[index - 1];
            return new String(array);
        }
        if (idx == 0) {
            return new String(array, 1, array.length - 1);
        }
        array[idx] = arrayX[arrayX.length - 1];
        return Help.decrement0(array, idx - 1, arrayX);
    }

    public static String decrement(String s) {
        return Help.decrement(s, ArrayConstant.CHAR_ARRAY_62);
    }

    private static int compare(String s1, String s2, char[] arrayX) {
        int len = s1.length();
        if (len - s2.length() != 0) {
            return len - s2.length();
        }
        char[] array1 = s1.toCharArray();
        char[] array2 = s2.toCharArray();
        for (int i = 0; i < len; ++i) {
            int delta = Help.indexOf(array1[i], arrayX) - Help.indexOf(array2[i], arrayX);
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    public static boolean gt(String s1, String s2, char[] arrayX) {
        return Help.compare(s1, s2, arrayX) > 0;
    }

    public static boolean gt(String s1, String s2) {
        return Help.compare(s1, s2, ArrayConstant.CHAR_ARRAY_62) > 0;
    }

    public static boolean ge(String s1, String s2, char[] arrayX) {
        return Help.compare(s1, s2, arrayX) >= 0;
    }

    public static boolean ge(String s1, String s2) {
        return Help.compare(s1, s2, ArrayConstant.CHAR_ARRAY_62) >= 0;
    }

    public static long stringToLong(String s, char[] arrayX) {
        char[] array = s.toCharArray();
        if (array.length == 0) {
            return -1L;
        }
        return Help.stringToLong0(array, array.length - 1, arrayX);
    }

    private static long stringToLong0(char[] array, int idx, char[] arrayX) {
        int index = Help.indexOf(array[idx], arrayX);
        if (idx == 0) {
            return (long)((double)index * Math.pow(arrayX.length, array.length - 1));
        }
        return (long)((double)index * Math.pow(arrayX.length, array.length - 1 - idx)) + Help.stringToLong0(array, --idx, arrayX);
    }

    public static long stringToLong(String s) {
        return Help.stringToLong(s, ArrayConstant.CHAR_ARRAY_62);
    }

    public static String longToString(long value, char[] arrayX) {
        if (value < (long)arrayX.length) {
            return arrayX[(int)value] + "";
        }
        int idx = 2;
        while (Math.pow(arrayX.length, idx) < (double)value) {
            ++idx;
        }
        StringBuilder sb = new StringBuilder(idx);
        Help.longToString0(value, arrayX, idx - 1, sb);
        return sb.toString();
    }

    private static void longToString0(long value, char[] arrayX, int idx, StringBuilder sb) {
        long next;
        if (idx == 0) {
            sb.append(arrayX[(int)value]);
            return;
        }
        int index = 0;
        long current = 0L;
        while ((next = (long)((double)index * Math.pow(arrayX.length, idx))) < value) {
            current = next;
            ++index;
        }
        if (index == 0) {
            for (int i = 0; i <= idx; ++i) {
                sb.append(arrayX[0]);
            }
        } else {
            sb.append(arrayX[index - 1]);
            Help.longToString0(value - current, arrayX, idx - 1, sb);
        }
    }

    public static String longToString(long value) {
        return Help.longToString(value, ArrayConstant.CHAR_ARRAY_62);
    }

    public static String add(String s1, String s2, char[] arrayX) {
        if (s1.length() == 0) {
            return s2;
        }
        if (s2.length() == 0) {
            return s1;
        }
        if (s1.length() < s2.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        char[] lmax = s1.toCharArray();
        char[] lmin = s2.toCharArray();
        int i = lmax.length - 1;
        int[] carry = new int[1];
        for (int j = lmin.length - 1; j >= 0; --j) {
            Help.add0(lmax, i, lmin[j], arrayX, carry);
            --i;
        }
        if (carry[0] == 1) {
            return arrayX[1] + new String(lmax);
        }
        return new String(lmax);
    }

    private static void add0(char[] lmax, int i, char c, char[] arrayX, int[] carry) {
        if (i == -1) {
            carry[0] = 1;
            return;
        }
        int idx = Help.indexOf(lmax[i], arrayX) + Help.indexOf(c, arrayX);
        if (idx <= arrayX.length - 1) {
            lmax[i] = arrayX[idx];
        } else {
            lmax[i] = arrayX[idx - arrayX.length];
            Help.add0(lmax, --i, arrayX[1], arrayX, carry);
        }
    }

    public static String add(String s1, String s2) {
        return Help.add(s1, s2, ArrayConstant.CHAR_ARRAY_62);
    }

    public static String minus(String s1, String s2, char[] arrayX) {
        String temp;
        if (s1.length() == 0) {
            return s2;
        }
        if (s2.length() == 0) {
            return s1;
        }
        if (s1.length() < s2.length()) {
            temp = s1;
            s1 = s2;
            s2 = temp;
        } else if (s1.length() == s2.length() && Help.stringToLong(s1, arrayX) < Help.stringToLong(s2, arrayX)) {
            temp = s1;
            s1 = s2;
            s2 = temp;
        }
        char[] lmax = s1.toCharArray();
        char[] lmin = s2.toCharArray();
        int i = lmax.length - 1;
        for (int j = lmin.length - 1; j >= 0; --j) {
            Help.minus0(lmax, i, lmin[j], arrayX);
            --i;
        }
        int L = 0;
        for (i = 0; i < lmax.length && Help.indexOf(lmax[i], arrayX) == 0; ++i) {
            ++L;
        }
        if (L == 0) {
            return new String(lmax);
        }
        if (L == lmax.length) {
            return arrayX[0] + "";
        }
        return new String(lmax, L, lmax.length - L);
    }

    private static void minus0(char[] lmax, int i, char c, char[] arrayX) {
        int idx = Help.indexOf(lmax[i], arrayX) - Help.indexOf(c, arrayX);
        if (idx >= 0) {
            lmax[i] = arrayX[idx];
        } else {
            lmax[i] = arrayX[idx + arrayX.length];
            Help.minus0(lmax, --i, arrayX[1], arrayX);
        }
    }

    public static String minus(String s1, String s2) {
        return Help.minus(s1, s2, ArrayConstant.CHAR_ARRAY_62);
    }

    public static int distance(String s1, String s2) {
        int i;
        if (Validator.isAnyBlank((Object)s1, (Object)s2)) {
            return -1;
        }
        char[] a1 = s1.toCharArray();
        char[] a2 = s2.toCharArray();
        int[][] dp = new int[a1.length][a2.length];
        dp[0][0] = a1[0] == a2[0] ? 0 : 1;
        for (i = 1; i < a1.length; ++i) {
            dp[i][0] = a1[i] == a2[0] ? i : dp[i - 1][0] + 1;
        }
        for (i = 1; i < a2.length; ++i) {
            dp[0][i] = a2[i] == a1[0] ? i : dp[0][i - 1] + 1;
        }
        for (i = 1; i < a1.length; ++i) {
            for (int j = 1; j < a2.length; ++j) {
                dp[i][j] = a1[i] == a2[j] ? dp[i - 1][j - 1] : Math.min(dp[i - 1][j - 1], Math.min(dp[i][j - 1], dp[i - 1][j])) + 1;
            }
        }
        return dp[a1.length - 1][a2.length - 1];
    }

    public static int[] toIntArray(CharSequence cs, int len) {
        if (cs == null) {
            return ArrayConstant.EMPTY_INT_ARRAY;
        }
        return cs.chars().limit(len < 0 ? (long)cs.length() : (long)Math.min(cs.length(), len)).toArray();
    }

    public static int[] toIntArray(CharSequence cs) {
        return Help.toIntArray(cs, -1);
    }

    public static char[] toCharArray(int[] array) {
        if (Validator.isEmpty(array)) {
            return ArrayConstant.EMPTY_CHAR_ARRAY;
        }
        char[] charArray = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            charArray[i] = (char)array[i];
        }
        return charArray;
    }

    public static char[] toCharArray(List<Character> list) {
        if (Validator.isEmpty(list)) {
            return ArrayConstant.EMPTY_CHAR_ARRAY;
        }
        char[] charArray = new char[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            charArray[i] = list.get(i).charValue();
        }
        return charArray;
    }

    public static String fromScientific(String numeric, int idx) {
        int dot = numeric.indexOf(".");
        if (idx == 0) {
            return numeric;
        }
        int len = numeric.length();
        if (idx > 0) {
            if (dot == -1) {
                char[] array = new char[len + idx];
                numeric.getChars(0, len, array, 0);
                for (int i = len; i < array.length; ++i) {
                    array[i] = 48;
                }
                return new String(array);
            }
            int len0 = dot + 1 + idx;
            if (len <= len0) {
                char[] array = new char[len0 - 1];
                numeric.getChars(0, dot, array, 0);
                numeric.getChars(dot + 1, len, array, dot);
                if (len < len0) {
                    for (int i = len - 1; i < dot + idx; ++i) {
                        array[i] = 48;
                    }
                }
                return new String(array);
            }
            char[] array = new char[len];
            numeric.getChars(0, dot, array, 0);
            numeric.getChars(dot + 1, len0, array, dot);
            array[dot + idx] = 46;
            numeric.getChars(len0, len, array, len0);
            return new String(array);
        }
        idx = -idx;
        if (dot == -1) {
            if (idx < len) {
                char[] array = new char[len + 1];
                numeric.getChars(0, len - idx, array, 0);
                array[len - idx] = 46;
                numeric.getChars(len - idx, len, array, len - idx + 1);
                return new String(array);
            }
            char[] array = new char[idx + 2];
            numeric.getChars(0, len, array, idx - len + 2);
            array[0] = 48;
            array[1] = 46;
            for (int i = 2; i < idx - len + 2; ++i) {
                array[i] = 48;
            }
            return new String(array);
        }
        if (idx < dot) {
            char[] array = new char[len];
            numeric.getChars(0, dot - idx, array, 0);
            array[dot - idx] = 46;
            numeric.getChars(dot - idx, dot, array, dot - idx + 1);
            numeric.getChars(dot + 1, len, array, dot + 1);
            return new String(array);
        }
        char[] array = new char[len + idx - dot + 1];
        numeric.getChars(0, dot, array, idx - dot + 2);
        numeric.getChars(dot + 1, len, array, idx + 2);
        array[0] = 48;
        array[1] = 46;
        for (int i = 2; i < idx - dot + 2; ++i) {
            array[i] = 48;
        }
        return new String(array);
    }

    public static String fromScientific(String s) {
        String[] split;
        if (Validator.isBlank(s) || !s.contains("E") && !s.contains("e")) {
            return s;
        }
        String[] stringArray = split = !s.contains("E") ? s.split("e") : s.split("E");
        if (split.length != 2) {
            return s;
        }
        if (!Pattern.matches("^0|[\\-]?(?:0\\.\\d+|[1-9]\\d*(?:\\.\\d+)?)$", split[0]) || !Pattern.matches("^0|-128|[\\-]?(?:[1-9]|[1-9]\\d|1[01]\\d|12[0-7])$", split[1])) {
            return s;
        }
        return Help.fromScientific(split[0], Integer.parseInt(split[1]));
    }

    public static int pwdScore(String s) {
        char[] array = s.toCharArray();
        int len = array.length;
        int socre = len <= 4 ? 5 : (len <= 7 ? 10 : (len <= 12 ? 25 : 29));
        boolean L = false;
        boolean U = false;
        int D = 0;
        int S = 0;
        for (int i = 0; i < len; ++i) {
            if (Help.indexOf(array[i], ArrayConstant.CHAR_LOWERCASE) != -1) {
                L = true;
            } else if (Help.indexOf(array[i], ArrayConstant.CHAR_UPPERCASE) != -1) {
                U = true;
            } else if (Help.indexOf(array[i], ArrayConstant.CHAR_ARRAY_10) != -1) {
                ++D;
            } else if (Help.indexOf(array[i], ArrayConstant.CHAR_SYMBOL) != -1) {
                ++S;
            }
            if (!L || !U || D <= true || S <= true) continue;
            return socre + 70;
        }
        if (L && U) {
            socre += 20;
        } else if (L || U) {
            socre += 10;
        }
        if (D > 1) {
            socre += 20;
        } else if (D == 1) {
            socre += 10;
        }
        if (S > 1) {
            socre += 25;
        } else if (S == 1) {
            socre += 10;
        }
        if (L && U && D > 0 && S > 0) {
            socre += 5;
        } else if ((L || U) && D > 0 && S > 0) {
            socre += 3;
        } else if ((L || U) && D > 0) {
            socre += 2;
        }
        return socre;
    }

    public static Number eval(String expression) {
        char[] a = expression.toCharArray();
        LArrayStack<Serializable> data = LArrayStack.of();
        LArrayStack<Object> calc = LArrayStack.of();
        for (char c : a) {
            if (c == ')' || c == '\uff09') {
                char c1;
                Object pop;
                while (!data.isEmpty() && (!((pop = data.pop()) instanceof Character) || (c1 = ((Character)pop).charValue()) != '(' && c1 != '\uff08')) {
                    calc.push(pop);
                }
                data.push(Help.eval0(calc));
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            data.push(Character.valueOf(c));
        }
        while (!data.isEmpty()) {
            calc.push(data.pop());
        }
        return Help.eval0(calc);
    }

    private static Number eval0(LArrayStack<Object> calc) {
        while (!calc.isEmpty()) {
            char nextOp;
            BigDecimal num = Help.getNumber(calc);
            if (calc.isEmpty()) {
                return num;
            }
            char op = ((Character)calc.pop()).charValue();
            BigDecimal nextNum = Help.getNumber(calc);
            if (calc.isEmpty()) {
                return Help.op(num, nextNum, op);
            }
            if (op == '*' || op == '/' || (nextOp = ((Character)calc.peek()).charValue()) == '+' || nextOp == '-') {
                calc.push(Help.op(num, nextNum, op));
                continue;
            }
            calc.pop();
            calc.push(Help.op(nextNum, Help.getNumber(calc), nextOp));
            calc.push(Character.valueOf(op));
            calc.push(num);
        }
        throw PRException.impossible();
    }

    private static BigDecimal getNumber(LArrayStack<Object> calc) {
        char c;
        if (calc.peek() instanceof BigDecimal) {
            return (BigDecimal)calc.pop();
        }
        StringBuilder sb = new StringBuilder();
        while (!calc.isEmpty() && ((c = ((Character)calc.peek()).charValue()) >= '0' && c <= '9' || c == '.')) {
            calc.pop();
            sb.append(c);
        }
        return new BigDecimal(sb.toString());
    }

    private static BigDecimal op(BigDecimal num1, BigDecimal num2, char op) {
        switch (op) {
            case '+': {
                return num1.add(num2);
            }
            case '-': {
                return num1.subtract(num2);
            }
            case '*': {
                return num1.multiply(num2);
            }
            case '/': {
                return num1.divide(num2, Math.max(num1.scale(), num2.scale()), RoundingMode.HALF_UP);
            }
        }
        throw PRException.of(ServerFailure.UnsupportedOperationException);
    }

    public static String toRmb(double value) {
        int end;
        String s = Double.toString(value);
        StringBuilder sb = new StringBuilder("\u4eba\u6c11\u5e01");
        char[] array = s.toCharArray();
        int dot = s.indexOf(46);
        dot = dot == -1 ? array.length : dot;
        boolean tail0 = false;
        if (dot != 1 || array[0] != '0') {
            Help.toRmb0(array, 0, dot, sb);
            boolean bl = tail0 = sb.charAt(sb.length() - 1) == DIGIT[0];
            if (tail0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(UNIT[0]);
            if (dot == array.length) {
                return sb.append('\u6574').toString();
            }
        }
        for (end = dot + 1 + Math.min(2, array.length - 1 - dot); end > 0 && array[end - 1] == '0'; --end) {
        }
        if (end == 0) {
            return sb.append('\u6574').toString();
        }
        if (tail0) {
            sb.append(DIGIT[0]);
        }
        for (int i = dot + 1; i < end; ++i) {
            if (array[i] == '0') continue;
            sb.append(DIGIT[array[i] - 48]).append(UNIT[i - dot]);
        }
        return sb.toString();
    }

    private static void toRmb0(char[] array, int L, int R, StringBuilder sb) {
        if (R - L >= 9) {
            Help.toRmb0(array, L, R - 8, sb);
            Help.dealRmb0(sb, INDEX[4]);
            Help.toRmb0(array, R - 8, R, sb);
            return;
        }
        if (R - L >= 5) {
            Help.toRmb0(array, L, R - 4, sb);
            Help.dealRmb0(sb, INDEX[3]);
            Help.toRmb0(array, R - 4, R, sb);
            return;
        }
        boolean mark0 = sb.charAt(sb.length() - 1) == DIGIT[0];
        for (int i = L; i < R; ++i) {
            if (array[i] == '0') {
                if (mark0) continue;
                sb.append(DIGIT[0]);
                mark0 = true;
                continue;
            }
            if (R - 2 - i > 0) {
                sb.append(DIGIT[array[i] - 48]).append(INDEX[R - 2 - i]);
            } else if (R - 2 - i == 0) {
                if (array[i] - 48 != 1) {
                    sb.append(DIGIT[array[i] - 48]).append(INDEX[0]);
                } else {
                    sb.append(INDEX[0]);
                }
            } else {
                sb.append(DIGIT[array[i] - 48]);
            }
            mark0 = false;
        }
    }

    private static void dealRmb0(StringBuilder sb, char c) {
        boolean tail0;
        boolean bl = tail0 = sb.charAt(sb.length() - 1) == DIGIT[0];
        if (tail0) {
            sb.deleteCharAt(sb.length() - 1);
            Help.appendRmbIndex0(sb, c);
            sb.append(DIGIT[0]);
        } else {
            Help.appendRmbIndex0(sb, c);
        }
    }

    private static void appendRmbIndex0(StringBuilder sb, char c) {
        char prev = sb.charAt(sb.length() - 1);
        int prev_idx = -1;
        int current_idx = -1;
        for (int i = 0; i < INDEX.length; ++i) {
            if (prev == INDEX[i]) {
                prev_idx = i;
            }
            if (c != INDEX[i]) continue;
            current_idx = i;
        }
        if (prev_idx <= current_idx) {
            sb.append(c);
        }
    }

    public static long gcd(long x, long y) {
        long m;
        if (x < y) {
            x ^= y;
            y ^= x;
            x ^= y;
        }
        while ((m = x % y) > 0L) {
            x = y;
            y = m;
        }
        return y;
    }

    public static long lcm(long x, long y) {
        return x * y / Help.gcd(x, y);
    }

    public static int[] whAndGcd(int w, int h, int count, int gcdLimit, boolean cut) {
        long tw = w;
        long th = h;
        int gcd = (int)Help.gcd(w, h);
        int state = 0;
        if (gcd < gcdLimit) {
            gcd <<= 1;
            state = 1;
        }
        while (tw * th / (long)(gcd * gcd) < (long)count) {
            if (state == 1) {
                if ((tw <<= 1) * (th <<= 1) <= Integer.MAX_VALUE) continue;
                tw >>= 1;
                th >>= 1;
                state = 2;
                continue;
            }
            gcd >>= 1;
            if (state == 0) {
                if (gcd >= gcdLimit) continue;
                gcd = gcd == 0 ? 1 : gcd << 1;
                state = 1;
                continue;
            }
            if (gcd != 0) continue;
            gcd = 1;
            state = 3;
            break;
        }
        while (tw * th / (long)(gcd * gcd) > (long)count) {
            if (state == 0) {
                gcd <<= 1;
                continue;
            }
            tw >>= 1;
            th >>= 1;
        }
        tw = tw == 0L ? 1L : tw;
        th = th == 0L ? 1L : th;
        int delta = count - (int)(tw * th / (long)(gcd * gcd));
        int cn = (int)(tw / (long)gcd);
        if (cn > 0) {
            th += (long)(delta / cn * gcd);
            if (!cut && delta % cn > 0) {
                th += (long)gcd;
            }
        }
        return new int[]{(int)tw, (int)th, gcd};
    }

    public static boolean isPrime(long x) {
        if (x == 2L) {
            return true;
        }
        if (x < 2L || (x & 1L) == 0L) {
            return false;
        }
        double sqrt = Math.sqrt(x);
        int i = 3;
        while ((double)i <= sqrt) {
            if (x % (long)i == 0L) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public static long arithmeticSequenceSum(long start, int step, int n) {
        if (n <= 0) {
            return 0L;
        }
        return start + Help.arithmeticSequenceSum(start + (long)step, step, --n);
    }

    public static long permutation(int n, int m) {
        if (m == 1) {
            return n;
        }
        return (long)n * Help.permutation(n - 1, m - 1);
    }

    public static <E> void permutation(E[] es, int m, Consumer<E[]> consumer, AtomicBoolean stop) {
        Help.permutation0(es, Arrays.copyOf(es, m), 0, new boolean[es.length], consumer, stop);
    }

    private static <E> void permutation0(E[] es, E[] a, int idx, boolean[] book, Consumer<E[]> consumer, AtomicBoolean stop) {
        if (idx == a.length) {
            consumer.accept(a);
            return;
        }
        for (int i = 0; i < es.length; ++i) {
            if (stop != null && stop.get()) {
                return;
            }
            if (book[i]) continue;
            a[idx] = es[i];
            book[i] = true;
            Help.permutation0(es, a, idx + 1, book, consumer, stop);
            book[i] = false;
        }
    }

    public static <E> void permutationRepeat(E[] es, int m, Consumer<E[]> consumer, AtomicBoolean stop) {
        Help.permutationRepeat0(es, Arrays.copyOf(es, m), 0, consumer, stop);
    }

    private static <E> void permutationRepeat0(E[] es, E[] a, int idx, Consumer<E[]> consumer, AtomicBoolean stop) {
        if (idx == a.length) {
            consumer.accept(a);
            return;
        }
        for (E e : es) {
            if (stop != null && stop.get()) {
                return;
            }
            a[idx] = e;
            Help.permutationRepeat0(es, a, idx + 1, consumer, stop);
        }
    }

    public static void permutation(char[] es, int m, Consumer<char[]> consumer, AtomicBoolean stop) {
        Help.permutation0(es, Arrays.copyOf(es, m), 0, new boolean[es.length], consumer, stop);
    }

    private static void permutation0(char[] es, char[] a, int idx, boolean[] book, Consumer<char[]> consumer, AtomicBoolean stop) {
        if (idx == a.length) {
            consumer.accept(a);
            return;
        }
        for (int i = 0; i < es.length; ++i) {
            if (stop != null && stop.get()) {
                return;
            }
            if (book[i]) continue;
            a[idx] = es[i];
            book[i] = true;
            Help.permutation0(es, a, idx + 1, book, consumer, stop);
            book[i] = false;
        }
    }

    public static void permutationRepeat(char[] es, int m, Consumer<char[]> consumer, AtomicBoolean stop) {
        Help.permutationRepeat0(es, Arrays.copyOf(es, m), 0, consumer, stop);
    }

    private static void permutationRepeat0(char[] es, char[] a, int idx, Consumer<char[]> consumer, AtomicBoolean stop) {
        if (idx == a.length) {
            consumer.accept(a);
            return;
        }
        for (char e : es) {
            if (stop != null && stop.get()) {
                return;
            }
            a[idx] = e;
            Help.permutationRepeat0(es, a, idx + 1, consumer, stop);
        }
    }

    public static long combination(int n, int m) {
        return Help.combination0(n, m > n >> 1 ? n - m : m);
    }

    private static long combination0(int n, int m) {
        if (n == m) {
            return 1L;
        }
        if (m == 1) {
            return n;
        }
        return Help.combination0(n - 1, m) + Help.combination0(n - 1, m - 1);
    }

    public static <E> void combination(E[] es, int m, Consumer<E[]> consumer, AtomicBoolean stop) {
        if (m == es.length) {
            consumer.accept(es);
            return;
        }
        Help.combination0(es, Arrays.copyOf(es, m), 0, 0, consumer, stop);
    }

    private static <E> void combination0(E[] es, E[] a, int idx, int L, Consumer<E[]> consumer, AtomicBoolean stop) {
        if (idx == a.length) {
            consumer.accept(a);
            return;
        }
        for (int i = L; i < es.length; ++i) {
            if (stop != null && stop.get()) {
                return;
            }
            a[idx] = es[i];
            Help.combination0(es, a, idx + 1, i + 1, consumer, stop);
        }
    }

    public static void combination(char[] es, int m, Consumer<char[]> consumer, AtomicBoolean stop) {
        if (m == es.length) {
            consumer.accept(es);
            return;
        }
        Help.combination0(es, Arrays.copyOf(es, m), 0, 0, consumer, stop);
    }

    private static void combination0(char[] es, char[] a, int idx, int L, Consumer<char[]> consumer, AtomicBoolean stop) {
        if (idx == a.length) {
            consumer.accept(a);
            return;
        }
        for (int i = L; i < es.length; ++i) {
            if (stop != null && stop.get()) {
                return;
            }
            a[idx] = es[i];
            Help.combination0(es, a, idx + 1, i + 1, consumer, stop);
        }
    }

    public static String matchOne(String s, int min, int max, char[] array, Function<String, String> func) {
        if (Validator.isBlank(s) || min <= 0 || max < min) {
            return null;
        }
        AtomicReference result = new AtomicReference();
        AtomicBoolean stop = new AtomicBoolean();
        for (int i = min; i <= max && !stop.get(); ++i) {
            Help.permutationRepeat(array, i, (char[] chars) -> {
                String str = new String((char[])chars);
                if (s.equals(func.apply(str))) {
                    result.set(str);
                    stop.set(true);
                }
            }, stop);
        }
        return (String)result.get();
    }

    public static String matchOne(String s, int min, int max, Function<String, String> func) {
        return Help.matchOne(s, min, max, ArrayConstant.CHAR_ARRAY_94, func);
    }

    public static int atoi(String s) {
        if (Validator.isBlank(s)) {
            return 0;
        }
        char[] array = s.toCharArray();
        char head = array[0];
        if ((head < '0' || head > '9') && head != '-' && head != '+') {
            return 0;
        }
        int flag = head == '-' ? -1 : 1;
        long unresult = head == '-' || head == '+' ? 0L : (long)(head - 48);
        long result = (long)flag * unresult;
        int len = array.length;
        for (int i = 1; i < len && array[i] >= '0' && array[i] <= '9'; ++i) {
            result = (long)flag * (unresult = unresult * 10L + (long)(array[i] - 48));
            if (result >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (result > Integer.MIN_VALUE) continue;
            return Integer.MIN_VALUE;
        }
        return (int)result;
    }

    public static String format(int capacity, String format, Object ... args) {
        if (Validator.isBlank(format) || Validator.isEmpty(args)) {
            return format;
        }
        return new Formatter(new StringBuilder(capacity)).format(format, args).toString();
    }

    public static String format(String format, Object ... args) {
        return Help.format(format.length() + 50, format, args);
    }

    public static int toIntIp(String ip) {
        String[] a = ip.split("\\.");
        return (int)(Long.parseLong(a[0]) << 24 | Long.parseLong(a[1]) << 16 | Long.parseLong(a[2]) << 8 | Long.parseLong(a[3]));
    }

    public static String toStrIp(int ip) {
        return Integer.toString(ip >> 24 & 0xFF) + '.' + (ip >> 16 & 0xFF) + '.' + (ip >> 8 & 0xFF) + '.' + (ip & 0xFF);
    }

    public static boolean hasConfig(long config, int value) {
        return (config & 1L << value) != 0L;
    }

    public static long addConfig(long config, int value) {
        return config | 1L << value;
    }

    public static long removeConfig(long config, int value) {
        return config & (1L << value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean hasConfig(long config, int ... values) {
        return Arrays.stream(values).parallel().allMatch(value -> Help.hasConfig(config, value));
    }

    public static long addConfig(long config, int ... values) {
        for (int value : values) {
            config = Help.addConfig(config, value);
        }
        return config;
    }

    public static long removeConfig(long config, int ... values) {
        for (int value : values) {
            config = Help.removeConfig(config, value);
        }
        return config;
    }

    public static boolean hasConfig(long config, List<Byte> values) {
        return values.parallelStream().allMatch(value -> Help.hasConfig(config, (int)value.byteValue()));
    }

    public static long addConfig(long config, List<Byte> values) {
        for (byte value : values) {
            config = Help.addConfig(config, (int)value);
        }
        return config;
    }

    public static long removeConfig(long config, List<Byte> values) {
        for (byte value : values) {
            config = Help.removeConfig(config, (int)value);
        }
        return config;
    }

    public static boolean hasConfig(Map<Integer, Long> configs, int value) {
        Long config = configs.get(value / 64);
        return config != null && Help.hasConfig((long)config, value % 64);
    }

    public static int addConfig(Map<Integer, Long> configs, int value) {
        int idx = value / 64;
        Long config = configs.get(idx);
        configs.put(idx, Help.addConfig(config == null ? 0L : config, value % 64));
        return idx;
    }

    public static int removeConfig(Map<Integer, Long> configs, int value) {
        int idx = value / 64;
        Long config = configs.get(idx);
        if (config == null) {
            return -1;
        }
        configs.put(idx, Help.removeConfig((long)config, value % 64));
        return idx;
    }

    public static boolean hasConfig(Map<Integer, Long> configs, int ... values) {
        return Arrays.stream(values).parallel().allMatch(value -> Help.hasConfig(configs, value));
    }

    public static Map<Integer, Long> addConfig(Map<Integer, Long> configs, int ... values) {
        int count = (int)Arrays.stream(values).map(value -> value / 64).distinct().count();
        Map update = (Map)ToMap.get(count).build();
        for (int value2 : values) {
            int idx = value2 / 64;
            Long config = (Long)update.get(idx);
            if (config == null) {
                config = configs.get(idx);
            }
            update.put(idx, Help.addConfig(config == null ? 0L : config, value2 % 64));
        }
        return update;
    }

    public static Map<Integer, Long> removeConfig(Map<Integer, Long> configs, int ... values) {
        int count = (int)Arrays.stream(values).map(value -> value / 64).distinct().count();
        Map update = (Map)ToMap.get(count).build();
        for (int value2 : values) {
            int idx = value2 / 64;
            Long config = (Long)update.get(idx);
            if (config == null && (config = configs.get(idx)) == null) continue;
            update.put(idx, Help.removeConfig((long)config, value2 % 64));
        }
        return update;
    }

    public static boolean hasConfig(Map<Integer, Long> configs, List<Integer> values) {
        return values.parallelStream().allMatch(value -> Help.hasConfig(configs, (int)value));
    }

    public static Map<Integer, Long> addConfig(Map<Integer, Long> configs, List<Integer> values) {
        return Help.addConfig(configs, values.stream().mapToInt(value -> value).toArray());
    }

    public static Map<Integer, Long> removeConfig(Map<Integer, Long> configs, List<Integer> values) {
        return Help.removeConfig(configs, values.stream().mapToInt(value -> value).toArray());
    }

    public static boolean hasConfig(Map<Integer, Long> configs, Map<Integer, Long> others) {
        if (others.size() > configs.size()) {
            return false;
        }
        for (Map.Entry<Integer, Long> kv : others.entrySet()) {
            Long other = kv.getValue();
            if (other == null) continue;
            Long config = configs.get(kv.getKey());
            if (config == null) {
                return false;
            }
            if ((other ^ config & other) == 0L) continue;
            return false;
        }
        return true;
    }

    public static Map<Integer, Long> addConfig(Map<Integer, Long> configs, Map<Integer, Long> others) {
        Map update = (Map)ToMap.get(others.size(), 1).build();
        others.forEach((idx, value) -> {
            if (value == null) {
                return;
            }
            Long config = (Long)update.get(idx);
            if (config == null) {
                config = (Long)configs.get(idx);
            }
            update.put(idx, config == null ? value : config | value);
        });
        return update;
    }

    public static Map<Integer, Long> removeConfig(Map<Integer, Long> configs, Map<Integer, Long> others) {
        Map update = (Map)ToMap.get(others.size(), 1).build();
        others.forEach((idx, value) -> {
            if (value == null) {
                return;
            }
            Long config = (Long)update.get(idx);
            if (config == null && (config = (Long)configs.get(idx)) == null) {
                return;
            }
            update.put(idx, config ^ config & value);
        });
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void smooth(long timeMillis, List<T> list, Consumer<T> consumer) {
        if (list == null || consumer == null) {
            return;
        }
        int idx = 0;
        while (idx < list.size()) {
            try {
                if (timeMillis <= 0L) {
                    consumer.accept(list.get(idx));
                    continue;
                }
                long start = System.currentTimeMillis();
                consumer.accept(list.get(idx));
                long timeout = start + timeMillis / (long)(list.size() - idx) - System.currentTimeMillis();
                if (timeout > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                timeMillis -= System.currentTimeMillis() - start;
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                ++idx;
            }
        }
    }

    public static <T, R> R casApply(T t, Function<T, R> func, AtomicInteger state, AtomicInteger count, int expect, int lock, long sleep) {
        R r;
        block6: {
            r = null;
            while (true) {
                if (state.get() != lock && !state.compareAndSet(expect, lock)) {
                    if (sleep <= 0L) continue;
                    try {
                        TimeUnit.MILLISECONDS.sleep(sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                count.incrementAndGet();
                if (state.get() != expect) break;
                count.decrementAndGet();
            }
            try {
                r = func.apply(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (count.decrementAndGet() != 0) break block6;
            state.set(expect);
        }
        return r;
    }

    public static <T> void casAccept(T t, Consumer<T> consumer, AtomicInteger state, AtomicInteger count, int expect, int lock, long sleep) {
        Help.casApply(t, u -> {
            consumer.accept(u);
            return null;
        }, state, count, expect, lock, sleep);
    }

    public static void translate(Object obj, Function<Object, Object> mapper) {
        Objects.requireNonNull(mapper);
        Object translateObj = mapper.apply(obj);
        if (Validator.isEmpty(translateObj)) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(translateObj);
        Map<String, TranslateEnum> translateEnumMap = Help.translateEnumMap(translateObj.getClass());
        while (!queue.isEmpty()) {
            Object poll;
            Map<String, TranslateEnum> translateEnumMap0 = Help.translateEnumMap((poll = queue.poll()).getClass());
            Help.translate0(queue, poll, mapper, Validator.isEmpty(translateEnumMap0) ? translateEnumMap : translateEnumMap0);
        }
    }

    private static Map<String, TranslateEnum> translateEnumMap(Class<?> cls) {
        if (cls == null) {
            return Collections.emptyMap();
        }
        return TRANSLATE_ENUM_CACHE.computeIfAbsent(cls, k -> {
            TranslateType typeTranslateType = cls.getAnnotation(TranslateType.class);
            if (typeTranslateType == null) {
                return Collections.emptyMap();
            }
            List typeTs = AccessibleHelp.enumSet(typeTranslateType.value());
            if (typeTs.isEmpty()) {
                return Collections.emptyMap();
            }
            return ToMap.explicitCollect(typeTs.stream().map(e -> (TranslateEnum)e), IEnum::name, Function.identity(), typeTs.size());
        });
    }

    private static void translate0(Queue<Object> queue, Object obj, Function<Object, Object> mapper, Map<String, TranslateEnum> translateMap) {
        Class<?> cls = obj.getClass();
        if (Collection.class.isAssignableFrom(cls)) {
            Collection collection = (Collection)obj;
            queue.addAll(ToList.explicitCollect(collection.stream().filter(Help::filter).map(mapper), collection.size()));
            return;
        }
        if (Map.class.isAssignableFrom(cls)) {
            Collection collection = ((Map)obj).values();
            queue.addAll(ToList.explicitCollect(collection.stream().filter(Help::filter).map(mapper), collection.size()));
            return;
        }
        if (Object[].class.isAssignableFrom(cls)) {
            List<Object> collection = Arrays.asList((Object[])obj);
            queue.addAll(ToList.explicitCollect(collection.stream().filter(Help::filter).map(mapper), collection.size()));
            return;
        }
        if (Validator.isEmpty(translateMap) || AccessibleHelp.isCommon(cls)) {
            return;
        }
        AccessibleHelp.setField(obj, f -> {
            TranslateEnum translateEnum;
            TranslateName translateName = f.getAnnotation(TranslateName.class);
            if (translateName == null) {
                return NullConstant.OBJECT;
            }
            if (!CharSequence.class.isAssignableFrom(f.getType())) {
                return NullConstant.OBJECT;
            }
            Object value = AccessibleHelp.getField(f, obj);
            if (Validator.isEmpty(value)) {
                return NullConstant.OBJECT;
            }
            String enumName = Validator.isBlank(translateName.value()) ? f.getName() : translateName.value();
            TranslateType fieldTranslateType = f.getAnnotation(TranslateType.class);
            if (fieldTranslateType != null) {
                List filedTs = AccessibleHelp.enumSet(fieldTranslateType.value());
                if (filedTs.isEmpty()) {
                    return NullConstant.OBJECT;
                }
                translateEnum = filedTs.stream().map(e -> (TranslateEnum)e).filter(e -> enumName.equals(e.name())).findFirst().orElse(null);
            } else {
                translateEnum = (TranslateEnum)translateMap.get(enumName);
            }
            if (translateEnum == null) {
                return NullConstant.OBJECT;
            }
            Map<String, String> codeValueMap = translateEnum.codeValueMap();
            if (Validator.isEmpty(codeValueMap)) {
                return NullConstant.OBJECT;
            }
            String translateValue = codeValueMap.get(value);
            if (translateValue != null || codeValueMap.containsKey(value)) {
                return translateValue;
            }
            return NullConstant.OBJECT;
        });
    }

    private static boolean filter(Object value) {
        return Validator.nonEmpty(value) && !AccessibleHelp.isCommon(value.getClass());
    }

    public static void translate(Object obj) {
        Help.translate(obj, t -> t instanceof Response ? ((Response)t).payload : t);
    }
}

