/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import shz.Coder;
import shz.Help;
import shz.IOHelp;
import shz.PRException;
import shz.ToMap;
import shz.Validator;
import shz.msg.FailureMsg;

public final class HttpHelp {
    private HttpHelp() {
        throw new IllegalStateException();
    }

    public static String jointUrl(String url, Map<String, ?> params) {
        if (Validator.isEmpty(params)) {
            return url;
        }
        StringBuilder sb = new StringBuilder();
        params.forEach((k, v) -> sb.append("&").append(Coder.urlEncode(k)).append("=").append(Coder.urlEncode(String.valueOf(v))));
        return url.contains("?") ? url + sb.toString() : url + "?" + sb.substring(1);
    }

    public static InputStream requestIs(String url, Supplier<SSLContext> sslContext, Map<String, String> header, String method, byte[] body, String proxyHost, int proxyPort, int connectTimeout, int readTimeout) {
        try {
            SSLContext ssl;
            HttpURLConnection conn;
            URL uri = new URL(url);
            if (Validator.nonBlank(proxyHost) && proxyPort > 0) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                conn = (HttpURLConnection)uri.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)uri.openConnection();
            }
            if (sslContext != null && conn instanceof HttpsURLConnection && (ssl = sslContext.get()) != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(ssl.getSocketFactory());
            }
            if (Validator.nonEmpty(header)) {
                header.forEach(conn::setRequestProperty);
            }
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(method);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (Validator.nonEmpty(body)) {
                conn.setDoOutput(true);
                conn.getOutputStream().write(body);
            }
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw PRException.of(FailureMsg.fail(responseCode, conn.getResponseMessage()));
            }
            return conn.getInputStream();
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public static InputStream requestIs(String url, Map<String, String> header, String method, byte[] body) {
        return HttpHelp.requestIs(url, () -> HttpHelp.getDefaultSSLContext(new Certificate[0]), header, method, body, null, 0, 10000, 10000);
    }

    public static SSLContext getDefaultSSLContext(Certificate ... certificates) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, (TrustManager[])Arrays.stream(certificates).map(SSL509TrustManager::new).toArray(SSL509TrustManager[]::new), null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String request(String url, Supplier<SSLContext> sslContext, Map<String, String> header, String method, byte[] body, String proxyHost, int proxyPort, int connectTimeout, int readTimeout, Charset charset) {
        InputStream is = HttpHelp.requestIs(url, sslContext, header, method, body, proxyHost, proxyPort, connectTimeout, readTimeout);
        StringWriter sw = new StringWriter();
        IOHelp.read(IOHelp.getBr(is, charset), sw);
        return sw.toString();
    }

    public static String request(String url, Map<String, String> header, String method, byte[] body) {
        return HttpHelp.request(url, () -> HttpHelp.getDefaultSSLContext(new Certificate[0]), header, method, body, null, 0, 10000, 10000, StandardCharsets.UTF_8);
    }

    public static String get(String url, Map<String, String> header) {
        return HttpHelp.request(url, header, "GET", null);
    }

    public static String head(String url, Map<String, String> header) {
        return HttpHelp.request(url, header, "HEAD", null);
    }

    public static String post(String url, Map<String, String> header, byte[] body) {
        return HttpHelp.request(url, header, "POST", body);
    }

    public static String put(String url, Map<String, String> header, byte[] body) {
        return HttpHelp.request(url, header, "PUT", body);
    }

    public static String patch(String url, Map<String, String> header, byte[] body) {
        return HttpHelp.request(url, header, "PATCH", body);
    }

    public static String delete(String url, Map<String, String> header) {
        return HttpHelp.request(url, header, "DELETE", null);
    }

    public static String options(String url, Map<String, String> header) {
        return HttpHelp.request(url, header, "OPTIONS", null);
    }

    public static String trace(String url, Map<String, String> header, byte[] body) {
        return HttpHelp.request(url, header, "TRACE", body);
    }

    public static String connect(String url, Map<String, String> header) {
        return HttpHelp.request(url, header, "CONNECT", null);
    }

    public static String uploadMultipartFile(String url, String name, byte[] bytes, String filename) {
        String boundary = Help.uuid();
        Map headers = (Map)ToMap.get(4).put("Accept", "*/*").put("Transfer-Encoding", "gzip,deflate,binary").put("Connection", "keep-alive").put("Content-Type", "multipart/form-data; boundary=" + boundary).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(("--" + boundary + "\r\n").getBytes());
            baos.write(("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + filename + "\"\r\n").getBytes());
            baos.write("\r\n".getBytes());
            baos.write(bytes);
            baos.write("\r\n".getBytes());
            baos.write(("--" + boundary + "--\r\n").getBytes());
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        return HttpHelp.post(url, headers, baos.toByteArray());
    }

    public static String uploadMultipartFile(String url, byte[] bytes, String filename) {
        return HttpHelp.uploadMultipartFile(url, "file", bytes, filename);
    }

    private static final class SSL509TrustManager
    implements X509TrustManager {
        private final Certificate certificate;

        SSL509TrustManager(Certificate certificate) {
            this.certificate = certificate;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509Certificate cert : chain) {
                cert.checkValidity();
                try {
                    cert.verify(this.certificate.getPublicKey());
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
                    throw PRException.of(e);
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

