/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import shz.FileHelp;
import shz.PRException;
import shz.Validator;
import shz.ZipHelp;
import shz.msg.ServerFailureMsg;

public final class IOHelp {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_DATA_SIZE = 1024;

    private IOHelp() {
        throw new IllegalStateException();
    }

    public static InputStream getIsFromURL(URL url, String path, boolean tryFind, int dataSize, long timeout) {
        URL uRL = url = url == null ? Thread.currentThread().getContextClassLoader().getResource("") : url;
        assert (url != null);
        String protocol = url.getProtocol();
        try {
            URLConnection conn = url.openConnection();
            if ("file".equals(protocol)) {
                File file = FileHelp.fromUrl(conn.getURL());
                if (file.isFile()) {
                    if (FileHelp.equals(file, path)) {
                        return IOHelp.getBis(file);
                    }
                    return null;
                }
                if ((file = new File(file, path)).exists() && file.isFile() && file.canRead()) {
                    return IOHelp.getBis(file);
                }
                return IOHelp.getBis(FileHelp.findFile(path, tryFind, Collections.singletonList(file.getAbsolutePath()), null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout));
            }
            if ("jar".equals(protocol)) {
                JarFile jarFile = ((JarURLConnection)conn).getJarFile();
                return IOHelp.getBis(ZipHelp.getIsFromJarFile(jarFile, path, dataSize));
            }
            return IOHelp.getBis(conn.getInputStream());
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
    }

    public static InputStream getIsFromURL(URL url, String path, long timeout) {
        return IOHelp.getIsFromURL(url, path, true, 1024, timeout);
    }

    public static InputStream getIsFromURL(String path) {
        return IOHelp.getIsFromURL(null, path, true, 1024, 0L);
    }

    public static void flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Flushable f1, Flushable f2) {
        IOHelp.flush(f1);
        IOHelp.flush(f2);
    }

    public static void close(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable a1, AutoCloseable a2) {
        IOHelp.close(a1);
        IOHelp.close(a2);
    }

    public static void close(AutoCloseable a1, AutoCloseable a2, AutoCloseable a3) {
        IOHelp.close(a1);
        IOHelp.close(a2);
        IOHelp.close(a3);
    }

    public static BufferedInputStream getBis(InputStream is, int size) {
        return new BufferedInputStream(is, size);
    }

    public static BufferedInputStream getBis(InputStream is) {
        return IOHelp.getBis(is, 8192);
    }

    public static BufferedInputStream getBis(File file, int size) {
        return IOHelp.getBis(IOHelp.getFis(file), size);
    }

    private static FileInputStream getFis(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw PRException.of(e);
        }
    }

    public static BufferedInputStream getBis(File file) {
        return IOHelp.getBis(IOHelp.getFis(file), 8192);
    }

    public static BufferedInputStream getBis(String path, int size) {
        return IOHelp.getBis(IOHelp.getFis(new File(path)), size);
    }

    public static BufferedInputStream getBis(String path) {
        return IOHelp.getBis(IOHelp.getFis(new File(path)), 8192);
    }

    public static BufferedOutputStream getBos(OutputStream os, int size) {
        return new BufferedOutputStream(os, size);
    }

    public static BufferedOutputStream getBos(OutputStream os) {
        return IOHelp.getBos(os, 8192);
    }

    public static BufferedOutputStream getBos(File file, boolean append, int size) {
        return IOHelp.getBos(IOHelp.getFos(file, append), size);
    }

    private static FileOutputStream getFos(File file, boolean append) {
        try {
            return new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            throw PRException.of(e);
        }
    }

    public static BufferedOutputStream getBos(File file) {
        return IOHelp.getBos(IOHelp.getFos(file, false), 8192);
    }

    public static BufferedOutputStream getBos(String path, boolean append, int size) {
        return IOHelp.getBos(IOHelp.getFos(path, append), size);
    }

    private static FileOutputStream getFos(String path, boolean append) {
        try {
            return new FileOutputStream(path, append);
        }
        catch (FileNotFoundException e) {
            throw PRException.of(e);
        }
    }

    public static BufferedOutputStream getBos(String path) {
        return IOHelp.getBos(IOHelp.getFos(path, false), 8192);
    }

    public static BufferedReader getBr(InputStream is, Charset charset, int size) {
        return new BufferedReader(new InputStreamReader(is, charset), size);
    }

    public static BufferedReader getBr(InputStream is, Charset charset) {
        return IOHelp.getBr(is, charset, 8192);
    }

    public static BufferedReader getBr(InputStream is) {
        return IOHelp.getBr(is, StandardCharsets.UTF_8, 8192);
    }

    public static BufferedReader getBr(Reader reader, int size) {
        return new BufferedReader(reader, size);
    }

    public static BufferedReader getBr(Reader reader) {
        return IOHelp.getBr(reader, 8192);
    }

    public static BufferedReader getBr(File file, int size) {
        return IOHelp.getBr(IOHelp.getFr(file), size);
    }

    private static FileReader getFr(File file) {
        try {
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw PRException.of(e);
        }
    }

    public static BufferedReader getBr(File file) {
        return IOHelp.getBr(IOHelp.getFr(file), 8192);
    }

    public static BufferedReader getBr(String path, int size) {
        return IOHelp.getBr(IOHelp.getFr(new File(path)), size);
    }

    public static BufferedReader getBr(String path) {
        return IOHelp.getBr(IOHelp.getFr(new File(path)), 8192);
    }

    public static BufferedWriter getBw(OutputStream os, Charset charset, int size) {
        return new BufferedWriter(new OutputStreamWriter(os, charset), size);
    }

    public static BufferedWriter getBw(OutputStream os, Charset charset) {
        return IOHelp.getBw(os, charset, 8192);
    }

    public static BufferedWriter getBw(OutputStream os) {
        return IOHelp.getBw(os, StandardCharsets.UTF_8, 8192);
    }

    public static BufferedWriter getBw(Writer writer, int size) {
        return new BufferedWriter(writer, size);
    }

    public static BufferedWriter getBw(Writer writer) {
        return IOHelp.getBw(writer, 8192);
    }

    public static BufferedWriter getBw(File file, boolean append, int size) {
        return IOHelp.getBw(IOHelp.getFw(file, append), size);
    }

    private static FileWriter getFw(File file, boolean append) {
        try {
            return new FileWriter(file, append);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
    }

    public static BufferedWriter getBw(File file) {
        return IOHelp.getBw(IOHelp.getFw(file, false), 8192);
    }

    public static BufferedWriter getBw(String path, boolean append, int size) {
        return IOHelp.getBw(IOHelp.getFw(path, append), size);
    }

    private static FileWriter getFw(String path, boolean append) {
        try {
            return new FileWriter(path, append);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
    }

    public static BufferedWriter getBw(String path) {
        return IOHelp.getBw(IOHelp.getFw(path, false), 8192);
    }

    public static ZipInputStream getZis(InputStream is, Charset charset) {
        return new ZipInputStream(is, charset);
    }

    public static ZipInputStream getZis(InputStream is) {
        return IOHelp.getZis(is, StandardCharsets.UTF_8);
    }

    public static ZipInputStream getZis(File file, Charset charset) {
        return IOHelp.getZis(IOHelp.getFis(file), charset);
    }

    public static ZipInputStream getZis(File file) {
        return IOHelp.getZis(IOHelp.getFis(file), StandardCharsets.UTF_8);
    }

    public static ZipInputStream getZis(String path, Charset charset) {
        return IOHelp.getZis(IOHelp.getFis(new File(path)), charset);
    }

    public static ZipInputStream getZis(String path) {
        return IOHelp.getZis(IOHelp.getFis(new File(path)), StandardCharsets.UTF_8);
    }

    public static ZipOutputStream getZos(OutputStream os, Charset charset) {
        return new ZipOutputStream(os, charset);
    }

    public static ZipOutputStream getZos(OutputStream os) {
        return IOHelp.getZos(os, StandardCharsets.UTF_8);
    }

    public static ZipOutputStream getZos(File file, boolean append, Charset charset) {
        return IOHelp.getZos(IOHelp.getFos(file, append), charset);
    }

    public static ZipOutputStream getZos(File file) {
        return IOHelp.getZos(IOHelp.getFos(file, false), StandardCharsets.UTF_8);
    }

    public static ZipOutputStream getZos(String path, boolean append, Charset charset) {
        return IOHelp.getZos(IOHelp.getFos(path, append), charset);
    }

    public static ZipOutputStream getZos(String path) {
        return IOHelp.getZos(IOHelp.getFos(path, false), StandardCharsets.UTF_8);
    }

    public static JarInputStream getJis(InputStream is, boolean verify) {
        try {
            return new JarInputStream(is, verify);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
    }

    public static JarInputStream getJis(InputStream is) {
        return IOHelp.getJis(is, true);
    }

    public static JarInputStream getJis(File file, boolean verify) {
        return IOHelp.getJis(IOHelp.getFis(file), verify);
    }

    public static JarInputStream getJis(File file) {
        return IOHelp.getJis(IOHelp.getFis(file), true);
    }

    public static JarInputStream getJis(String path, boolean verify) {
        return IOHelp.getJis(IOHelp.getFis(new File(path)), verify);
    }

    public static JarInputStream getJis(String path) {
        return IOHelp.getJis(IOHelp.getFis(new File(path)), true);
    }

    public static JarOutputStream getJos(OutputStream os, Manifest man) {
        try {
            return man != null ? new JarOutputStream(os, man) : new JarOutputStream(os);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
    }

    public static JarOutputStream getJos(OutputStream os) {
        return IOHelp.getJos(os, null);
    }

    public static JarOutputStream getJos(File file, boolean append, Manifest man) {
        return IOHelp.getJos(IOHelp.getFos(file, append), man);
    }

    public static JarOutputStream getJos(File file) {
        return IOHelp.getJos(IOHelp.getFos(file, false), null);
    }

    public static JarOutputStream getJos(String path, boolean append, Manifest man) {
        return IOHelp.getJos(IOHelp.getFos(path, append), man);
    }

    public static JarOutputStream getJos(String path) {
        return IOHelp.getJos(IOHelp.getFos(path, false), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends InputStream, O extends OutputStream> long read(I i, long offset, long size, O o, int dataSize, Consumer<byte[]> update, BiConsumer<I, O> f) {
        offset = Math.max(offset, 0L);
        int len = 0;
        try {
            long skip;
            if (offset > 0L && (skip = i.skip(offset)) <= offset) {
                long l = 0L;
                return l;
            }
            byte[] buffer = new byte[dataSize];
            if (size > 0L) {
                long n = size / (long)dataSize;
                while (n-- > 0L && (len = i.read(buffer)) != -1) {
                    if (update == null) {
                        o.write(buffer, 0, len);
                    } else if (o == null) {
                        update.accept(buffer);
                    } else {
                        update.accept(buffer);
                        o.write(buffer, 0, len);
                    }
                    offset += (long)len;
                }
                if (len >= 0 && (len = Math.min(i.read(buffer), (int)(size % (long)dataSize))) != -1) {
                    if (update == null) {
                        o.write(buffer, 0, len);
                    } else if (o == null) {
                        update.accept(buffer);
                    } else {
                        update.accept(buffer);
                        o.write(buffer, 0, len);
                    }
                    offset += (long)len;
                }
            } else {
                while ((len = i.read(buffer)) != -1) {
                    if (update == null) {
                        o.write(buffer, 0, len);
                    } else if (o == null) {
                        update.accept(buffer);
                    } else {
                        update.accept(buffer);
                        o.write(buffer, 0, len);
                    }
                    offset += (long)len;
                }
            }
            IOHelp.flush(o);
        }
        catch (Exception e) {
            long l = offset == 0L ? -1L : offset;
            return l;
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(o, i);
                } else {
                    f.accept(i, o);
                }
            }
            catch (Throwable throwable) {}
        }
        return 0L;
    }

    public static <I extends InputStream, O extends OutputStream> long read(I i, O o, int dataSize, Consumer<byte[]> update, BiConsumer<I, O> f) {
        return IOHelp.read(i, 0L, 0L, o, dataSize, update, f);
    }

    public static <I extends InputStream, O extends OutputStream> long read(I i, O o) {
        return IOHelp.read(i, o, 1024, null, null);
    }

    public static <R extends Reader, W extends Writer> void read(R r, W w, int dataSize, Consumer<char[]> update, BiConsumer<R, W> f) {
        try {
            int len;
            char[] buffer = new char[dataSize];
            while ((len = r.read(buffer)) != -1) {
                if (update == null) {
                    w.write(buffer, 0, len);
                    continue;
                }
                if (w == null) {
                    update.accept(buffer);
                    continue;
                }
                update.accept(buffer);
                w.write(buffer, 0, len);
            }
            IOHelp.flush(w);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(w, r);
                } else {
                    f.accept(r, w);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <R extends Reader, W extends Writer> void read(R reader, W writer) {
        IOHelp.read(reader, writer, 1024, null, null);
    }

    public static <BR extends BufferedReader, BW extends BufferedWriter> void read(BR br, BW bw, Function<String, String> update, BiConsumer<BR, BW> f) {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (update == null) {
                    bw.write(line);
                    bw.newLine();
                    continue;
                }
                if (bw == null) {
                    update.apply(line);
                    continue;
                }
                bw.write(update.apply(line));
                bw.newLine();
            }
            IOHelp.flush(bw);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(bw, br);
                } else {
                    f.accept(br, bw);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <BR extends BufferedReader, BW extends BufferedWriter> void read(BR br, BW bw) {
        IOHelp.read(br, bw, (Function<String, String>)null, null);
    }

    public static <BR extends BufferedReader, BW extends BufferedWriter> void read(BR br, BW bw, BiConsumer<String, BW> update, BiConsumer<BR, BW> f) {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                update.accept(line, bw);
            }
            IOHelp.flush(bw);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(bw, br);
                } else {
                    f.accept(br, bw);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <BR extends BufferedReader, BW extends BufferedWriter> void read(BR br, BW bw, BiConsumer<String, BW> update) {
        IOHelp.read(br, bw, update, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends InputStream> long read(I i, long offset, long size, BiConsumer<byte[], Integer> consumer, int dataSize, Consumer<I> f) {
        offset = Math.max(offset, 0L);
        int len = 0;
        try {
            long skip;
            if (offset > 0L && (skip = i.skip(offset)) <= offset) {
                long l = 0L;
                return l;
            }
            byte[] buffer = new byte[dataSize];
            if (size > 0L) {
                long n = size / (long)dataSize;
                while (n-- > 0L && (len = i.read(buffer)) != -1) {
                    consumer.accept(buffer, len);
                    offset += (long)len;
                }
                if (len >= 0 && (len = Math.min(i.read(buffer), (int)(size % (long)dataSize))) != -1) {
                    consumer.accept(buffer, len);
                    offset += (long)len;
                }
            } else {
                while ((len = i.read(buffer)) != -1) {
                    consumer.accept(buffer, len);
                    offset += (long)len;
                }
            }
        }
        catch (Exception e) {
            long l = offset == 0L ? -1L : offset;
            return l;
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(i);
                } else {
                    f.accept(i);
                }
            }
            catch (Throwable throwable) {}
        }
        return 0L;
    }

    public static <I extends InputStream> void read(I i, BiConsumer<byte[], Integer> consumer, int dataSize, Consumer<I> f) {
        IOHelp.read(i, 0L, 0L, consumer, dataSize, f);
    }

    public static <I extends InputStream> void read(I i, BiConsumer<byte[], Integer> consumer) {
        IOHelp.read(i, consumer, 1024, null);
    }

    public static <R extends Reader> void read(R r, BiConsumer<char[], Integer> consumer, int dataSize, Consumer<R> f) {
        try {
            int len;
            char[] buffer = new char[dataSize];
            while ((len = r.read(buffer)) != -1) {
                consumer.accept(buffer, len);
            }
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(r);
                } else {
                    f.accept(r);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <R extends Reader> void read(R r, BiConsumer<char[], Integer> consumer) {
        IOHelp.read(r, consumer, 1024, null);
    }

    public static <BR extends BufferedReader> void read(BR br, Consumer<String> consumer, Consumer<BR> f) {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                consumer.accept(line);
            }
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(br);
                } else {
                    f.accept(br);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <BR extends BufferedReader> void read(BR br, Consumer<String> consumer) {
        IOHelp.read(br, consumer, null);
    }

    public static <I extends InputStream> long read(I i, long offset, long size, int dataSize, Collection<byte[]> bytes, Consumer<I> f) {
        return IOHelp.read(i, offset, size, (buffer, len) -> {
            if (len == 0) {
                return;
            }
            byte[] des = new byte[len.intValue()];
            System.arraycopy(buffer, 0, des, 0, len);
            bytes.add(des);
        }, dataSize, f);
    }

    public static <I extends InputStream> void read(I i, int dataSize, Collection<byte[]> bytes, Consumer<I> f) {
        IOHelp.read(i, 0L, 0L, dataSize, bytes, f);
    }

    public static <I extends InputStream> void read(I i, Collection<byte[]> bytes) {
        IOHelp.read(i, 1024, bytes, null);
    }

    public static <I extends InputStream> long read(I i, long offset, long size, int dataSize, byte[] data, int dataOffset, Consumer<I> f) {
        int available;
        try {
            available = i.available();
        }
        catch (IOException e) {
            return 0L;
        }
        ServerFailureMsg.requireNon(available <= 0, "\u65e0\u6548\u6587\u4ef6");
        ServerFailureMsg.requireNon((long)(dataOffset + available) - offset > (long)(data.length - dataOffset), "\u6587\u4ef6\u8fc7\u5927");
        AtomicInteger atomic = new AtomicInteger(dataOffset);
        return IOHelp.read(i, offset, size, (buffer, len) -> {
            if (len == 0) {
                return;
            }
            System.arraycopy(buffer, 0, data, atomic.getAndAccumulate((int)len, Integer::sum), len);
        }, dataSize, f);
    }

    public static <I extends InputStream> long read(I i, int dataSize, byte[] data, int dataOffset, Consumer<I> f) {
        return IOHelp.read(i, 0L, 0L, dataSize, data, dataOffset, f);
    }

    public static <I extends InputStream> long read(I i, byte[] bytes, int dataOffset) {
        return IOHelp.read(i, 1024, bytes, dataOffset, null);
    }

    public static <I extends InputStream> byte[] read(I i, long offset, long size, int dataSize, Consumer<I> f) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOHelp.read(i, offset, size, baos, dataSize, null, (I ii, O oo) -> {
            IOHelp.close(oo);
            if (f == null) {
                IOHelp.close(ii);
            } else {
                f.accept(ii);
            }
        });
        return baos.toByteArray();
    }

    public static <I extends InputStream> byte[] read(I i, int dataSize, Consumer<I> f) {
        return IOHelp.read(i, 0L, 0L, dataSize, f);
    }

    public static <I extends InputStream> byte[] read(I i) {
        return IOHelp.read(i, 1024, null);
    }

    public static <BR extends BufferedReader> void read(BR br, Collection<String> strings, Consumer<BR> f) {
        IOHelp.read(br, strings::add, f);
    }

    public static <BR extends BufferedReader> void read(BR br, Collection<String> strings) {
        IOHelp.read(br, strings, null);
    }

    public static <BR extends BufferedReader> String read(BR br) {
        StringWriter sw = new StringWriter();
        IOHelp.read(br, sw);
        return sw.toString();
    }

    public static <O extends OutputStream> void write(O o, byte[] bytes, Consumer<O> f) {
        try {
            if (bytes.length > 0) {
                o.write(bytes);
            }
            IOHelp.flush(o);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(o);
                } else {
                    f.accept(o);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <O extends OutputStream> void write(O o, byte[] bytes) {
        IOHelp.write(o, bytes, null);
    }

    public static <O extends OutputStream> void write(O o, Collection<byte[]> bytes, Consumer<O> f) {
        try {
            for (byte[] bs : bytes) {
                if (!Validator.nonEmpty(bs)) continue;
                o.write(bs);
            }
            IOHelp.flush(o);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(o);
                } else {
                    f.accept(o);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <O extends OutputStream> void write(O o, Collection<byte[]> bytes) {
        IOHelp.write(o, bytes, null);
    }

    public static <W extends Writer> void write(W w, char[] chars, Consumer<W> f) {
        try {
            if (chars.length > 0) {
                w.write(chars);
            }
            IOHelp.flush(w);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(w);
                } else {
                    f.accept(w);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <W extends Writer> void write(W w, char[] chars) {
        IOHelp.write(w, chars, null);
    }

    public static <W extends Writer> void write(W w, Collection<String> strings, Consumer<W> f) {
        try {
            for (String str : strings) {
                if (!Validator.nonEmpty(str)) continue;
                w.write(str);
            }
            IOHelp.flush(w);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(w);
                } else {
                    f.accept(w);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <W extends Writer> void write(W w, Collection<String> strings) {
        IOHelp.write(w, strings, null);
    }

    public static <BW extends BufferedWriter> void write(BW bw, char[] chars, Consumer<BW> f) {
        try {
            if (chars.length > 0) {
                bw.write(chars);
                bw.newLine();
            }
            IOHelp.flush(bw);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(bw);
                } else {
                    f.accept(bw);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <BW extends BufferedWriter> void write(BW bw, char[] chars) {
        IOHelp.write(bw, chars, null);
    }

    public static <BW extends BufferedWriter> void write(BW bw, Collection<String> strings, Consumer<BW> f) {
        try {
            for (String str : strings) {
                if (!Validator.nonEmpty(str)) continue;
                bw.write(str);
                bw.newLine();
            }
            IOHelp.flush(bw);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
        finally {
            try {
                if (f == null) {
                    IOHelp.close(bw);
                } else {
                    f.accept(bw);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static <BW extends BufferedWriter> void write(BW bw, Collection<String> strings) {
        IOHelp.write(bw, strings, null);
    }
}

