/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import shz.AccessibleHelp;
import shz.Validator;
import shz.msg.ServerFailure;

public final class InterfaceProxy
implements InvocationHandler {
    private final Function<InterfaceProxyInvokeParam, ?> executor;

    private InterfaceProxy(Function<InterfaceProxyInvokeParam, ?> executor) {
        this.executor = executor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName()) {
                case "hashCode": {
                    return 0;
                }
                case "toString": {
                    return "";
                }
                case "equals": {
                    return false;
                }
                case "getClass": 
                case "notify": 
                case "notifyAll": 
                case "wait": 
                case "clone": 
                case "finalize": {
                    return null;
                }
            }
        }
        Object invoke = this.executor.apply(new InterfaceProxyInvokeParam(proxy, method, args));
        if (method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class) {
            return null;
        }
        ServerFailure.NoSuchMethodException.requireNon(invoke == null && method.getReturnType().isPrimitive());
        if (invoke == null) {
            return null;
        }
        ServerFailure.NoSuchMethodException.requireNon(!AccessibleHelp.canCast(invoke.getClass(), method.getReturnType()));
        return invoke;
    }

    public static <T> T getProxy(Class<T> cls, Function<InterfaceProxyInvokeParam, ?> executor, boolean save) {
        Object[] objectArray;
        Object[] interfaces = cls.getInterfaces();
        Validator.requireNon(Validator.isEmpty(interfaces) && !cls.isInterface());
        if (save) {
            System.getProperties().setProperty("sun.misc.ProxyGenerator.saveGeneratedFiles", "true");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (cls.isInterface()) {
            Class[] classArray = new Class[1];
            objectArray = classArray;
            classArray[0] = cls;
        } else {
            objectArray = interfaces;
        }
        return (T)Proxy.newProxyInstance(classLoader, objectArray, (InvocationHandler)new InterfaceProxy(executor));
    }

    public static <T> T getProxy(Class<T> cls, Function<InterfaceProxyInvokeParam, ?> executor) {
        return InterfaceProxy.getProxy(cls, executor, false);
    }

    public static final class InterfaceProxyInvokeParam {
        private final Object proxy;
        private final Method method;
        private final Object[] args;

        public Object getProxy() {
            return this.proxy;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        InterfaceProxyInvokeParam(Object proxy, Method method, Object[] args) {
            this.proxy = proxy;
            this.method = method;
            this.args = args;
        }
    }
}

