/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import shz.linked.ConcurrentLDNode;
import shz.linked.DNode;

public final class ObjectPool<E> {
    private final Supplier<E> supplier;
    private final Consumer<E> closeFun;
    private final int capacity;
    private final int maxIdle;
    private final AtomicInteger size;
    private final AtomicInteger idle;
    private final ConcurrentLDNode<E> head;
    private final ConcurrentLDNode<E> tail;

    public ObjectPool(Supplier<E> supplier, Consumer<E> closeFun, int capacity, int maxIdle) {
        this.supplier = supplier;
        this.closeFun = closeFun;
        this.capacity = capacity;
        this.maxIdle = maxIdle;
        this.size = new AtomicInteger(maxIdle);
        this.idle = new AtomicInteger(maxIdle);
        this.tail = ConcurrentLDNode.of(null);
        this.head = this.tail;
        this.head.next(this.tail);
        this.tail.prev(this.head);
        for (int i = 0; i < maxIdle; ++i) {
            this.head.addNext(ConcurrentLDNode.of(this.supplier.get()));
        }
    }

    public ObjectPool(Supplier<E> supplier, int maxIdle) {
        this(supplier, e -> {
            e = null;
        }, Integer.MAX_VALUE, maxIdle);
    }

    public ObjectPool(Supplier<E> supplier) {
        this(supplier, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T apply(Function<E, T> func) {
        T t;
        E e = this.get();
        try {
            t = func.apply(e);
        }
        finally {
            this.release(e);
        }
        return t;
    }

    public E get() {
        DNode node = this.head.next();
        if (node == this.tail) {
            return this.get0(this.create());
        }
        while (!this.poll((ConcurrentLDNode<E>)node)) {
            this.sleep();
            node = this.head.next();
            if (node != this.tail) continue;
            return this.get0(this.create());
        }
        this.idle.decrementAndGet();
        if (((ConcurrentLDNode)node).val == null) {
            this.size.decrementAndGet();
            if (((ConcurrentLDNode)node).val != null) {
                this.closeFun.accept(((ConcurrentLDNode)node).val);
            }
            return this.get0(this.create());
        }
        return ((ConcurrentLDNode)node).val;
    }

    private E get0(ConcurrentLDNode<E> node) {
        return node == null ? null : (E)node.val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentLDNode<E> create() {
        if (this.size.get() >= this.capacity) {
            return null;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.size.get() >= this.capacity) {
                return null;
            }
            this.size.incrementAndGet();
            return ConcurrentLDNode.of(this.supplier.get());
        }
    }

    public void release(E e) {
        if (this.idle.get() < this.maxIdle) {
            this.idle.incrementAndGet();
            this.head.addNext(ConcurrentLDNode.of(e));
        } else {
            this.size.decrementAndGet();
        }
    }

    boolean poll(ConcurrentLDNode<E> node) {
        DNode next;
        DNode prev = node.prev();
        if (!((ConcurrentLDNode)prev).casNext(node, next = node.next())) {
            return false;
        }
        ((ConcurrentLDNode)next).prev(prev);
        return true;
    }

    void sleep() {
        try {
            TimeUnit.MICROSECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void accept(Consumer<E> consumer) {
        this.apply(t -> {
            consumer.accept(t);
            return null;
        });
    }

    public int size() {
        return this.size.get();
    }

    public int idle() {
        return this.idle.get();
    }

    public void clear() {
        for (DNode next = this.head.next(); next != this.tail; next = ((ConcurrentLDNode)next).next()) {
            if (((ConcurrentLDNode)next).val == null) continue;
            this.closeFun.accept(((ConcurrentLDNode)next).val);
        }
        this.head.next(this.tail);
        this.tail.prev(this.head);
    }
}

