/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import shz.Response;
import shz.msg.FailureMsg;
import shz.msg.ServerFailure;
import shz.msg.ServerFailureMsg;

public class PRException
extends RuntimeException {
    private static final long serialVersionUID = -5471383639912386544L;
    protected final FailureMsg msg;
    protected static final PRException SERVER_ERROR = new PRException(ServerFailure.INTERNAL_ERROR, null);
    protected static final PRException IMPOSSIBLE = new PRException(ServerFailure.INTERNAL_ERROR, (Throwable)new Error("impossible!"));

    protected PRException(FailureMsg msg, Throwable cause) {
        super(msg.msg(), cause);
        this.msg = msg;
    }

    public static PRException of(FailureMsg msg, Throwable cause) {
        if (msg != null) {
            return new PRException(msg, cause);
        }
        if (cause instanceof PRException) {
            return (PRException)cause;
        }
        msg = FailureMsg.fail(cause);
        return msg == ServerFailure.INTERNAL_ERROR ? SERVER_ERROR : new PRException(msg, cause);
    }

    public static PRException of(FailureMsg msg) {
        return PRException.of(msg, null);
    }

    public static PRException of(Throwable cause) {
        return PRException.of(null, cause);
    }

    public static PRException of() {
        return PRException.of(null, null);
    }

    public final FailureMsg msg() {
        return this.msg;
    }

    public static PRException impossible() {
        return IMPOSSIBLE;
    }

    public static void requireNon(boolean condition, FailureMsg msg) {
        if (condition) {
            throw PRException.of(msg);
        }
    }

    public static void requireNon(boolean condition, Supplier<FailureMsg> msg) {
        if (condition) {
            throw PRException.of(msg == null ? null : msg.get());
        }
    }

    public final <T> T exceptionCaught(Consumer<PRException> consumer, Function<FailureMsg, T> mapper) {
        consumer.accept(this);
        return mapper.apply(this.msg instanceof ServerFailureMsg && this.msg.code() == ServerFailure.INTERNAL_ERROR.code() ? ServerFailure.INTERNAL_ERROR : this.msg);
    }

    public final Response<Void> exceptionCaught(Consumer<PRException> consumer) {
        return this.exceptionCaught(consumer, Response::fail);
    }
}

