/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import shz.TimeHelp;
import shz.ToMap;
import shz.ToObject;
import shz.enums.Sex;
import shz.msg.ClientFailureMsg;

public final class RegexHelp {
    public static final String CHAR = "^[\u0000-\uffff]$";
    public static final String BOOLEAN = "^0|1|(?i:true|false)$";
    public static final String UNSIGNED_BYTE = "^\\d|[1-9]\\d|1[01]\\d|12[0-7]$";
    public static final String BYTE = "^0|-128|[\\-]?(?:[1-9]|[1-9]\\d|1[01]\\d|12[0-7])$";
    public static final String UNSIGNED_DIGITAL = "^0|0\\.\\d+|[1-9]\\d*(?:\\.\\d+)?$";
    public static final String DIGITAL = "^0|[\\-]?(?:0\\.\\d+|[1-9]\\d*(?:\\.\\d+)?)$";
    public static final String PHONE = "^(?:13[0-9]|14[5,7,9]|15(?:[0-3]|[5-9])|166|17[0,1,3,5,6,7,8]|18[0-9]|19[8|9])\\d{8}$";
    public static final String CH_PHONE = "^\\d{3}-\\d{8}|\\d{4}-\\d{7}$";
    public static final String EMAIL = "^\\w+@\\w+(?:\\.\\w+)+$";
    public static final String IP = "^(?:(?:2(?:5[0-5]|[0-4]\\d))|1?\\d{1,2})(?:\\.(?:(?:2(?:5[0-5]|[0-4]\\d))|1?\\d{1,2})){3}$";
    public static final String DOMAIN = "(?:^[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}$";
    public static final String URL = "^(?:(?:https?|ftp|file)://)?(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}(?::[1-5]\\d{1,4})?(?:/[\\w.@-_]+)*$";
    public static final String HTML = "<[_a-zA-Z][^>]*/>|<([_a-zA-Z][\\w]*+)[^>]*>.*?</\\1>";
    public static final String CH_POSTAL_CODE = "^[1-9]\\d{5}(?!\\d)$";
    public static final String QQ = "^[1-9][0-9]{4,10}$";
    public static final String NAME_CH = "^[\u4e00-\u9fa5]{2,4}$";
    public static final String NAME_CH_MINORITY = "^[\u4e00-\u9fa5]+(?:[\u00b7\u2022.][\u4e00-\u9fa5]+)*$";
    public static final String NAME_EN = "^[a-zA-Z\\s]+(?:[\u00b7\u2022.][a-zA-Z]+)*$";
    public static final String LOGIN_NAME = "^[a-zA-Z0-9\u00b7\u2022.]{3,20}$";
    public static final String PWD = "^[a-zA-Z0-9!\"#\\$%&'\\(\\)\\*\\+,-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~]{4,16}$";
    public static final String NO = "^[0-9a-zA-Z]{1,64}$";
    public static final String MIDDLE_CH = "^[\u4e00-\u9fa5]{1,64}$";
    public static final String CHAR_255 = "^[\u0000-\uffff]{0,255}$";
    private static final Map<String, String> ID_R_C = (Map)ToMap.get(35).put("11", "\u5317\u4eac").put("12", "\u5929\u6d25").put("13", "\u6cb3\u5317").put("14", "\u5c71\u897f").put("15", "\u5185\u8499\u53e4").put("21", "\u8fbd\u5b81").put("22", "\u5409\u6797").put("23", "\u9ed1\u9f99\u6c5f").put("31", "\u4e0a\u6d77").put("32", "\u6c5f\u82cf").put("33", "\u6d59\u6c5f").put("34", "\u5b89\u5fbd").put("35", "\u798f\u5efa").put("36", "\u6c5f\u897f").put("37", "\u5c71\u4e1c").put("41", "\u6cb3\u5357").put("42", "\u6e56\u5317").put("43", "\u6e56\u5357").put("44", "\u5e7f\u4e1c").put("45", "\u5e7f\u897f").put("46", "\u6d77\u5357").put("50", "\u91cd\u5e86").put("51", "\u56db\u5ddd").put("52", "\u8d35\u5dde").put("53", "\u4e91\u5357").put("54", "\u897f\u85cf").put("61", "\u9655\u897f").put("62", "\u7518\u8083").put("63", "\u9752\u6d77").put("64", "\u5b81\u590f").put("65", "\u65b0\u7586").put("71", "\u53f0\u6e7e").put("81", "\u9999\u6e2f").put("82", "\u6fb3\u95e8").put("91", "\u56fd\u5916").build();
    private static final int[] ID_W = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final int[] ID_M = new int[]{1, 0, 10, 9, 8, 7, 6, 5, 4, 3, 2};

    private RegexHelp() {
        throw new IllegalStateException();
    }

    public static String find(String s, int flags, String regex, int group) {
        if (s == null || regex == null) {
            return s;
        }
        Matcher matcher = Pattern.compile(regex, flags).matcher(s);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return null;
    }

    public static String find(String s, String regex) {
        return RegexHelp.find(s, 0, regex, 0);
    }

    public static String find(String s, boolean all, int flags, String ... regexes) {
        if (s == null || regexes.length == 0) {
            return s;
        }
        String result = RegexHelp.find(s, flags, regexes[0], 0);
        if (regexes.length == 1) {
            return result;
        }
        if (result == null) {
            if (regexes[0] != null) {
                return null;
            }
            result = s;
        }
        for (int i = 1; i < regexes.length; ++i) {
            if (regexes[i] == null) continue;
            String find = RegexHelp.find(result, flags, regexes[i], 0);
            if (find != null) {
                result = find;
                continue;
            }
            result = all ? null : result;
            break;
        }
        return result;
    }

    public static String find(String s, boolean all, String ... regexes) {
        return RegexHelp.find(s, all, 0, regexes);
    }

    public static String find(String s, String ... regexes) {
        return RegexHelp.find(s, true, 0, regexes);
    }

    public static String getHost(String url) {
        return RegexHelp.find(url, 0, "(//)?([\\w.]+)/", 2);
    }

    public static boolean isMatch(String s, String regex) {
        return s != null && regex != null && Pattern.compile(regex).matcher(s).find();
    }

    public static boolean nonMatch(String s, String regex) {
        return !RegexHelp.isMatch(s, regex);
    }

    public static boolean isAnyMatch(String s, String regex1, String regex2) {
        return RegexHelp.isMatch(s, regex1) || RegexHelp.isMatch(s, regex2);
    }

    public static boolean nonAnyMatch(String s, String regex1, String regex2) {
        return !RegexHelp.isAnyMatch(s, regex1, regex2);
    }

    public static boolean isAnyMatch(String s, String ... regexes) {
        return ((Stream)Arrays.stream(regexes).parallel()).anyMatch(e -> RegexHelp.isMatch(s, e));
    }

    public static boolean nonAnyMatch(String s, String ... regexes) {
        return !RegexHelp.isAnyMatch(s, regexes);
    }

    public static boolean isAllMatch(String s, String regex1, String regex2) {
        return RegexHelp.isMatch(s, regex1) && RegexHelp.isMatch(s, regex2);
    }

    public static boolean nonAllMatch(String s, String regex1, String regex2) {
        return !RegexHelp.isAllMatch(s, regex1, regex2);
    }

    public static boolean isAllMatch(String s, String ... regexes) {
        return ((Stream)Arrays.stream(regexes).parallel()).allMatch(e -> RegexHelp.isMatch(s, e));
    }

    public static boolean nonAllMatch(String s, String ... regexes) {
        return !RegexHelp.isAllMatch(s, regexes);
    }

    public static String replace(String s, int flags, String regex, Function<Matcher, String> func) {
        Matcher matcher = Pattern.compile(regex, flags).matcher(s);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            sb.append(s, start, matcher.start());
            sb.append(func.apply(matcher));
            start = matcher.end();
        }
        sb.append(s, start, s.length());
        return sb.toString();
    }

    public static String replace(String s, String regex, Function<Matcher, String> func) {
        return RegexHelp.replace(s, 0, regex, func);
    }

    public static boolean isBirthday(String s) {
        try {
            LocalDateTime ldt = ToObject.cast(s, LocalDateTime.class);
            if (ldt == null) {
                return false;
            }
            return ldt.isBefore(LocalDateTime.now());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isIdentity(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 15) {
            return RegexHelp.isBirthday("19" + s.substring(6, 12));
        }
        if (s.length() != 18) {
            return false;
        }
        if (!ID_R_C.containsKey(s.substring(0, 2))) {
            return false;
        }
        int[] c_i = new int[17];
        for (int i = 0; i < c_i.length; ++i) {
            c_i[i] = s.charAt(i) - 48;
        }
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += c_i[i] * ID_W[i];
        }
        char c = s.charAt(17);
        return ID_M[sum % 11] == (c == 'x' || c == 'X' ? 10 : c - 48);
    }

    public static String getIdentityRegion(String identity) {
        return ID_R_C.get(identity.substring(0, 2));
    }

    public static String getIdentityBirthday(String identity) {
        return identity.length() == 15 ? "19" + identity.substring(6, 12) : identity.substring(6, 14);
    }

    public static int getIdentityAge(String identity) {
        return TimeHelp.between(TimeHelp.toLdt(RegexHelp.getIdentityBirthday(identity)).toLocalDate(), LocalDate.now()).getYears();
    }

    public static Sex getIdentitySex(String identity) {
        return (identity.charAt(16) - 48 & 1) == 0 ? Sex.FEMALE : Sex.MALE;
    }

    public static boolean luneCheck(String s) {
        if (s == null || !s.matches("^\\d{8,19}$")) {
            return false;
        }
        return RegexHelp.luneCompute(s.substring(0, s.length() - 1)) == s.charAt(s.length() - 1) - 48;
    }

    public static int luneCompute(String s) {
        ClientFailureMsg.requireNon(s == null || !s.matches("^\\d{7,18}$"), "\u975e\u6cd5\u5361\u53f7");
        int mod = RegexHelp.luneSum(s) % 10;
        return mod == 0 ? 0 : 10 - mod;
    }

    private static int luneSum(String s) {
        int sum = 0;
        int i = s.length() - 1;
        int j = 0;
        while (i > -1) {
            int n = s.charAt(i) - 48;
            if (!(j & true)) {
                n <<= 1;
                n = n / 10 + n % 10;
            }
            sum += n;
            --i;
            ++j;
        }
        return sum;
    }
}

