/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.Serializable;
import java.util.function.Function;
import shz.msg.FailureMsg;
import shz.msg.ServerFailure;
import shz.msg.Success;
import shz.msg.SuccessMsg;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = 4985263968380752221L;
    protected int code;
    protected String msg;
    protected T payload;
    protected static final Response<?> SUCCESS = new Response();
    protected static final Response<?> SERVER_ERROR = new Response<Object>(ServerFailure.INTERNAL_ERROR.code(), ServerFailure.INTERNAL_ERROR.msg(), null);

    public Response(int code, String msg, T payload) {
        this.code = code;
        this.msg = msg;
        this.payload = payload;
    }

    public Response(int code, String msg) {
        this(code, msg, null);
    }

    public Response() {
        this(Success.OK.code(), Success.OK.msg(), null);
    }

    public boolean isOk() {
        return this.code == Success.OK.code();
    }

    public static <T> Response<T> ok(SuccessMsg message, T payload) {
        if (message != null) {
            return new Response<T>(Success.OK.code(), message.msg(), payload);
        }
        return payload == null ? SUCCESS : new Response<T>(Success.OK.code(), Success.OK.msg(), payload);
    }

    public static <T> Response<T> ok(SuccessMsg message) {
        return Response.ok(message, null);
    }

    public static <T> Response<T> ok(T payload) {
        return Response.ok(null, payload);
    }

    public static <T> Response<T> ok() {
        return Response.ok(null, null);
    }

    public static <T> Response<T> fail(FailureMsg message, T payload) {
        if (message != null) {
            return new Response<T>(message.code(), message.msg(), payload);
        }
        return payload == null ? SERVER_ERROR : new Response<T>(ServerFailure.INTERNAL_ERROR.code(), ServerFailure.INTERNAL_ERROR.msg(), payload);
    }

    public static <T> Response<T> fail(FailureMsg message) {
        return Response.fail(message, null);
    }

    public static <T> Response<T> fail(T payload) {
        return Response.fail(null, payload);
    }

    public static <T> Response<T> fail() {
        return Response.fail(null, null);
    }

    public static <T> Response<T> of(Response<?> response, T payload) {
        return response == null ? Response.fail() : new Response<T>(response.code, response.msg, payload);
    }

    public static <T, D> Response<T> of(Response<? extends D> response, Function<D, T> mapper) {
        if (response == null || mapper == null) {
            return Response.fail();
        }
        T payload = mapper.apply(response.payload);
        return new Response<T>(response.code, response.msg, payload);
    }

    public static <T> Response<T> of(Response<?> response) {
        return Response.of(response, Function.identity());
    }

    public static <T> Response<T> of(boolean flag) {
        return flag ? Response.ok() : Response.fail();
    }

    public final int getCode() {
        return this.code;
    }

    public final String getMsg() {
        return this.msg;
    }

    public final T getPayload() {
        return this.payload;
    }

    public String toString() {
        return "Response{code=" + this.code + ", msg='" + this.msg + '\'' + ", payload=" + this.payload + '}';
    }
}

