/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import shz.PRException;
import shz.Validator;
import shz.constant.ArrayConstant;

public final class Serializer {
    private Serializer() {
        throw new IllegalStateException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object obj) {
        if (obj == null) {
            return ArrayConstant.EMPTY_BYTE_ARRAY;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(byte[] bytes) {
        if (Validator.isEmpty(bytes)) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw PRException.of(e);
        }
    }

    public static String toString(Object obj) {
        return Base64.getEncoder().encodeToString(Serializer.serialize(obj));
    }

    public static <T> T fromString(String str) {
        return Serializer.deserialize(Base64.getDecoder().decode(str));
    }

    public static interface IToLongFunction<T>
    extends ToLongFunction<T>,
    Serializable {
    }

    public static interface IToIntFunction<T>
    extends ToIntFunction<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface IComparator<T>
    extends Comparator<T>,
    Serializable {
        public static <T> IComparator<T> comparingInt(IToIntFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (c1, c2) -> Integer.compare(keyExtractor.applyAsInt(c1), keyExtractor.applyAsInt(c2));
        }

        public static <T> IComparator<T> comparingLong(IToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }
    }
}

