/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class ToList<E> {
    private final List<E> list;

    private ToList(int initialCapacity, int idx) {
        this.list = new ArrayList(this.reduce(initialCapacity, idx));
    }

    private int reduce(int cap, int idx) {
        if (idx <= 0 || cap < 3) {
            return cap;
        }
        int newCap = cap;
        for (int i = idx; i > 0; --i) {
            newCap = (newCap << 1) / 3;
        }
        while (this.calc(newCap, idx) < cap) {
            ++newCap;
        }
        return newCap;
    }

    private int calc(int newCap, int idx) {
        while (idx > 0) {
            newCap += newCap >> 1;
            --idx;
        }
        return newCap;
    }

    public static <E> ToList<E> get(int initialCapacity, int idx) {
        return new ToList<E>(initialCapacity, idx);
    }

    public static <E> ToList<E> get(int initialCapacity) {
        return new ToList<E>(initialCapacity, 0);
    }

    public <T> T build() {
        return (T)this.list;
    }

    public ToList<E> add(Collection<? extends E> c) {
        this.list.addAll(c);
        return this;
    }

    public final <EE extends E> ToList<E> add(EE e) {
        this.list.add(e);
        return this;
    }

    public static <E, R extends List<E>> Collector<E, ?, R> collector(Supplier<R> supplier) {
        return Collector.of(supplier, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]);
    }

    public static <E> Collector<E, ?, List<E>> collector(int initialCapacity, int idx) {
        return ToList.collector(() -> (List)ToList.get(initialCapacity, idx).build());
    }

    public static <E> Collector<E, ?, List<E>> collector(int initialCapacity) {
        return ToList.collector(initialCapacity, 0);
    }

    public static <E> List<E> explicitCollect(Stream<E> stream, int initialCapacity, int idx) {
        List<E> list = stream.collect(ToList.collector(initialCapacity, idx));
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    public static <E> List<E> explicitCollect(Stream<E> stream, int initialCapacity) {
        return ToList.explicitCollect(stream, initialCapacity, 0);
    }

    public static <E> Collector<E, ?, List<E>> collector() {
        return ToList.collector(LinkedList::new);
    }

    public static <E> List<E> collect(Stream<E> stream, boolean extra) {
        List<E> list = stream.collect(ToList.collector());
        return list.isEmpty() ? (extra ? new LinkedList() : Collections.emptyList()) : list;
    }

    public static <E> List<E> collect(Stream<E> stream) {
        return ToList.collect(stream, false);
    }

    public static <E> List<E> collectArray(Stream<E> stream, int extra) {
        int size = Math.max(extra, 0);
        List<E> list = stream.collect(ToList.collector());
        if (list.isEmpty()) {
            return size == 0 ? Collections.emptyList() : new ArrayList(size);
        }
        if (size == 0) {
            return new ArrayList<E>(list);
        }
        ArrayList<E> result = new ArrayList<E>(size + list.size());
        result.addAll(list);
        return result;
    }

    public static <E> List<E> collectArray(Stream<E> stream) {
        return ToList.collectArray(stream, 0);
    }
}

