/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shz.Validator;
import shz.model.TopInfo;
import shz.queue.RedBlackBSTPQueue;

public final class ToMap<K, V> {
    private final Map<K, V> map;
    private static final int MAX = 0x40000000;

    private ToMap(int initialCapacity, int idx, boolean dummy) {
        this.map = dummy ? new LinkedHashMap(ToMap.reduce(initialCapacity, idx), 1.0f) : new HashMap(ToMap.reduce(initialCapacity, idx), 1.0f);
    }

    static int reduce(int cap, int idx) {
        if (idx <= 0 || cap == 1) {
            return (int)Math.ceil((float)cap / 0.75f);
        }
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        int n2 = n = (n |= n >>> 16) >= 0x40000000 ? 0x40000000 : n + 1;
        while (idx-- > 0 && n >= 2) {
            n >>>= 1;
        }
        return (int)Math.ceil((float)n / 0.75f);
    }

    public static <K, V> ToMap<K, V> get(int initialCapacity, int idx, boolean dummy) {
        return new ToMap<K, V>(initialCapacity, idx, dummy);
    }

    public static <K, V> ToMap<K, V> get(int initialCapacity, int idx) {
        return new ToMap<K, V>(initialCapacity, idx, false);
    }

    public static <K, V> ToMap<K, V> get(int initialCapacity) {
        return new ToMap<K, V>(initialCapacity, 0, false);
    }

    public <T> T build() {
        return (T)this.map;
    }

    public ToMap<K, V> put(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
        return this;
    }

    public <KK extends K, VV extends V> ToMap<K, V> put(KK k, VV v) {
        this.map.put(k, v);
        return this;
    }

    public static <E, K, V, M extends Map<K, V>> Collector<E, ?, M> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return Collector.of(mapSupplier, (map, element) -> ToMap.merge(keyMapper.apply((Object)element), valueMapper.apply((Object)element), map, mergeFunction), (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                ToMap.merge(e.getKey(), e.getValue(), m1, mergeFunction);
            }
            return m1;
        }, new Collector.Characteristics[0]);
    }

    private static <K, V, M extends Map<K, V>> void merge(K key, V value, M map, BinaryOperator<V> mergeFunction) {
        V oldValue = map.get(key);
        if (oldValue == null) {
            map.put(key, value);
            return;
        }
        map.put(key, mergeFunction.apply(oldValue, value));
    }

    public static <E, K, V, M extends Map<K, V>> Collector<E, ?, M> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, Supplier<M> mapSupplier) {
        return ToMap.collector(keyMapper, valueMapper, (oldValue, newValue) -> newValue == null ? oldValue : newValue, mapSupplier);
    }

    public static <E, K, V> Collector<E, ?, Map<K, V>> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, int initialCapacity, int idx, boolean dummy) {
        return ToMap.collector(keyMapper, valueMapper, () -> (Map)ToMap.get(initialCapacity, idx, dummy).build());
    }

    public static <E, K, V> Collector<E, ?, Map<K, V>> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, int initialCapacity, int idx) {
        return ToMap.collector(keyMapper, valueMapper, initialCapacity, idx, false);
    }

    public static <E, K, V> Collector<E, ?, Map<K, V>> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, int initialCapacity) {
        return ToMap.collector(keyMapper, valueMapper, initialCapacity, 0, false);
    }

    public static <E, K, V> Map<K, V> explicitCollect(Stream<E> stream, Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, int initialCapacity, int idx, boolean dummy) {
        Map<K, V> map = stream.collect(ToMap.collector(keyMapper, valueMapper, initialCapacity, idx, dummy));
        return map.isEmpty() ? Collections.emptyMap() : map;
    }

    public static <E, K, V> Map<K, V> explicitCollect(Stream<E> stream, Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, int initialCapacity) {
        return ToMap.explicitCollect(stream, keyMapper, valueMapper, initialCapacity, 0, false);
    }

    public static <E, K, V> Collector<E, ?, Map<K, V>> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, boolean dummy) {
        return ToMap.collector(keyMapper, valueMapper, dummy ? LinkedHashMap::new : HashMap::new);
    }

    public static <E, K, V> Collector<E, ?, Map<K, V>> collector(Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper) {
        return ToMap.collector(keyMapper, valueMapper, false);
    }

    public static <E, K, V> Map<K, V> collect(Stream<E> stream, Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, boolean dummy, int extra) {
        int newCap;
        int size = Math.max(extra, 0);
        Map<K, V> map = stream.collect(ToMap.collector(keyMapper, valueMapper, dummy));
        if (map.isEmpty()) {
            return size == 0 ? Collections.emptyMap() : (Map)ToMap.get(size, 0, dummy).build();
        }
        if (size == 0) {
            return map;
        }
        int oldCap = ToMap.reduce(map.size(), 0);
        if (oldCap >= (newCap = ToMap.reduce(size + map.size(), 1))) {
            return map;
        }
        newCap = ToMap.reduce(size + map.size(), 0);
        HashMap result = dummy ? new LinkedHashMap(newCap, 1.0f) : new HashMap(newCap, 1.0f);
        result.putAll(map);
        return result;
    }

    public static <E, K, V> Map<K, V> collect(Stream<E> stream, Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, boolean dummy) {
        return ToMap.collect(stream, keyMapper, valueMapper, dummy, 0);
    }

    public static <E, K, V> Map<K, V> collect(Stream<E> stream, Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper, int extra) {
        return ToMap.collect(stream, keyMapper, valueMapper, false, extra);
    }

    public static <E, K, V> Map<K, V> collect(Stream<E> stream, Function<? super E, ? extends K> keyMapper, Function<? super E, ? extends V> valueMapper) {
        return ToMap.collect(stream, keyMapper, valueMapper, false, 0);
    }

    @SafeVarargs
    public static <E, M extends Map<?, ?>> M unique(List<E> list, Function<E, ?> ... classifiers) {
        if (Validator.isEmpty(list)) {
            return (M)Collections.emptyMap();
        }
        Collector<Object, ?, Map<?, Object>> collector = Collectors.groupingBy(classifiers[classifiers.length - 1], Collectors.reducing(null, (a, b) -> b));
        for (int i = classifiers.length - 2; i >= 0; --i) {
            collector = Collectors.groupingBy(classifiers[i], collector);
        }
        return (M)list.stream().collect(collector);
    }

    public static <E, K> Map<K, List<E>> topN(Consumer<Consumer<E>> runnable, Function<E, TopInfo<K>> group, Predicate<E> filter, BiFunction<E, E, Integer> comparator) {
        HashMap queues = new HashMap();
        runnable.accept(t -> {
            if (t == null || filter != null && !filter.test(t)) {
                return;
            }
            TopInfo topInfo = (TopInfo)group.apply(t);
            RedBlackBSTPQueue queue = queues.computeIfAbsent(topInfo.key, k -> RedBlackBSTPQueue.Min.of(comparator::apply));
            while (queue.size() > topInfo.n) {
                queue.poll();
            }
            if (queue.size() == topInfo.n) {
                if ((Integer)comparator.apply(t, queue.peek()) > 0) {
                    queue.poll();
                    queue.offer(t);
                }
            } else {
                queue.offer(t);
            }
        });
        return ToMap.explicitCollect(queues.keySet().stream(), Function.identity(), key -> ((RedBlackBSTPQueue)queues.get(key)).reverse(), queues.size());
    }

    public static <E, K> Map<K, List<E>> topN(Supplier<E> supplier, Function<E, TopInfo<K>> group, Predicate<E> filter, BiFunction<E, E, Integer> comparator) {
        return ToMap.topN((Consumer<E> consumer) -> {
            Object e;
            while ((e = supplier.get()) != null) {
                consumer.accept(e);
            }
        }, group, filter, comparator);
    }

    public static <E, K> Map<K, List<E>> topN(Collection<E> collection, Function<E, TopInfo<K>> group, Predicate<E> filter, BiFunction<E, E, Integer> comparator) {
        return ToMap.topN((Consumer<E> consumer) -> {
            for (Object e : collection) {
                consumer.accept(e);
            }
        }, group, filter, comparator);
    }

    public static <E, K> Map<K, E> topOne(Consumer<Consumer<E>> runnable, Function<E, K> group, Predicate<E> filter, BiFunction<E, E, Integer> comparator) {
        HashMap queues = new HashMap();
        runnable.accept(t -> {
            if (t == null || filter != null && !filter.test(t)) {
                return;
            }
            Object key = group.apply(t);
            RedBlackBSTPQueue queue = queues.computeIfAbsent(key, k -> RedBlackBSTPQueue.Min.of(comparator::apply));
            while (queue.size() > 1) {
                queue.poll();
            }
            if (queue.size() == 1) {
                if ((Integer)comparator.apply(t, queue.peek()) > 0) {
                    queue.poll();
                    queue.offer(t);
                }
            } else {
                queue.offer(t);
            }
        });
        return ToMap.explicitCollect(queues.keySet().stream(), Function.identity(), key -> ((RedBlackBSTPQueue)queues.get(key)).poll(), queues.size());
    }

    public static <E, K> Map<K, E> topOne(Supplier<E> supplier, Function<E, K> group, Predicate<E> filter, BiFunction<E, E, Integer> comparator) {
        return ToMap.topOne((Consumer<E> consumer) -> {
            Object e;
            while ((e = supplier.get()) != null) {
                consumer.accept(e);
            }
        }, group, filter, comparator);
    }

    public static <E, K> Map<K, E> topOne(Collection<E> collection, Function<E, K> group, Predicate<E> filter, BiFunction<E, E, Integer> comparator) {
        return ToMap.topOne((Consumer<E> consumer) -> {
            for (Object e : collection) {
                consumer.accept(e);
            }
        }, group, filter, comparator);
    }
}

