/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import shz.ToMap;

public final class ToSet<E> {
    private final Set<E> set;

    private ToSet(int initialCapacity, int idx, boolean dummy) {
        this.set = dummy ? new LinkedHashSet(ToMap.reduce(initialCapacity, idx), 1.0f) : new HashSet(ToMap.reduce(initialCapacity, idx), 1.0f);
    }

    public static <E> ToSet<E> get(int initialCapacity, int idx, boolean dummy) {
        return new ToSet<E>(initialCapacity, idx, dummy);
    }

    public static <E> ToSet<E> get(int initialCapacity, int idx) {
        return new ToSet<E>(initialCapacity, idx, false);
    }

    public static <E> ToSet<E> get(int initialCapacity) {
        return new ToSet<E>(initialCapacity, 0, false);
    }

    public <T> T build() {
        return (T)this.set;
    }

    public ToSet<E> add(Collection<? extends E> c) {
        this.set.addAll(c);
        return this;
    }

    public final <EE extends E> ToSet<E> add(EE e) {
        this.set.add(e);
        return this;
    }

    public static <E, R extends Set<E>> Collector<E, ?, R> collector(Supplier<R> supplier) {
        return Collector.of(supplier, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.UNORDERED);
    }

    public static <E, R extends Set<E>> Collector<E, ?, R> collector(int initialCapacity, int idx, boolean dummy) {
        return ToSet.collector(() -> (Set)ToSet.get(initialCapacity, idx, dummy).build());
    }

    public static <E> Collector<E, ?, Set<E>> collector(int initialCapacity, int idx) {
        return ToSet.collector(initialCapacity, idx, false);
    }

    public static <E> Collector<E, ?, Set<E>> collector(int initialCapacity) {
        return ToSet.collector(initialCapacity, 0, false);
    }

    public static <E> Set<E> explicitCollect(Stream<E> stream, int initialCapacity, int idx, boolean dummy) {
        Set set = (Set)stream.collect(ToSet.collector(initialCapacity, idx, dummy));
        return set.isEmpty() ? Collections.emptySet() : set;
    }

    public static <E> Set<E> explicitCollect(Stream<E> stream, int initialCapacity) {
        return ToSet.explicitCollect(stream, initialCapacity, 0, false);
    }

    public static <E> Collector<E, ?, Set<E>> collector(boolean dummy) {
        return ToSet.collector(dummy ? LinkedHashSet::new : HashSet::new);
    }

    public static <E> Collector<E, ?, Set<E>> collector() {
        return ToSet.collector(false);
    }

    public static <E> Set<E> collect(Stream<E> stream, boolean dummy, int extra) {
        int newCap;
        int size = Math.max(extra, 0);
        Set<E> set = stream.collect(ToSet.collector(dummy));
        if (set.isEmpty()) {
            return size == 0 ? Collections.emptySet() : (Set)ToSet.get(size, 0, dummy).build();
        }
        if (size == 0) {
            return set;
        }
        int oldCap = ToMap.reduce(set.size(), 0);
        if (oldCap >= (newCap = ToMap.reduce(size + set.size(), 1))) {
            return set;
        }
        newCap = ToMap.reduce(size + set.size(), 0);
        HashSet result = dummy ? new LinkedHashSet(newCap, 1.0f) : new HashSet(newCap, 1.0f);
        result.addAll(set);
        return result;
    }

    public static <E> Set<E> collect(Stream<E> stream, boolean dummy) {
        return ToSet.collect(stream, dummy, 0);
    }

    public static <E> Set<E> collect(Stream<E> stream, int extra) {
        return ToSet.collect(stream, false, extra);
    }

    public static <E> Set<E> collect(Stream<E> stream) {
        return ToSet.collect(stream, false, 0);
    }

    public static <E> Set<E> asSet(E ... es) {
        if (es == null || es.length == 0) {
            return Collections.emptySet();
        }
        if (es.length == 1) {
            return Collections.singleton(es[0]);
        }
        return Arrays.stream(es).collect(ToSet.collector(es.length));
    }
}

