/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class UnsafeHelp {
    private static final Unsafe unsafe;
    private static final int bbase;
    private static final int bscale;
    private static final int cbase;
    private static final int cscale;
    private static final int dbase;
    private static final int dscale;
    private static final int fbase;
    private static final int fscale;
    private static final int ibase;
    private static final int iscale;
    private static final int jbase;
    private static final int jscale;
    private static final int sbase;
    private static final int sscale;
    private static final int zbase;
    private static final int zscale;
    private static final int lbase;
    private static final int lscale;

    private UnsafeHelp() {
        throw new IllegalStateException();
    }

    private static int checkIs2Power(int scale) {
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        return scale;
    }

    public static Unsafe getUnsafe() {
        return unsafe;
    }

    public static long byteOffset(int i, int base, int scale) {
        return ((long)i << 31 - Integer.numberOfLeadingZeros(scale)) + (long)base;
    }

    public static long byteOffset(int i, Class<?> cls) {
        if (cls == Object[].class) {
            return UnsafeHelp.byteOffset(i, lbase, lscale);
        }
        if (cls == byte[].class) {
            return UnsafeHelp.byteOffset(i, bbase, bscale);
        }
        if (cls == char[].class) {
            return UnsafeHelp.byteOffset(i, cbase, cscale);
        }
        if (cls == int[].class) {
            return UnsafeHelp.byteOffset(i, ibase, iscale);
        }
        if (cls == long[].class) {
            return UnsafeHelp.byteOffset(i, jbase, jscale);
        }
        if (cls == boolean[].class) {
            return UnsafeHelp.byteOffset(i, zbase, zscale);
        }
        if (cls == short[].class) {
            return UnsafeHelp.byteOffset(i, sbase, sscale);
        }
        if (cls == double[].class) {
            return UnsafeHelp.byteOffset(i, dbase, dscale);
        }
        if (cls == float[].class) {
            return UnsafeHelp.byteOffset(i, fbase, fscale);
        }
        return UnsafeHelp.byteOffset(i, unsafe.arrayBaseOffset(cls), UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(cls)));
    }

    static {
        Field unsafeField = Unsafe.class.getDeclaredFields()[0];
        unsafeField.setAccessible(true);
        try {
            unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new Error(e);
        }
        bbase = unsafe.arrayBaseOffset(byte[].class);
        bscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        cbase = unsafe.arrayBaseOffset(char[].class);
        cscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        dbase = unsafe.arrayBaseOffset(double[].class);
        dscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        fbase = unsafe.arrayBaseOffset(float[].class);
        fscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        ibase = unsafe.arrayBaseOffset(int[].class);
        iscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        jbase = unsafe.arrayBaseOffset(long[].class);
        jscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        sbase = unsafe.arrayBaseOffset(short[].class);
        sscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        zbase = unsafe.arrayBaseOffset(boolean[].class);
        zscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
        lbase = unsafe.arrayBaseOffset(Object[].class);
        lscale = UnsafeHelp.checkIs2Power(unsafe.arrayIndexScale(int[].class));
    }
}

