/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import shz.constant.ArrayConstant;

public class Validator {
    private static final Map<Class<?>, Object[]> EMPTY_ARRAY_CACHE = new ConcurrentHashMap(128);

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean nonEmpty(CharSequence cs) {
        return !Validator.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        return Validator.isEmpty(cs) || cs.chars().parallel().allMatch(Character::isWhitespace);
    }

    public static boolean nonBlank(CharSequence cs) {
        return !Validator.isBlank(cs);
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(boolean[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(boolean[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (boolean e : array) {
            if (!e) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(boolean[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(byte[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(byte[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (byte e : array) {
            if (e == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(byte[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(char[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(char[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (char e : array) {
            if (Character.isWhitespace(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(char[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(short[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(short[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (short e : array) {
            if (e == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(short[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(int[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(int[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (int e : array) {
            if (e == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(int[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(long[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(long[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (long e : array) {
            if (e == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(long[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(double[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(double[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (double e : array) {
            if (e == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(double[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(float[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(float[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        for (float e : array) {
            if (e == 0.0f) continue;
            return false;
        }
        return true;
    }

    public static boolean nonBlank(float[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean nonEmpty(Object[] array) {
        return !Validator.isEmpty(array);
    }

    public static boolean isBlank(Object[] array) {
        if (Validator.isEmpty(array)) {
            return true;
        }
        return ((Stream)Arrays.stream(array).parallel()).allMatch(Validator::isBlank);
    }

    public static boolean nonBlank(Object[] array) {
        return !Validator.isBlank(array);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean nonEmpty(Collection<?> collection) {
        return !Validator.isEmpty(collection);
    }

    public static boolean isBlank(Collection<?> collection) {
        if (Validator.isEmpty(collection)) {
            return true;
        }
        return collection.parallelStream().allMatch(Validator::isBlank);
    }

    public static boolean nonBlank(Collection<?> collection) {
        return !Validator.isBlank(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    public static boolean nonEmpty(Map<?, ?> map) {
        return !Validator.isEmpty(map);
    }

    public static boolean isBlank(Map<?, ?> map) {
        if (Validator.isEmpty(map)) {
            return true;
        }
        return map.values().parallelStream().allMatch(Validator::isBlank);
    }

    public static boolean nonBlank(Map<?, ?> map) {
        return !Validator.isBlank(map);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return Validator.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return Validator.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return Validator.isEmpty((Map)obj);
        }
        if (obj instanceof Object[]) {
            return Validator.isEmpty((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return Validator.isEmpty((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Validator.isEmpty((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Validator.isEmpty((char[])obj);
        }
        if (obj instanceof short[]) {
            return Validator.isEmpty((short[])obj);
        }
        if (obj instanceof int[]) {
            return Validator.isEmpty((int[])obj);
        }
        if (obj instanceof long[]) {
            return Validator.isEmpty((long[])obj);
        }
        if (obj instanceof double[]) {
            return Validator.isEmpty((double[])obj);
        }
        if (obj instanceof float[]) {
            return Validator.isEmpty((float[])obj);
        }
        return false;
    }

    public static boolean nonEmpty(Object obj) {
        return !Validator.isEmpty(obj);
    }

    public static boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return Validator.isBlank((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return Validator.isBlank((Collection)obj);
        }
        if (obj instanceof Map) {
            return Validator.isBlank((Map)obj);
        }
        if (obj instanceof Object[]) {
            return Validator.isBlank((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return Validator.isBlank((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Validator.isBlank((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Validator.isBlank((char[])obj);
        }
        if (obj instanceof short[]) {
            return Validator.isBlank((short[])obj);
        }
        if (obj instanceof int[]) {
            return Validator.isBlank((int[])obj);
        }
        if (obj instanceof long[]) {
            return Validator.isBlank((long[])obj);
        }
        if (obj instanceof double[]) {
            return Validator.isBlank((double[])obj);
        }
        if (obj instanceof float[]) {
            return Validator.isBlank((float[])obj);
        }
        return false;
    }

    public static boolean nonBlank(Object obj) {
        return !Validator.isBlank(obj);
    }

    public static boolean equals(Object one, Object other) {
        if (one == null || other == null || one.hashCode() != other.hashCode()) {
            return false;
        }
        return one instanceof String ? one.toString().equals(other) : one == other;
    }

    public static boolean nonEquals(Object one, Object other) {
        return !Validator.equals(one, other);
    }

    public static boolean isTrue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof CharSequence) {
            String s = obj.toString();
            return "1".equals(s) || "true".equalsIgnoreCase(s);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() == 1;
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue() == '1';
        }
        return false;
    }

    public static boolean isFalse(Object obj) {
        return !Validator.isTrue(obj);
    }

    public static <T> T off(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof List) {
            return (T)(((List)t).isEmpty() ? Collections.EMPTY_LIST : t);
        }
        if (t instanceof Set) {
            return (T)(((Set)t).isEmpty() ? Collections.EMPTY_SET : t);
        }
        if (t instanceof Map) {
            return (T)(((Map)t).isEmpty() ? Collections.EMPTY_MAP : t);
        }
        if (t instanceof Object[]) {
            return (T)(((Object[])t).length == 0 ? Validator.emptyArray(t.getClass()) : t);
        }
        if (t instanceof boolean[] || t instanceof byte[] || t instanceof char[] || t instanceof short[] || t instanceof int[] || t instanceof long[] || t instanceof double[] || t instanceof float[]) {
            return (T)(Validator.isEmpty(t) ? Validator.emptyPrimitiveArray(t.getClass()) : t);
        }
        return t;
    }

    private static <T> T[] emptyArray(Class<?> cls) {
        if (cls == Object[].class) {
            return ArrayConstant.EMPTY_OBJECT_ARRAY;
        }
        if (cls == String[].class) {
            return ArrayConstant.EMPTY_STRING_ARRAY;
        }
        return EMPTY_ARRAY_CACHE.computeIfAbsent(cls, k -> (Object[])Array.newInstance(cls.getComponentType(), 0));
    }

    private static Object emptyPrimitiveArray(Class<?> cls) {
        if (cls == boolean[].class) {
            return ArrayConstant.EMPTY_BOOLEAN_ARRAY;
        }
        if (cls == byte[].class) {
            return ArrayConstant.EMPTY_BYTE_ARRAY;
        }
        if (cls == char[].class) {
            return ArrayConstant.EMPTY_CHAR_ARRAY;
        }
        if (cls == short[].class) {
            return ArrayConstant.EMPTY_SHORT_ARRAY;
        }
        if (cls == int[].class) {
            return ArrayConstant.EMPTY_INT_ARRAY;
        }
        if (cls == long[].class) {
            return ArrayConstant.EMPTY_LONG_ARRAY;
        }
        if (cls == double[].class) {
            return ArrayConstant.EMPTY_DOUBLE_ARRAY;
        }
        if (cls == float[].class) {
            return ArrayConstant.EMPTY_FLOAT_ARRAY;
        }
        return null;
    }

    public static <T> T empty(Class<?> cls) {
        if (cls == null) {
            throw new IllegalStateException();
        }
        if (List.class.isAssignableFrom(cls)) {
            return (T)Collections.EMPTY_LIST;
        }
        if (Set.class.isAssignableFrom(cls)) {
            return (T)Collections.EMPTY_SET;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return (T)Collections.EMPTY_MAP;
        }
        if (Object[].class.isAssignableFrom(cls)) {
            return (T)Validator.emptyArray(cls);
        }
        return (T)Validator.emptyPrimitiveArray(cls);
    }

    public static <T> T empty(Class<?> cls, T t) {
        return t == null ? Validator.empty(cls) : Validator.off(t);
    }

    public static <T> T nonNull(T t) {
        if ((t = Validator.off(t)) == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T nonNull(Class<? extends T> cls, T t) {
        if ((t = Validator.empty(cls, t)) == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static boolean isAnyEmpty(Object obj1, Object obj2) {
        return Validator.isEmpty(obj1) || Validator.isEmpty(obj2);
    }

    public static boolean nonAnyEmpty(Object obj1, Object obj2) {
        return !Validator.isAnyEmpty(obj1, obj2);
    }

    public static boolean isAnyEmpty(Object obj1, Object obj2, Object obj3) {
        return Validator.isEmpty(obj1) || Validator.isEmpty(obj2) || Validator.isEmpty(obj3);
    }

    public static boolean nonAnyEmpty(Object obj1, Object obj2, Object obj3) {
        return !Validator.isAnyEmpty(obj1, obj2, obj3);
    }

    public static boolean isAnyEmpty(Object ... objects) {
        return ((Stream)Arrays.stream(objects).parallel()).anyMatch(Validator::isEmpty);
    }

    public static boolean nonAnyEmpty(Object ... objects) {
        return !Validator.isAnyEmpty(objects);
    }

    public static boolean isAnyBlank(Object obj1, Object obj2) {
        return Validator.isBlank(obj1) || Validator.isBlank(obj2);
    }

    public static boolean nonAnyBlank(Object obj1, Object obj2) {
        return !Validator.isAnyBlank(obj1, obj2);
    }

    public static boolean isAnyBlank(Object obj1, Object obj2, Object obj3) {
        return Validator.isBlank(obj1) || Validator.isBlank(obj2) || Validator.isBlank(obj3);
    }

    public static boolean nonAnyBlank(Object obj1, Object obj2, Object obj3) {
        return !Validator.isAnyBlank(obj1, obj2, obj3);
    }

    public static boolean isAnyBlank(Object ... objects) {
        return ((Stream)Arrays.stream(objects).parallel()).anyMatch(Validator::isBlank);
    }

    public static boolean nonAnyBlank(Object ... objects) {
        return !Validator.isAnyBlank(objects);
    }

    public static boolean isAnyNull(Object obj1, Object obj2) {
        return obj1 == null || obj2 == null;
    }

    public static boolean nonAnyNull(Object obj1, Object obj2) {
        return !Validator.isAnyNull(obj1, obj2);
    }

    public static boolean isAnyNull(Object obj1, Object obj2, Object obj3) {
        return obj1 == null || obj2 == null || obj3 == null;
    }

    public static boolean nonAnyNull(Object obj1, Object obj2, Object obj3) {
        return !Validator.isAnyNull(obj1, obj2, obj3);
    }

    public static boolean isAnyNull(Object ... objects) {
        return ((Stream)Arrays.stream(objects).parallel()).anyMatch(Objects::isNull);
    }

    public static boolean nonAnyNull(Object ... objects) {
        return !Validator.isAnyNull(objects);
    }

    public static void requireNon(boolean condition) {
        if (condition) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonEmpty(Object obj) {
        if (Validator.isEmpty(obj)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyEmpty(Object obj1, Object obj2) {
        if (Validator.isAnyEmpty(obj1, obj2)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyEmpty(Object obj1, Object obj2, Object obj3) {
        if (Validator.isAnyEmpty(obj1, obj2, obj3)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyEmpty(Object ... objects) {
        if (Validator.isAnyEmpty(objects)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonBlank(Object obj) {
        if (Validator.isBlank(obj)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyBlank(Object obj1, Object obj2) {
        if (Validator.isAnyBlank(obj1, obj2)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyBlank(Object obj1, Object obj2, Object obj3) {
        if (Validator.isAnyBlank(obj1, obj2, obj3)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyBlank(Object ... objects) {
        if (Validator.isAnyBlank(objects)) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireNonAnyNull(Object obj1, Object obj2) {
        if (Validator.isAnyNull(obj1, obj2)) {
            throw new NullPointerException();
        }
    }

    public static void requireNonAnyNull(Object obj1, Object obj2, Object obj3) {
        if (Validator.isAnyNull(obj1, obj2, obj3)) {
            throw new NullPointerException();
        }
    }

    public static void requireNonAnyNull(Object ... objects) {
        if (Validator.isAnyNull(objects)) {
            throw new NullPointerException();
        }
    }
}

