/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import shz.FileHelp;
import shz.IOHelp;
import shz.PRException;
import shz.Validator;
import shz.msg.ServerFailureMsg;

public final class ZipHelp {
    private static final File temp_folder = new File(System.getProperty("user.home"), "from-zip-file-temp");

    private ZipHelp() {
        throw new IllegalStateException();
    }

    public static void updateZipFile(File file, Map<String, String> packageFile, int dataSize) {
        File tempFile;
        try {
            tempFile = File.createTempFile(file.getName(), null);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        FileHelp.deleteFile(tempFile);
        ServerFailureMsg.requireNon(!file.renameTo(tempFile), "\u6587\u4ef6\u4e0d\u53ef\u91cd\u547d\u540d");
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            ZipEntry entry;
            zis = IOHelp.getZis(tempFile);
            zos = IOHelp.getZos(file);
            while ((entry = zis.getNextEntry()) != null) {
                if (packageFile.containsKey(entry.getName())) continue;
                zos.putNextEntry(new ZipEntry(entry.getName()));
                IOHelp.read(zis, zos, dataSize, null, (i, o) -> {
                    try {
                        o.closeEntry();
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                });
            }
        }
        catch (IOException e) {
            IOHelp.close(zos);
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(zis);
        }
        try {
            for (Map.Entry<String, String> kv : packageFile.entrySet()) {
                BufferedInputStream bis = IOHelp.getBis(kv.getValue());
                zos.putNextEntry(new ZipEntry(kv.getKey()));
                IOHelp.read(bis, zos, dataSize, null, (i, o) -> {
                    try {
                        o.closeEntry();
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                    finally {
                        IOHelp.close(i);
                    }
                });
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(zos);
            FileHelp.deleteFile(tempFile);
        }
    }

    public static InputStream getIsFromZis(ZipInputStream zis, String path, int dataSize) {
        if (zis == null || Validator.isBlank(path)) {
            return null;
        }
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!ZipHelp.isEntry(entry, path)) continue;
                return new ByteArrayInputStream(IOHelp.read(zis, dataSize, null));
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        return null;
    }

    private static boolean isEntry(ZipEntry entry, String path) {
        String entryName = entry.getName();
        String string = entryName = entryName.charAt(0) == '/' ? entryName.substring(1) : entryName;
        if (path.equals(entryName)) {
            return true;
        }
        int index = entryName.lastIndexOf(47);
        return index != -1 && path.equals(entryName.substring(index + 1));
    }

    public static InputStream getIsFromZipFile(ZipFile zip, String path, int dataSize) {
        if (zip == null || Validator.isBlank(path)) {
            return null;
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!ZipHelp.isEntry(entry, path)) continue;
                InputStream is = zip.getInputStream(entry);
                return new ByteArrayInputStream(IOHelp.read(is, dataSize, null));
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        return null;
    }

    public static String getFileFromZis(ZipInputStream zis, int dataSize, Set<String> paths) {
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null && paths.size() > 0) {
                ZipHelp.writeFiles(zis, entry, dataSize, paths);
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(zis);
        }
        return temp_folder.getAbsolutePath();
    }

    private static void writeFiles(InputStream is, ZipEntry entry, int dataSize, Set<String> paths) {
        if (temp_folder.mkdirs() || temp_folder.exists()) {
            Iterator<String> it = paths.iterator();
            while (it.hasNext()) {
                String next = it.next();
                if (!ZipHelp.isEntry(entry, next)) continue;
                IOHelp.read(is, IOHelp.getBos(new File(temp_folder, next)), dataSize, null, (i, o) -> IOHelp.close(o));
                it.remove();
                break;
            }
        }
    }

    public static void deleteTempFolder() {
        FileHelp.deleteFile(temp_folder.getAbsolutePath());
    }

    public static String getFileFromZipFile(ZipFile zip, int dataSize, Set<String> paths) {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        InputStream is = null;
        try {
            while (entries.hasMoreElements() && paths.size() > 0) {
                ZipEntry entry = entries.nextElement();
                is = zip.getInputStream(entry);
                ZipHelp.writeFiles(is, entry, dataSize, paths);
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(is);
        }
        return temp_folder.getAbsolutePath();
    }

    public static void compress(Set<File> srcs, File des, int dataSize) {
        ZipOutputStream zos = IOHelp.getZos(des);
        srcs.stream().filter(Objects::nonNull).filter(f -> f.exists() && f.canRead()).forEach(f -> ZipHelp.compress0(zos, dataSize, "", f));
    }

    public static void compress0(ZipOutputStream zos, int dataSize, String path, File ... files) {
        Arrays.stream(files).forEach(f -> {
            if (f.isFile()) {
                BufferedInputStream bis = IOHelp.getBis(f);
                try {
                    zos.putNextEntry(new ZipEntry(path + f.getName()));
                }
                catch (IOException e) {
                    throw PRException.of(e);
                }
                IOHelp.read(bis, zos, dataSize, null, (i, o) -> {
                    try {
                        o.closeEntry();
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                    finally {
                        IOHelp.close(i);
                    }
                });
            } else {
                Object[] fs = f.listFiles();
                if (Validator.isEmpty(fs)) {
                    try {
                        zos.putNextEntry(new ZipEntry(path + f.getName() + "/"));
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                } else {
                    ZipHelp.compress0(zos, dataSize, path + "/" + f.getName(), (File[])fs);
                }
            }
        });
    }

    public static void compress(Set<File> srcs, File des) {
        ZipHelp.compress(srcs, des, 1024);
    }

    public static void decompress(File src, File des, int dataSize) {
        ZipFile zip;
        if (src == null) {
            return;
        }
        FileHelp.checkCopyFile(des);
        try {
            zip = new ZipFile(src);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        InputStream is = null;
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File f = new File(des, entry.getName());
                if (entry.isDirectory()) {
                    if (f.mkdirs() || f.exists()) continue;
                    throw new IllegalArgumentException();
                }
                is = zip.getInputStream(entry);
                IOHelp.read(is, IOHelp.getBos(f), dataSize, null, (i, o) -> IOHelp.close(o));
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(is);
        }
    }

    public static void decompress(File src, File des) {
        ZipHelp.decompress(src, des, 1024);
    }

    public static void updateJarFile(File file, Map<String, String> packageFile, int dataSize) {
        File tempFile;
        try {
            tempFile = File.createTempFile(file.getName(), null);
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        FileHelp.deleteFile(tempFile);
        ServerFailureMsg.requireNon(!file.renameTo(tempFile), "\u6587\u4ef6\u4e0d\u53ef\u91cd\u547d\u540d");
        JarInputStream jis = null;
        JarOutputStream jos = null;
        try {
            JarEntry entry;
            jis = IOHelp.getJis(tempFile);
            jos = IOHelp.getJos(file);
            while ((entry = (JarEntry)jis.getNextEntry()) != null) {
                if (packageFile.containsKey(entry.getName())) continue;
                jos.putNextEntry(new JarEntry(entry.getName()));
                IOHelp.read(jis, jos, dataSize, null, (i, o) -> {
                    try {
                        o.closeEntry();
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                });
            }
        }
        catch (IOException e) {
            IOHelp.close(jos);
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(jis);
        }
        try {
            for (Map.Entry<String, String> kv : packageFile.entrySet()) {
                BufferedInputStream bis = IOHelp.getBis(kv.getValue());
                jos.putNextEntry(new JarEntry(kv.getKey()));
                IOHelp.read(bis, jos, dataSize, null, (i, o) -> {
                    try {
                        o.closeEntry();
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                    finally {
                        IOHelp.close(i);
                    }
                });
            }
        }
        catch (IOException e) {
            IOHelp.close(jos);
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(jos);
            FileHelp.deleteFile(tempFile);
        }
    }

    public static InputStream getIsFromJis(JarInputStream jis, String path, int dataSize) {
        if (jis == null || Validator.isBlank(path)) {
            return null;
        }
        try {
            JarEntry entry;
            while ((entry = (JarEntry)jis.getNextEntry()) != null) {
                if (!ZipHelp.isEntry(entry, path)) continue;
                return new ByteArrayInputStream(IOHelp.read(jis, dataSize, null));
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        return null;
    }

    public static InputStream getIsFromJarFile(JarFile jar, String path, int dataSize) {
        if (jar == null || Validator.isBlank(path)) {
            return null;
        }
        Enumeration<JarEntry> entries = jar.entries();
        try {
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!ZipHelp.isEntry(entry, path)) continue;
                InputStream is = jar.getInputStream(entry);
                return new ByteArrayInputStream(IOHelp.read(is, dataSize, null));
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        return null;
    }

    public static String getFileFromJis(JarInputStream jis, int dataSize, Set<String> paths) {
        try {
            JarEntry entry;
            while ((entry = (JarEntry)jis.getNextEntry()) != null && paths.size() > 0) {
                ZipHelp.writeFiles(jis, entry, dataSize, paths);
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(jis);
        }
        return temp_folder.getAbsolutePath();
    }

    public static String getFileFromJarFile(JarFile jar, int dataSize, Set<String> paths) {
        Enumeration<JarEntry> entries = jar.entries();
        InputStream is = null;
        try {
            while (entries.hasMoreElements() && paths.size() > 0) {
                JarEntry entry = entries.nextElement();
                is = jar.getInputStream(entry);
                ZipHelp.writeFiles(is, entry, dataSize, paths);
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(is);
        }
        return temp_folder.getAbsolutePath();
    }

    public static void makeJar(File file, JarOutputStream jos) {
        Object[] files = file.listFiles();
        if (Validator.nonEmpty(files)) {
            try {
                int idx = file.getAbsolutePath().replaceAll("\\\\", "/").lastIndexOf("/") + 1;
                for (Object f : files) {
                    ZipHelp.makeJar0((File)f, jos, idx);
                }
            }
            catch (IOException e) {
                throw PRException.of(e);
            }
            finally {
                IOHelp.close(jos);
            }
        }
    }

    private static void makeJar0(File file, JarOutputStream jos, int idx) throws IOException {
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (Validator.nonEmpty(files)) {
                for (Object f : files) {
                    ZipHelp.makeJar0((File)f, jos, idx);
                }
            }
        } else {
            BufferedInputStream bis = IOHelp.getBis(file);
            jos.putNextEntry(new JarEntry(file.getAbsolutePath().replaceAll("\\\\", "/").substring(idx)));
            IOHelp.read(bis, jos, 1024, null, (i, o) -> {
                try {
                    o.closeEntry();
                }
                catch (IOException e) {
                    throw PRException.of(e);
                }
                finally {
                    IOHelp.close(i);
                }
            });
        }
    }

    public static void makeRunnableJar(JarInputStream jis, JarOutputStream jos) {
        try {
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                if ("META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                jos.putNextEntry(entry);
                IOHelp.read(jis, jos, 1024, null, (i, o) -> {
                    try {
                        o.closeEntry();
                    }
                    catch (IOException e) {
                        throw PRException.of(e);
                    }
                });
            }
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        finally {
            IOHelp.close(jos, jis);
        }
    }

    public static void makeRunnableJar(JarInputStream jis, File newJar, Manifest manifest) {
        ZipHelp.makeRunnableJar(jis, IOHelp.getJos(newJar, false, manifest));
    }

    public static void makeRunnableJar(JarInputStream jis, File newJar, String mainClass, String version) {
        Attributes a;
        String oldMainClass;
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
        }
        if ((oldMainClass = (a = manifest.getMainAttributes()).putValue("Main-Class", mainClass)) != null) {
            IOHelp.close(jis);
            return;
        }
        if (version == null && (version = (String)a.get("Manifest-Version")) == null) {
            version = (String)a.get("Signature-Version");
        }
        a.putValue("Manifest-Version", version);
        ZipHelp.makeRunnableJar(jis, IOHelp.getJos(newJar, false, manifest));
    }

    public static String read(InputStream is, Charset charset) {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new ByteArrayInputStream(IOHelp.read(is))), charset));
        }
        catch (IOException e) {
            throw PRException.of(e);
        }
        StringWriter sw = new StringWriter();
        IOHelp.read(br, sw);
        return sw.toString();
    }
}

