/*
 * Decompiled with CFR 0.152.
 */
package shz.accept;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import shz.AccessibleHelp;
import shz.ThreadHelp;
import shz.accept.AcceptCallback;

public abstract class AcceptExecutor<T> {
    private final String threadName;
    private Executor executor;
    private final Lock lock;
    private final Condition sleep;
    private final Condition finish;
    private final Condition delay;
    private volatile boolean stop = true;
    private volatile boolean wait;
    protected final Map<String, AcceptCallback> callbacks;

    protected AcceptExecutor(String threadName) {
        this.threadName = threadName;
        this.lock = new ReentrantLock();
        this.sleep = this.lock.newCondition();
        this.finish = this.lock.newCondition();
        this.delay = this.lock.newCondition();
        this.callbacks = new HashMap<String, AcceptCallback>();
    }

    protected AcceptExecutor() {
        this.threadName = AccessibleHelp.identify(this.getClass());
        this.lock = new ReentrantLock();
        this.sleep = this.lock.newCondition();
        this.finish = this.lock.newCondition();
        this.delay = this.lock.newCondition();
        this.callbacks = new HashMap<String, AcceptCallback>();
    }

    protected boolean acceptable(T t) {
        return true;
    }

    protected abstract void consumer(T var1);

    protected long sleepMicroSeconds(T t) {
        return 0L;
    }

    protected boolean stoppable(T t) {
        return false;
    }

    protected long gapMilliSeconds(T t) {
        return 0L;
    }

    protected long gapSleepMilliSeconds(T t) {
        return 50L;
    }

    protected long finishMilliSeconds(T t) {
        return 0L;
    }

    protected long delayMicroSeconds(T t) {
        return 5000L;
    }

    protected void log(Throwable cause) {
        cause.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(T t) {
        while (!this.stop && this.lock.tryLock()) {
            try {
                long delta;
                long idleMillis = 0L;
                long gapMillis = this.gapMilliSeconds(t);
                long gapSleepMillis = this.gapSleepMilliSeconds(t);
                gapSleepMillis = gapMillis > 0L ? Math.min(gapMillis, gapSleepMillis <= 0L ? 50L : gapSleepMillis) : 0L;
                while (!this.stop) {
                    boolean acceptable = false;
                    try {
                        acceptable = this.acceptable(t);
                    }
                    catch (Throwable e) {
                        this.log(e);
                    }
                    if (!acceptable) {
                        if (gapSleepMillis == 0L || idleMillis >= gapMillis) break;
                        try {
                            TimeUnit.MILLISECONDS.sleep(gapSleepMillis);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        idleMillis += gapSleepMillis;
                        continue;
                    }
                    idleMillis = 0L;
                    try {
                        this.consumer(t);
                    }
                    catch (Throwable e) {
                        this.log(e);
                    }
                    try {
                        long time = this.sleepMicroSeconds(t);
                        if (time <= 0L) continue;
                        this.sleep.await(time, TimeUnit.MICROSECONDS);
                    }
                    catch (Throwable e) {
                        this.log(e);
                    }
                }
                if (!this.stop) {
                    try {
                        this.stop = this.stoppable(t);
                    }
                    catch (Throwable e) {
                        this.log(e);
                    }
                }
                if (this.stop) continue;
                this.wait = true;
                if (this.stop) continue;
                long finishTime = 100L;
                long curMillis = System.currentTimeMillis();
                try {
                    finishTime = this.finishMilliSeconds(t);
                    this.callbacks.values().forEach(AcceptCallback::execute);
                }
                catch (Throwable e) {
                    this.log(e);
                }
                finishTime = finishTime > 0L ? ((delta = finishTime + curMillis - System.currentTimeMillis()) != 0L ? delta : 100L) : 0L;
                if (this.wait) {
                    try {
                        if (finishTime > 0L) {
                            this.finish.await(finishTime, TimeUnit.MILLISECONDS);
                        } else if (finishTime == 0L) {
                            this.finish.await();
                        }
                    }
                    catch (InterruptedException e) {
                        this.log(e);
                    }
                    this.wait = false;
                }
                long delayTime = 0L;
                try {
                    delayTime = this.delayMicroSeconds(t);
                }
                catch (Throwable e) {
                    this.log(e);
                }
                if (delayTime > 0L && finishTime < 0L) {
                    long delta2 = delayTime + finishTime;
                    delayTime = delta2 > 0L ? delta2 : 100L;
                }
                try {
                    if (delayTime <= 0L) continue;
                    this.delay.await(delayTime, TimeUnit.MICROSECONDS);
                }
                catch (InterruptedException e) {
                    this.log(e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final void execute(T target) {
        if (!this.stop || !this.lock.tryLock()) {
            return;
        }
        try {
            if (!this.stop) {
                return;
            }
            this.stop = false;
            if (this.executor == null) {
                this.executor = ThreadHelp.getExecutor(ThreadHelp.TPConfig.of(this.threadName).tpType(ThreadHelp.TPType.SINGLE_THREAD_EXECUTOR).daemon(true).workQueue(new LinkedBlockingQueue<Runnable>(1)));
            }
            this.executor.execute(() -> this.run(target));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaken() {
        if (!this.wait || !this.lock.tryLock()) {
            return;
        }
        try {
            if (!this.wait) {
                return;
            }
            this.wait = false;
            this.finish.signal();
        }
        catch (Throwable t) {
            this.log(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void awaken(T target) {
        this.execute(target);
        this.awaken();
    }

    public final boolean isStop() {
        return this.stop;
    }

    public synchronized void stop() {
        if (!this.stop) {
            this.stop = true;
            this.awaken();
        }
    }

    public final void registerCallback(String name, AcceptCallback callback) {
        this.callbacks.put(name, callback);
    }

    public final void unRegisterCallback(String name) {
        this.callbacks.remove(name);
    }
}

