/*
 * Decompiled with CFR 0.152.
 */
package shz.accept;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import shz.Validator;
import shz.accept.AcceptExecutor;

public abstract class MemoryAcceptExecutor<D>
extends AcceptExecutor<Void> {
    protected final Queue<D> queue = new ConcurrentLinkedQueue<D>();

    protected MemoryAcceptExecutor(String threadName) {
        super(threadName);
    }

    protected MemoryAcceptExecutor() {
    }

    @Override
    protected boolean acceptable(Void unused) {
        return !this.queue.isEmpty();
    }

    @Override
    protected void consumer(Void unused) {
        D data = this.queue.poll();
        if (data != null) {
            this.consumer0(data);
        }
    }

    public void push(D data) {
        if (Validator.isBlank(data)) {
            return;
        }
        if (this.queue.size() >= this.queueSize()) {
            this.overStrategy(data);
        } else {
            this.queue.offer(data);
            this.awaken(null);
        }
    }

    protected int queueSize() {
        return 0x8000000;
    }

    protected void overStrategy(D data) {
        this.queue.poll();
        this.queue.offer(data);
        this.awaken(null);
    }

    public void push(Collection<D> dataset) {
        if (Validator.isEmpty(dataset)) {
            return;
        }
        this.queue.addAll(dataset);
        this.awaken(null);
    }

    protected abstract void consumer0(D var1);
}

