/*
 * Decompiled with CFR 0.152.
 */
package shz.encrypt;

import java.io.File;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import shz.Coder;
import shz.FileHelp;
import shz.PropHelp;
import shz.ToList;
import shz.Validator;
import shz.encrypt.EncryptManager;
import shz.encrypt.EncryptParam;
import shz.encrypt.RsaEncipher;
import shz.encrypt.SimpleKeyPair;
import shz.msg.ClientFailure;

public abstract class AbstractEncryptManager
implements EncryptManager {
    protected final RsaEncipher rsaEncipher = RsaEncipher.getInstance();
    protected final byte[] privateKey;
    protected final byte[] publicKey;

    protected AbstractEncryptManager() {
        SimpleKeyPair keyPair = this.getKeyPair();
        if (keyPair == null || Validator.isBlank(keyPair.privateKey) || Validator.isBlank(keyPair.publicKey)) {
            this.rsaEncipher.initKeyPair();
            this.privateKey = this.rsaEncipher.getKeyPair().getPrivate().getEncoded();
            this.publicKey = this.rsaEncipher.getKeyPair().getPublic().getEncoded();
            this.saveKeyPair(new SimpleKeyPair(this.encodeBytes(this.privateKey), this.encodeBytes(this.publicKey)));
        } else {
            this.privateKey = this.decodeString(keyPair.privateKey);
            this.publicKey = this.decodeString(keyPair.publicKey);
        }
    }

    protected SimpleKeyPair getKeyPair() {
        try {
            String rsaKeyDir = System.getProperty("user.dir");
            String privateKey = FileHelp.readString(new File(rsaKeyDir, "privateKey")).replaceAll("\\s+", "");
            if (Validator.isBlank(privateKey)) {
                return null;
            }
            String publicKey = FileHelp.readString(new File(rsaKeyDir, "publicKey")).replaceAll("\\s+", "");
            if (Validator.isBlank(publicKey)) {
                return null;
            }
            return new SimpleKeyPair(privateKey, publicKey);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void saveKeyPair(SimpleKeyPair keyPair) {
        if (keyPair == null || Validator.isBlank(keyPair.getPrivateKey()) || Validator.isBlank(keyPair.getPublicKey())) {
            return;
        }
        String rsaKeyDir = System.getProperty("user.dir");
        FileHelp.writeChars(new File(rsaKeyDir, "privateKey"), keyPair.getPrivateKey().toCharArray());
        FileHelp.writeChars(new File(rsaKeyDir, "publicKey"), keyPair.getPublicKey().toCharArray());
    }

    public final void resetKeyPair() {
        this.rsaEncipher.initKeyPair();
        System.arraycopy(this.rsaEncipher.getKeyPair().getPrivate().getEncoded(), 0, this.privateKey, 0, this.privateKey.length);
        System.arraycopy(this.rsaEncipher.getKeyPair().getPublic().getEncoded(), 0, this.publicKey, 0, this.publicKey.length);
        this.saveKeyPair(new SimpleKeyPair(this.encodeBytes(this.privateKey), this.encodeBytes(this.publicKey)));
    }

    public final String getPublicKey() {
        return this.encodeBytes(this.publicKey);
    }

    public final String encryptKey(String key, String publicKey) {
        return this.encodeBytes(this.rsaEncipher.encryptByPublicKey(this.stringToBytes(key), this.decodeString(publicKey)));
    }

    protected final String decryptKey(String key) {
        return this.bytesToString(this.rsaEncipher.decryptByPrivateKey(this.decodeString(key), this.privateKey));
    }

    public final String sign(String signature) {
        return this.encodeBytes(this.rsaEncipher.encryptByPrivateKey(this.stringToBytes(signature), this.privateKey));
    }

    @Override
    public String sign(EncryptParam encryptParam, Object data) {
        Map<String, String> map = PropHelp.fieldValueMap(data);
        Set<String> keys = map.keySet();
        List<String> list = ToList.explicitCollect(keys.stream().filter(k -> !"null".equals(k) && !"sign".equals(k) && !"pl_sign".equals(k)), keys.size());
        list.sort(Collator.getInstance(Locale.CHINA));
        return Coder.md5(this.stringToBytes(String.join((CharSequence)"", ToList.explicitCollect(list.stream().map(map::get), list.size())) + encryptParam.signKey));
    }

    @Override
    public final void checkSign(EncryptParam encryptParam, String signature, Object data) {
        if (Validator.nonBlank(encryptParam.publicKey)) {
            signature = this.bytesToString(this.rsaEncipher.decryptByPublicKey(this.decodeString(signature), this.decodeString(encryptParam.publicKey)));
        }
        ClientFailure.INVALID_SIGNATURE.requireNon(!Objects.equals(this.sign(encryptParam, data), signature));
    }
}

