/*
 * Decompiled with CFR 0.152.
 */
package shz.encrypt;

import java.io.Serializable;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import shz.PRException;
import shz.encrypt.EncryptParam;
import shz.msg.ServerFailureMsg;

public final class Encipher
implements Serializable {
    private static final long serialVersionUID = 2572501969031261484L;
    private EncryptParam encryptParam;
    private Key key;
    private Cipher cipher;

    public Encipher(EncryptParam encryptParam) {
        this.initKey(encryptParam);
    }

    public void initKey(EncryptParam encryptParam) {
        ServerFailureMsg.requireNon(encryptParam.size != 128 && encryptParam.size != 192 && encryptParam.size != 256, "\u4e0d\u652f\u6301\u7684\u5bc6\u94a5\u5927\u5c0f");
        String[] split = encryptParam.cipherModel.split("/");
        ServerFailureMsg.requireNon(split.length != 3, "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u6a21\u5f0f");
        this.encryptParam = encryptParam;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(split[0]);
            SecureRandom random = SecureRandom.getInstance(encryptParam.rngAlgorithm, encryptParam.provider);
            random.setSeed(encryptParam.seed.getBytes());
            keyGen.init(encryptParam.size, random);
            this.key = new SecretKeySpec(keyGen.generateKey().getEncoded(), split[0]);
            this.cipher = Cipher.getInstance(encryptParam.cipherModel);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] encrypt(byte[] plaintext) {
        try {
            if (this.encryptParam.iv == null || this.encryptParam.iv.length == 0) {
                this.cipher.init(1, this.key);
            } else {
                this.cipher.init(1, this.key, new IvParameterSpec(this.encryptParam.iv));
            }
            return this.cipher.doFinal(plaintext);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] decrypt(byte[] ciphertext) {
        try {
            if (this.encryptParam.iv == null || this.encryptParam.iv.length == 0) {
                this.cipher.init(2, this.key);
            } else {
                this.cipher.init(2, this.key, new IvParameterSpec(this.encryptParam.iv));
            }
            return this.cipher.doFinal(ciphertext);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }
}

