/*
 * Decompiled with CFR 0.152.
 */
package shz.encrypt;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import shz.Serializer;
import shz.encrypt.Encipher;
import shz.encrypt.EncryptParam;

public interface EncryptManager {
    public EncryptParam getEncryptParam(String var1);

    public String sign(EncryptParam var1, Object var2);

    default public String sign(String id, Object data) {
        return this.sign(this.getEncryptParam(id), data);
    }

    public void checkSign(EncryptParam var1, String var2, Object var3);

    default public void checkSign(String id, String signature, Object data) {
        this.checkSign(this.getEncryptParam(id), signature, data);
    }

    default public Encipher getEncipher(EncryptParam encryptParam) {
        return new Encipher(encryptParam);
    }

    default public byte[] serialize(Object obj) {
        return Serializer.serialize(obj);
    }

    default public <T> T deserialize(byte[] bytes) {
        return Serializer.deserialize(bytes);
    }

    default public String encodeBytes(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    default public byte[] decodeString(String str) {
        return Base64.getDecoder().decode(str);
    }

    default public byte[] stringToBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    default public String bytesToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    default public String encrypt(EncryptParam encryptParam, Object data) {
        return this.encodeBytes(this.getEncipher(encryptParam).encrypt(this.serialize(data)));
    }

    default public String encrypt(String id, Object data) {
        return this.encrypt(this.getEncryptParam(id), data);
    }

    default public <T> T decrypt(EncryptParam encryptParam, String signature, String ciphertext) {
        Encipher encipher = this.getEncipher(encryptParam);
        T data = this.deserialize(encipher.decrypt(this.decodeString(ciphertext)));
        this.checkSign(encryptParam, signature, data);
        return data;
    }

    default public <T> T decrypt(String id, String signature, String ciphertext) {
        return this.decrypt(this.getEncryptParam(id), signature, ciphertext);
    }
}

