/*
 * Decompiled with CFR 0.152.
 */
package shz.encrypt;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import shz.PRException;
import shz.msg.ServerFailure;

public final class RsaEncipher
implements Serializable {
    private static final String KEY_ALGORITHM = "RSA";
    private static final long serialVersionUID = 2157700228208207661L;
    private int keySize;
    private KeyPair keyPair;
    private static volatile RsaEncipher instance;

    private RsaEncipher(int keySize) {
        ServerFailure.IllegalStateException.requireNon(instance != null);
        this.initKeyPair(keySize);
    }

    public void initKeyPair(int keySize) {
        try {
            this.keySize = keySize;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGenerator.initialize(this.keySize);
            this.keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public void initKeyPair() {
        this.initKeyPair(this.keySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RsaEncipher getInstance(int keySize) {
        if (instance != null) return instance;
        Class<RsaEncipher> clazz = RsaEncipher.class;
        synchronized (RsaEncipher.class) {
            if (instance != null) return instance;
            instance = new RsaEncipher(keySize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static RsaEncipher getInstance() {
        return RsaEncipher.getInstance(1024);
    }

    private Object readResolve() {
        return instance;
    }

    public byte[] encryptByPublicKey(byte[] plaintext, byte[] publicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey key = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, key);
            return cipher.doFinal(plaintext);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] decryptByPrivateKey(byte[] ciphertext, byte[] privateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey key = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, key);
            return cipher.doFinal(ciphertext);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] encryptByPrivateKey(byte[] plaintext, byte[] privateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey key = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, key);
            return cipher.doFinal(plaintext);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] decryptByPublicKey(byte[] ciphertext, byte[] publicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey key = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, key);
            return cipher.doFinal(ciphertext);
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }
}

