/*
 * Decompiled with CFR 0.152.
 */
package shz.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import shz.AccessibleHelp;
import shz.PRException;
import shz.ToList;
import shz.ToSet;
import shz.Validator;
import shz.msg.ClientFailureMsg;

public interface IEnum<C, V> {
    public String name();

    public int ordinal();

    public C getCode();

    public V getValue();

    default public String enumType() {
        return this.getClass().getSimpleName();
    }

    public static <C, E extends Enum<E>, T extends IEnum<C, ?>> T getByCode(boolean auto, Class<T> cls, C code) {
        if (code == null) {
            return null;
        }
        List es = AccessibleHelp.enumSet(cls);
        if (es.isEmpty()) {
            return null;
        }
        String s = code.toString();
        IEnum t = es.stream().map(e -> (IEnum)((Object)e)).filter(e -> s.equals(e.getCode().toString())).findFirst().orElse(null);
        if (auto && t == null) {
            throw PRException.of(ClientFailureMsg.fail("%s\u7f16\u7801:%s\u4e0d\u5b58\u5728", ((IEnum)es.get(0)).enumType(), s));
        }
        return (T)t;
    }

    public static <C, T extends IEnum<C, ?>> T getByCode(Class<T> cls, C code) {
        return IEnum.getByCode(true, cls, code);
    }

    public static <C, E extends Enum<E>, T extends IEnum<C, ?>> List<T> getByCodes(Class<T> cls, C ... codes) {
        if (Validator.isEmpty(codes)) {
            return Collections.emptyList();
        }
        Set<String> set = ToSet.explicitCollect(Arrays.stream(codes).filter(Objects::nonNull).map(Object::toString), codes.length);
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        List es = AccessibleHelp.enumSet(cls);
        if (es.isEmpty()) {
            return Collections.emptyList();
        }
        return ToList.explicitCollect(es.stream().map(e -> (IEnum)((Object)e)).filter(e -> set.contains(e.getCode().toString())), Math.min(set.size(), es.size()));
    }
}

