/*
 * Decompiled with CFR 0.152.
 */
package shz.handler.translate;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import shz.AccessibleHelp;
import shz.ToList;
import shz.ToMap;
import shz.Validator;
import shz.enums.IEnum;
import shz.enums.SimpleEnum;
import shz.enums.TypeEnum;
import shz.model.CodeValue;

public interface TranslateEnum
extends SimpleEnum {
    public Class<? extends IEnum<?, String>> type();

    default public String enumName() {
        return null;
    }

    default public Map<String, String> codeValueMap() {
        List ts = AccessibleHelp.enumSet(this.type());
        if (ts.isEmpty()) {
            return Collections.emptyMap();
        }
        List<IEnum> enums = ToList.explicitCollect(ts.stream().map(e -> (IEnum)e), ts.size());
        String enumName = this.enumName();
        if (enumName == null) {
            return ToMap.explicitCollect(enums.stream(), e -> e.getCode().toString(), IEnum::getValue, enums.size(), 0, true);
        }
        IEnum iEnum = enums.stream().filter(e -> enumName.equals(e.name())).findFirst().orElse(null);
        if (iEnum instanceof TypeEnum) {
            List<CodeValue> values = ((TypeEnum)iEnum).codeValues();
            if (Validator.isEmpty(values)) {
                return Collections.emptyMap();
            }
            return ToMap.explicitCollect(values.stream(), CodeValue::getCode, CodeValue::getValue, values.size(), 0, true);
        }
        return Collections.emptyMap();
    }
}

