/*
 * Decompiled with CFR 0.152.
 */
package shz.handler.verify;

import shz.Validator;
import shz.handler.verify.GenerateVerifyHandler;
import shz.handler.verify.VerifyParam;
import shz.msg.ClientFailure;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractGenerateVerifyHandler<K, V, T extends VerifyParam<K, V>>
implements GenerateVerifyHandler<T> {
    @Override
    public final void generate(T param) {
        this.generate0(param);
        this.put(param.key(), param.value(), param.expireTimestamp());
    }

    @Override
    public final void verify(T param) {
        Object key = param.key();
        V value = this.get(key, param.expireTimestamp());
        ClientFailure.INVALID_VERIFY_CODE.requireNon(Validator.isBlank(value));
        if (!param.equals(value, param.value())) {
            ClientFailure.ERROR_VERIFY_CODE.requireNon(!this.delete(param));
            this.delete((K)key);
            ClientFailure.INVALID_VERIFY_CODE.requireNon(true);
        }
        this.delete((K)key);
    }

    protected abstract void generate0(T var1);

    protected abstract void put(K var1, V var2, long var3);

    protected abstract V get(K var1, long var2);

    protected abstract void delete(K var1);

    protected boolean delete(T param) {
        return false;
    }
}

