/*
 * Decompiled with CFR 0.152.
 */
package shz.id;

import shz.Help;
import shz.id.IdInfo;
import shz.id.IdProducer;
import shz.msg.ServerFailureMsg;

public class SFIdProducer
implements IdProducer<Long, IdInfo> {
    private final long totalBits;
    protected final IdInfo idInfo;
    private final long datacenterIdResult;
    private final long workerIdResult;
    protected long startTimestamp = 1604764800000L;
    private long lastTimestamp;
    private long sequence;

    public SFIdProducer(IdInfo idInfo) {
        this.totalBits = idInfo.datacenterIdBits + idInfo.workerIdBits + idInfo.timestampBits + idInfo.sequenceBits;
        ServerFailureMsg.requireNon(this.totalBits > 63L || this.totalBits < 52L, "id\u4f4d\u6570\u53d6\u503c\u8303\u56f4:52-63");
        ServerFailureMsg.requireNon(idInfo.datacenterId > (-1L << (int)idInfo.datacenterIdBits ^ 0xFFFFFFFFFFFFFFFFL) || idInfo.datacenterId < 0L, "\u4e2d\u5fc3\u8282\u70b9\u53d6\u503c\u8303\u56f4:0-%d", -1L << (int)idInfo.datacenterIdBits ^ 0xFFFFFFFFFFFFFFFFL);
        ServerFailureMsg.requireNon(idInfo.workerId > (-1L << (int)idInfo.workerIdBits ^ 0xFFFFFFFFFFFFFFFFL) || idInfo.workerId < 0L, "\u5de5\u4f5c\u8282\u70b9\u53d6\u503c\u8303\u56f4:0-%d", -1L << (int)idInfo.workerIdBits ^ 0xFFFFFFFFFFFFFFFFL);
        this.idInfo = idInfo;
        this.datacenterIdResult = this.idInfo.datacenterId << (int)(this.idInfo.sequenceBits + this.idInfo.workerIdBits);
        this.workerIdResult = this.idInfo.workerId << (int)this.idInfo.sequenceBits;
    }

    public final void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public final void setLastTimestamp(long lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    protected void saveLastTimestamp(long lastTimestamp) {
    }

    @Override
    public final synchronized Long next() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(Help.format("\u65f6\u949f\u56de\u62e8:%d\u6beb\u79d2", this.lastTimestamp - timestamp));
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & (-1L << (int)this.idInfo.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.sequence == 0L) {
                while ((timestamp = System.currentTimeMillis()) <= this.lastTimestamp) {
                }
                this.saveLastTimestamp(timestamp);
            }
        } else {
            this.sequence = 0L;
            this.saveLastTimestamp(timestamp);
        }
        this.lastTimestamp = timestamp;
        long timestampVal = timestamp - this.startTimestamp << (int)(this.idInfo.sequenceBits + this.idInfo.workerIdBits + this.idInfo.datacenterIdBits);
        return timestampVal & (-1L << (int)this.totalBits ^ 0xFFFFFFFFFFFFFFFFL) | this.datacenterIdResult | this.workerIdResult | this.sequence;
    }

    @Override
    public final IdInfo analyze(Long id) {
        if (id == null) {
            return null;
        }
        IdInfo idInfo = new IdInfo();
        idInfo.timestamp = (id >>> (int)(this.idInfo.sequenceBits + this.idInfo.workerIdBits + this.idInfo.datacenterIdBits)) + this.startTimestamp;
        idInfo.datacenterId = id >>> (int)(this.idInfo.sequenceBits + this.idInfo.workerIdBits) & (-1L << (int)this.idInfo.datacenterIdBits ^ 0xFFFFFFFFFFFFFFFFL);
        idInfo.workerId = id >>> (int)this.idInfo.sequenceBits & (-1L << (int)this.idInfo.workerIdBits ^ 0xFFFFFFFFFFFFFFFFL);
        idInfo.sequence = id & (-1L << (int)this.idInfo.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL);
        idInfo.datacenterIdBits = this.idInfo.datacenterIdBits;
        idInfo.workerIdBits = this.idInfo.workerIdBits;
        idInfo.timestampBits = this.idInfo.timestampBits;
        idInfo.sequenceBits = this.idInfo.sequenceBits;
        return idInfo;
    }
}

