/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import shz.UnsafeHelp;
import shz.linked.DNode;

public class ConcurrentDDNode
implements DNode {
    public volatile double val;
    protected volatile ConcurrentDDNode next;
    protected volatile ConcurrentDDNode prev;
    private static final long valOffset;
    private static final long nextOffset;
    private static final long prevOffset;

    protected ConcurrentDDNode(double val) {
        this.val = val;
    }

    public static ConcurrentDDNode of(double e) {
        return new ConcurrentDDNode(e);
    }

    public static ConcurrentDDNode of() {
        return ConcurrentDDNode.of(0.0);
    }

    public boolean casVal(double expect, double val) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, valOffset, expect, val);
    }

    public boolean casNext(ConcurrentDDNode expect, ConcurrentDDNode next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    public boolean casPrev(ConcurrentDDNode expect, ConcurrentDDNode prev) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, prevOffset, expect, prev);
    }

    @Override
    public final ConcurrentDDNode next() {
        return this.next;
    }

    @Override
    public final void next(DNode node) {
        this.next = (ConcurrentDDNode)node;
    }

    @Override
    public final ConcurrentDDNode prev() {
        return this.prev;
    }

    @Override
    public final void prev(DNode node) {
        this.prev = (ConcurrentDDNode)node;
    }

    @Override
    public final ConcurrentDDNode addNext(DNode node) {
        ConcurrentDDNode cddNode;
        block1: {
            ConcurrentDDNode next;
            cddNode = (ConcurrentDDNode)node;
            do {
                next = this.next;
                cddNode.prev = this;
                cddNode.next = next;
            } while (!this.casNext(next, cddNode));
            if (next == null) break block1;
            next.prev = cddNode;
        }
        return cddNode;
    }

    @Override
    public final ConcurrentDDNode addPrev(DNode node) {
        ConcurrentDDNode cddNode;
        block1: {
            ConcurrentDDNode prev;
            cddNode = (ConcurrentDDNode)node;
            do {
                cddNode.prev = prev = this.prev;
                cddNode.next = this;
            } while (!this.casPrev(prev, cddNode));
            if (prev == null) break block1;
            prev.next = cddNode;
        }
        return cddNode;
    }

    @Override
    public final void poll() {
        ConcurrentDDNode prev = this.prev;
        ConcurrentDDNode next = this.next;
        if (prev != null) {
            if (prev.casNext(this, next) && next != null) {
                next.prev = prev;
            }
        } else if (next != null) {
            next.casPrev(this, null);
        }
    }

    public final ConcurrentDDNode addNext(double e) {
        return this.addNext(ConcurrentDDNode.of(e));
    }

    public final ConcurrentDDNode addNext(double ... es) {
        ConcurrentDDNode next = this;
        for (double e : es) {
            next = next.addNext(e);
        }
        return next;
    }

    public final ConcurrentDDNode addPrev(double e) {
        return this.addPrev(ConcurrentDDNode.of(e));
    }

    public final ConcurrentDDNode addPrev(double ... es) {
        ConcurrentDDNode prev = this;
        for (double e : es) {
            prev = prev.addPrev(e);
        }
        return prev;
    }

    static {
        try {
            Class<ConcurrentDDNode> k = ConcurrentDDNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
            prevOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("prev"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

