/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import shz.UnsafeHelp;
import shz.linked.SNode;

public class ConcurrentDSNode
implements SNode {
    public volatile double val;
    protected volatile ConcurrentDSNode next;
    private static final long valOffset;
    private static final long nextOffset;

    protected ConcurrentDSNode(double val) {
        this.val = val;
    }

    public static ConcurrentDSNode of(double e) {
        return new ConcurrentDSNode(e);
    }

    public static ConcurrentDSNode of() {
        return ConcurrentDSNode.of(0.0);
    }

    public final boolean casVal(double expect, double val) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, valOffset, expect, val);
    }

    public final boolean casNext(ConcurrentDSNode expect, ConcurrentDSNode next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    @Override
    public final ConcurrentDSNode next() {
        return this.next;
    }

    @Override
    public final void next(SNode node) {
        this.next = (ConcurrentDSNode)node;
    }

    @Override
    public final ConcurrentDSNode addNext(SNode node) {
        ConcurrentDSNode next;
        ConcurrentDSNode cdsNode = (ConcurrentDSNode)node;
        do {
            cdsNode.next = next = this.next;
        } while (!this.casNext(next, cdsNode));
        return cdsNode;
    }

    @Override
    public final ConcurrentDSNode addPrev(SNode node) {
        double val;
        ConcurrentDSNode cdsNode = this.addNext(node);
        while (!this.casVal(val = this.val, cdsNode.val)) {
        }
        cdsNode.val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (this.next == null) {
            this.val = 0.0;
        } else {
            ConcurrentDSNode next = this.next;
            if (this.casNext(next, next.next)) {
                this.val = next.val;
            }
        }
    }

    public final ConcurrentDSNode addNext(double e) {
        return this.addNext(ConcurrentDSNode.of(e));
    }

    public final ConcurrentDSNode addNext(double ... es) {
        ConcurrentDSNode next = this;
        for (double e : es) {
            next = next.addNext(e);
        }
        return next;
    }

    public final ConcurrentDSNode addPrev(double e) {
        return this.addPrev(ConcurrentDSNode.of(e));
    }

    public final ConcurrentDSNode addPrev(double ... es) {
        for (double e : es) {
            this.addPrev(e);
        }
        return this;
    }

    static {
        try {
            Class<ConcurrentDSNode> k = ConcurrentDSNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

