/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import shz.UnsafeHelp;
import shz.linked.DNode;

public class ConcurrentJDNode
implements DNode {
    public volatile long val;
    protected volatile ConcurrentJDNode next;
    protected volatile ConcurrentJDNode prev;
    private static final long valOffset;
    private static final long nextOffset;
    private static final long prevOffset;

    protected ConcurrentJDNode(long val) {
        this.val = val;
    }

    public static ConcurrentJDNode of(long e) {
        return new ConcurrentJDNode(e);
    }

    public static ConcurrentJDNode of() {
        return ConcurrentJDNode.of(0L);
    }

    public boolean casVal(long expect, long val) {
        return UnsafeHelp.getUnsafe().compareAndSwapLong(this, valOffset, expect, val);
    }

    public boolean casNext(ConcurrentJDNode expect, ConcurrentJDNode next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    public boolean casPrev(ConcurrentJDNode expect, ConcurrentJDNode prev) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, prevOffset, expect, prev);
    }

    @Override
    public final ConcurrentJDNode next() {
        return this.next;
    }

    @Override
    public final void next(DNode node) {
        this.next = (ConcurrentJDNode)node;
    }

    @Override
    public final ConcurrentJDNode prev() {
        return this.prev;
    }

    @Override
    public final void prev(DNode node) {
        this.prev = (ConcurrentJDNode)node;
    }

    @Override
    public final ConcurrentJDNode addNext(DNode node) {
        ConcurrentJDNode cjdNode;
        block1: {
            ConcurrentJDNode next;
            cjdNode = (ConcurrentJDNode)node;
            do {
                next = this.next;
                cjdNode.prev = this;
                cjdNode.next = next;
            } while (!this.casNext(next, cjdNode));
            if (next == null) break block1;
            next.prev = cjdNode;
        }
        return cjdNode;
    }

    @Override
    public final ConcurrentJDNode addPrev(DNode node) {
        ConcurrentJDNode cjdNode;
        block1: {
            ConcurrentJDNode prev;
            cjdNode = (ConcurrentJDNode)node;
            do {
                cjdNode.prev = prev = this.prev;
                cjdNode.next = this;
            } while (!this.casPrev(prev, cjdNode));
            if (prev == null) break block1;
            prev.next = cjdNode;
        }
        return cjdNode;
    }

    @Override
    public final void poll() {
        ConcurrentJDNode prev = this.prev;
        ConcurrentJDNode next = this.next;
        if (prev != null) {
            if (prev.casNext(this, next) && next != null) {
                next.prev = prev;
            }
        } else if (next != null) {
            next.casPrev(this, null);
        }
    }

    public final ConcurrentJDNode addNext(long e) {
        return this.addNext(ConcurrentJDNode.of(e));
    }

    public final ConcurrentJDNode addNext(long ... es) {
        ConcurrentJDNode next = this;
        for (long e : es) {
            next = next.addNext(e);
        }
        return next;
    }

    public final ConcurrentJDNode addPrev(long e) {
        return this.addPrev(ConcurrentJDNode.of(e));
    }

    public final ConcurrentJDNode addPrev(long ... es) {
        ConcurrentJDNode prev = this;
        for (long e : es) {
            prev = prev.addPrev(e);
        }
        return prev;
    }

    static {
        try {
            Class<ConcurrentJDNode> k = ConcurrentJDNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
            prevOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("prev"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

