/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import shz.UnsafeHelp;
import shz.linked.SNode;

public class ConcurrentJSNode
implements SNode {
    public volatile long val;
    protected volatile ConcurrentJSNode next;
    private static final long valOffset;
    private static final long nextOffset;

    protected ConcurrentJSNode(long val) {
        this.val = val;
    }

    public static ConcurrentJSNode of(long e) {
        return new ConcurrentJSNode(e);
    }

    public static ConcurrentJSNode of() {
        return ConcurrentJSNode.of(0L);
    }

    public final boolean casVal(long expect, long val) {
        return UnsafeHelp.getUnsafe().compareAndSwapLong(this, valOffset, expect, val);
    }

    public final boolean casNext(ConcurrentJSNode expect, ConcurrentJSNode next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    @Override
    public final ConcurrentJSNode next() {
        return this.next;
    }

    @Override
    public final void next(SNode node) {
        this.next = (ConcurrentJSNode)node;
    }

    @Override
    public final ConcurrentJSNode addNext(SNode node) {
        ConcurrentJSNode next;
        ConcurrentJSNode cjsNode = (ConcurrentJSNode)node;
        do {
            cjsNode.next = next = this.next;
        } while (!this.casNext(next, cjsNode));
        return cjsNode;
    }

    @Override
    public final ConcurrentJSNode addPrev(SNode node) {
        long val;
        ConcurrentJSNode cjsNode = this.addNext(node);
        while (!this.casVal(val = this.val, cjsNode.val)) {
        }
        cjsNode.val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (this.next == null) {
            this.val = 0L;
        } else {
            ConcurrentJSNode next = this.next;
            if (this.casNext(next, next.next)) {
                this.val = next.val;
            }
        }
    }

    public final ConcurrentJSNode addNext(long e) {
        return this.addNext(ConcurrentJSNode.of(e));
    }

    public final ConcurrentJSNode addNext(long ... es) {
        ConcurrentJSNode next = this;
        for (long e : es) {
            next = next.addNext(e);
        }
        return next;
    }

    public final ConcurrentJSNode addPrev(long e) {
        return this.addPrev(ConcurrentJSNode.of(e));
    }

    public final ConcurrentJSNode addPrev(long ... es) {
        for (long e : es) {
            this.addPrev(e);
        }
        return this;
    }

    static {
        try {
            Class<ConcurrentJSNode> k = ConcurrentJSNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

