/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import shz.UnsafeHelp;
import shz.linked.DNode;

public class ConcurrentLDNode<E>
implements DNode {
    public volatile E val;
    protected volatile ConcurrentLDNode<E> next;
    protected volatile ConcurrentLDNode<E> prev;
    private static final long valOffset;
    private static final long nextOffset;
    private static final long prevOffset;

    protected ConcurrentLDNode(E val) {
        this.val = val;
    }

    public static <E> ConcurrentLDNode<E> of(E e) {
        return new ConcurrentLDNode<E>(e);
    }

    public static <E> ConcurrentLDNode<E> of() {
        return ConcurrentLDNode.of(null);
    }

    public boolean casVal(E expect, E val) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, valOffset, expect, val);
    }

    public boolean casNext(ConcurrentLDNode<E> expect, ConcurrentLDNode<E> next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    public boolean casPrev(ConcurrentLDNode<E> expect, ConcurrentLDNode<E> prev) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, prevOffset, expect, prev);
    }

    @Override
    public final ConcurrentLDNode<E> next() {
        return this.next;
    }

    @Override
    public final void next(DNode node) {
        this.next = (ConcurrentLDNode)node;
    }

    @Override
    public final ConcurrentLDNode<E> prev() {
        return this.prev;
    }

    @Override
    public final void prev(DNode node) {
        this.prev = (ConcurrentLDNode)node;
    }

    @Override
    public final ConcurrentLDNode<E> addNext(DNode node) {
        ConcurrentLDNode cldNode;
        block1: {
            ConcurrentLDNode<E> next;
            cldNode = (ConcurrentLDNode)node;
            do {
                next = this.next;
                cldNode.prev = this;
                cldNode.next = next;
            } while (!this.casNext(next, cldNode));
            if (next == null) break block1;
            next.prev = cldNode;
        }
        return cldNode;
    }

    @Override
    public final ConcurrentLDNode<E> addPrev(DNode node) {
        ConcurrentLDNode cldNode;
        block1: {
            ConcurrentLDNode<E> prev;
            cldNode = (ConcurrentLDNode)node;
            do {
                cldNode.prev = prev = this.prev;
                cldNode.next = this;
            } while (!this.casPrev(prev, cldNode));
            if (prev == null) break block1;
            prev.next = cldNode;
        }
        return cldNode;
    }

    @Override
    public final void poll() {
        ConcurrentLDNode<E> prev = this.prev;
        ConcurrentLDNode<E> next = this.next;
        if (prev != null) {
            if (prev.casNext(this, next) && next != null) {
                next.prev = prev;
            }
        } else if (next != null) {
            next.casPrev(this, null);
        }
    }

    public final ConcurrentLDNode<E> addNext(E e) {
        return this.addNext(ConcurrentLDNode.of(e));
    }

    @SafeVarargs
    public final ConcurrentLDNode<E> addNext(E ... es) {
        ConcurrentLDNode<E> next = this;
        for (E e : es) {
            next = next.addNext(e);
        }
        return next;
    }

    public final ConcurrentLDNode<E> addPrev(E e) {
        return this.addPrev(ConcurrentLDNode.of(e));
    }

    @SafeVarargs
    public final ConcurrentLDNode<E> addPrev(E ... es) {
        ConcurrentLDNode<E> prev = this;
        for (E e : es) {
            prev = prev.addPrev(e);
        }
        return prev;
    }

    static {
        try {
            Class<ConcurrentLDNode> k = ConcurrentLDNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
            prevOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("prev"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

