/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import shz.UnsafeHelp;
import shz.linked.SNode;

public class ConcurrentLSNode<E>
implements SNode {
    public volatile E val;
    protected volatile ConcurrentLSNode<E> next;
    private static final long valOffset;
    private static final long nextOffset;

    protected ConcurrentLSNode(E val) {
        this.val = val;
    }

    public static <E> ConcurrentLSNode<E> of(E e) {
        return new ConcurrentLSNode<E>(e);
    }

    public static <E> ConcurrentLSNode<E> of() {
        return ConcurrentLSNode.of(null);
    }

    public final boolean casVal(E expect, E val) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, valOffset, expect, val);
    }

    public final boolean casNext(ConcurrentLSNode<E> expect, ConcurrentLSNode<E> next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    @Override
    public final ConcurrentLSNode<E> next() {
        return this.next;
    }

    @Override
    public final void next(SNode node) {
        this.next = (ConcurrentLSNode)node;
    }

    @Override
    public final ConcurrentLSNode<E> addNext(SNode node) {
        ConcurrentLSNode<E> next;
        ConcurrentLSNode clsNode = (ConcurrentLSNode)node;
        do {
            clsNode.next = next = this.next;
        } while (!this.casNext(next, clsNode));
        return clsNode;
    }

    @Override
    public final ConcurrentLSNode<E> addPrev(SNode node) {
        E val;
        SNode clsNode = this.addNext(node);
        while (!this.casVal(val = this.val, ((ConcurrentLSNode)clsNode).val)) {
        }
        ((ConcurrentLSNode)clsNode).val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (this.next == null) {
            this.val = null;
        } else {
            ConcurrentLSNode<E> next = this.next;
            if (this.casNext(next, next.next)) {
                this.val = next.val;
            }
        }
    }

    public final ConcurrentLSNode<E> addNext(E e) {
        return this.addNext(ConcurrentLSNode.of(e));
    }

    @SafeVarargs
    public final ConcurrentLSNode<E> addNext(E ... es) {
        ConcurrentLSNode<E> next = this;
        for (E e : es) {
            next = next.addNext(e);
        }
        return next;
    }

    public final ConcurrentLSNode<E> addPrev(E e) {
        return this.addPrev(ConcurrentLSNode.of(e));
    }

    @SafeVarargs
    public final ConcurrentLSNode<E> addPrev(E ... es) {
        for (E e : es) {
            this.addPrev(e);
        }
        return this;
    }

    static {
        try {
            Class<ConcurrentLSNode> k = ConcurrentLSNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

