/*
 * Decompiled with CFR 0.152.
 */
package shz.linked;

import java.util.function.Function;
import java.util.function.Predicate;

public interface DNode {
    public DNode next();

    public void next(DNode var1);

    public DNode prev();

    public void prev(DNode var1);

    default public DNode addNext(DNode node) {
        node.prev(this);
        node.next(this.next());
        this.next().prev(node);
        this.next(node);
        return node;
    }

    default public DNode addPrev(DNode node) {
        node.prev(this.prev());
        node.next(this);
        this.prev().next(node);
        this.prev(node);
        return node;
    }

    default public void poll() {
        if (this.prev() != null) {
            this.prev().next(this.next());
        }
        if (this.next() != null) {
            this.next().prev(this.prev());
        }
        this.prev(null);
        this.next(null);
    }

    default public DNode findNext(Predicate<DNode> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        for (DNode next = this; next != null; next = next.next()) {
            if (!predicate.test(next)) continue;
            return next;
        }
        return null;
    }

    default public DNode findPrev(Predicate<DNode> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        for (DNode prev = this; prev != null; prev = prev.prev()) {
            if (!predicate.test(prev)) continue;
            return prev;
        }
        return null;
    }

    default public void forEachNext(Function<DNode, Boolean> func) {
        Boolean stop;
        if (func == null) {
            throw new NullPointerException();
        }
        for (DNode next = this; !(next == null || (stop = func.apply(next)) != null && stop.booleanValue()); next = next.next()) {
        }
    }

    default public void forEachPrev(Function<DNode, Boolean> func) {
        Boolean stop;
        if (func == null) {
            throw new NullPointerException();
        }
        for (DNode prev = this; !(prev == null || (stop = func.apply(prev)) != null && stop.booleanValue()); prev = prev.prev()) {
        }
    }
}

