/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.util.Arrays;
import java.util.BitSet;
import shz.Validator;
import shz.msg.ServerFailureMsg;

public class BloomFilter {
    private final int k;
    private final BitSet bitSet;
    private final int[] seeds;
    private final int MP;
    private static final int[] SEEDS = new int[]{31, 33, 37, 39, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97};

    protected BloomFilter(double p, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (p <= 0.0) {
            p = 1.0 / (double)n;
        }
        this.k = (int)Math.ceil(Math.abs((double)n * Math.log(p) / Math.pow(Math.log(2.0), 2.0)) / (double)n * Math.log(2.0));
        long bitSize = (long)this.k * (long)n;
        ServerFailureMsg.requireNon(bitSize > Integer.MAX_VALUE, "\u65e0\u6cd5\u6784\u5efa\u7b26\u5408\u6307\u5b9a\u5931\u8bef\u7387%f\u53ca\u5143\u7d20\u4e2a\u6570%d\u7684\u5e03\u9686\u8fc7\u6ee4\u5668", p, n);
        this.bitSet = new BitSet((int)bitSize);
        this.seeds = this.k <= SEEDS.length ? SEEDS : this.getSeeds(this.k);
        this.MP = this.getMP((int)bitSize - 1);
    }

    public static BloomFilter of(double p, int n) {
        return new BloomFilter(p, n);
    }

    public static BloomFilter of(int n) {
        return new BloomFilter(0.0, n);
    }

    private int[] getSeeds(int n) {
        int[] seeds = new int[n];
        System.arraycopy(SEEDS, 0, seeds, 0, SEEDS.length);
        for (int i = SEEDS.length; i < n; ++i) {
            int p = seeds[i - 1] + 2;
            while (this.nonPrime(p)) {
                p += 2;
            }
            seeds[i] = p;
        }
        return seeds;
    }

    private boolean nonPrime(int x) {
        if (x == 2) {
            return false;
        }
        if (x < 2 || (x & 1) == 0) {
            return true;
        }
        double sqrt = Math.sqrt(x);
        int i = 3;
        while ((double)i <= sqrt) {
            if (x % i == 0) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private int getMP(int mp) {
        while (this.nonPrime(mp)) {
            --mp;
        }
        return mp;
    }

    public final void add(String ... keys) {
        Arrays.stream(keys).forEach(key -> {
            if (Validator.isBlank(key)) {
                this.bitSet.set(0);
            } else {
                char[] chars = key.toCharArray();
                for (int i = 0; i < this.k; ++i) {
                    int h = 0;
                    for (char c : chars) {
                        h = (this.seeds[i] * h + c) % this.MP;
                    }
                    this.bitSet.set(h);
                }
            }
        });
    }

    public final boolean exists(String key) {
        if (Validator.isBlank(key)) {
            return this.bitSet.get(0);
        }
        char[] chars = key.toCharArray();
        for (int i = 0; i < this.k; ++i) {
            int h = 0;
            for (char c : chars) {
                h = (this.seeds[i] * h + c) % this.MP;
            }
            if (this.bitSet.get(h)) continue;
            return false;
        }
        return true;
    }
}

