/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import shz.msg.ServerFailureMsg;

public class Polygon {
    private final double[] xs;
    private final double[] ys;
    private final int n;
    private GeneralPath path;

    public Polygon(double[] xs, double[] ys) {
        this.n = xs.length;
        ServerFailureMsg.requireNon(this.n != ys.length, "\u591a\u8fb9\u5f62\u70b9\u4f4d\u6570\u4e0d\u7b49x:%d,y:%d", xs.length, ys.length);
        ServerFailureMsg.requireNon(this.n < 3, "\u591a\u8fb9\u5f62\u70b9\u4f4d\u6570\u5c0f\u4e8e3");
        this.xs = xs;
        this.ys = ys;
    }

    public final double degreeSum() {
        double degreeSum1 = 0.0;
        double degreeSum2 = 0.0;
        int count1 = 0;
        int count2 = 0;
        int i = 0;
        int max = this.n - 1;
        double x1 = this.xs[max] * (Math.PI / 180);
        double y1 = this.ys[max] * (Math.PI / 180);
        double x2 = this.xs[i] * (Math.PI / 180);
        double y2 = this.ys[i] * (Math.PI / 180);
        double x3 = this.xs[i + 1] * (Math.PI / 180);
        double y3 = this.ys[i + 1] * (Math.PI / 180);
        double a1 = Math.cos(y1) * Math.cos(x1);
        double b1 = Math.cos(y1) * Math.sin(x1);
        double c1 = Math.sin(y1);
        double a2 = Math.cos(y2) * Math.cos(x2);
        double b2 = Math.cos(y2) * Math.sin(x2);
        double c2 = Math.sin(y2);
        double a3 = Math.cos(y3) * Math.cos(x3);
        double b3 = Math.cos(y3) * Math.sin(x3);
        double c3 = Math.sin(y3);
        double v = a2 * a2 + b2 * b2 + c2 * c2;
        double coe1 = v / (a2 * a1 + b2 * b1 + c2 * c1);
        double at1 = coe1 * a1 - a2;
        double bt1 = coe1 * b1 - b2;
        double ct1 = coe1 * c1 - c2;
        double coe3 = v / (a2 * a3 + b2 * b3 + c2 * c3);
        double at3 = coe3 * a3 - a2;
        double bt3 = coe3 * b3 - b2;
        double ct3 = coe3 * c3 - c2;
        double anl = bt3 * ct1 - ct3 * bt1;
        double bnl = ct3 * at1 - at3 * ct1;
        double cnl = at3 * bt1 - bt3 * at1;
        double degree = Math.acos((at3 * at1 + bt3 * bt1 + ct3 * ct1) / (Math.sqrt(at3 * at3 + bt3 * bt3 + ct3 * ct3) * Math.sqrt(at1 * at1 + bt1 * bt1 + ct1 * ct1)));
        double d = a2 != 0.0 ? anl / a2 : (b2 != 0.0 ? bnl / b2 : cnl / c2);
        if (d > 0.0) {
            degreeSum1 += degree;
            ++count1;
        } else {
            degreeSum2 += degree;
            ++count2;
        }
        ++i;
        while (i < max) {
            x1 = this.xs[i - 1] * (Math.PI / 180);
            y1 = this.ys[i - 1] * (Math.PI / 180);
            x2 = this.xs[i] * (Math.PI / 180);
            y2 = this.ys[i] * (Math.PI / 180);
            x3 = this.xs[i + 1] * (Math.PI / 180);
            y3 = this.ys[i + 1] * (Math.PI / 180);
            a1 = Math.cos(y1) * Math.cos(x1);
            b1 = Math.cos(y1) * Math.sin(x1);
            c1 = Math.sin(y1);
            a2 = Math.cos(y2) * Math.cos(x2);
            b2 = Math.cos(y2) * Math.sin(x2);
            c2 = Math.sin(y2);
            a3 = Math.cos(y3) * Math.cos(x3);
            b3 = Math.cos(y3) * Math.sin(x3);
            c3 = Math.sin(y3);
            v = a2 * a2 + b2 * b2 + c2 * c2;
            coe1 = v / (a2 * a1 + b2 * b1 + c2 * c1);
            at1 = coe1 * a1 - a2;
            bt1 = coe1 * b1 - b2;
            ct1 = coe1 * c1 - c2;
            coe3 = v / (a2 * a3 + b2 * b3 + c2 * c3);
            at3 = coe3 * a3 - a2;
            bt3 = coe3 * b3 - b2;
            ct3 = coe3 * c3 - c2;
            anl = bt3 * ct1 - ct3 * bt1;
            bnl = ct3 * at1 - at3 * ct1;
            cnl = at3 * bt1 - bt3 * at1;
            degree = Math.acos((at3 * at1 + bt3 * bt1 + ct3 * ct1) / (Math.sqrt(at3 * at3 + bt3 * bt3 + ct3 * ct3) * Math.sqrt(at1 * at1 + bt1 * bt1 + ct1 * ct1)));
            double d2 = a2 != 0.0 ? anl / a2 : (b2 != 0.0 ? bnl / b2 : cnl / c2);
            if (d2 > 0.0) {
                degreeSum1 += degree;
                ++count1;
            } else {
                degreeSum2 += degree;
                ++count2;
            }
            ++i;
        }
        x1 = this.xs[i - 1] * (Math.PI / 180);
        y1 = this.ys[i - 1] * (Math.PI / 180);
        x2 = this.xs[i] * (Math.PI / 180);
        y2 = this.ys[i] * (Math.PI / 180);
        x3 = this.xs[0] * (Math.PI / 180);
        y3 = this.ys[0] * (Math.PI / 180);
        a1 = Math.cos(y1) * Math.cos(x1);
        b1 = Math.cos(y1) * Math.sin(x1);
        c1 = Math.sin(y1);
        a2 = Math.cos(y2) * Math.cos(x2);
        b2 = Math.cos(y2) * Math.sin(x2);
        c2 = Math.sin(y2);
        a3 = Math.cos(y3) * Math.cos(x3);
        b3 = Math.cos(y3) * Math.sin(x3);
        c3 = Math.sin(y3);
        v = a2 * a2 + b2 * b2 + c2 * c2;
        coe1 = v / (a2 * a1 + b2 * b1 + c2 * c1);
        at1 = coe1 * a1 - a2;
        bt1 = coe1 * b1 - b2;
        ct1 = coe1 * c1 - c2;
        coe3 = v / (a2 * a3 + b2 * b3 + c2 * c3);
        at3 = coe3 * a3 - a2;
        bt3 = coe3 * b3 - b2;
        ct3 = coe3 * c3 - c2;
        anl = bt3 * ct1 - ct3 * bt1;
        bnl = ct3 * at1 - at3 * ct1;
        cnl = at3 * bt1 - bt3 * at1;
        degree = Math.acos((at3 * at1 + bt3 * bt1 + ct3 * ct1) / (Math.sqrt(at3 * at3 + bt3 * bt3 + ct3 * ct3) * Math.sqrt(at1 * at1 + bt1 * bt1 + ct1 * ct1)));
        double d3 = a2 != 0.0 ? anl / a2 : (b2 != 0.0 ? bnl / b2 : cnl / c2);
        if (d3 > 0.0) {
            degreeSum1 += degree;
            ++count1;
        } else {
            degreeSum2 += degree;
            ++count2;
        }
        double tempSum1 = degreeSum1 + (Math.PI * 2 * (double)count2 - degreeSum2);
        double tempSum2 = Math.PI * 2 * (double)count1 - degreeSum1 + degreeSum2;
        if (degreeSum1 > degreeSum2) {
            return tempSum1 < (double)(this.xs.length - 2) * Math.PI + 1.0 ? tempSum1 : tempSum2;
        }
        return tempSum2 < (double)(this.xs.length - 2) * Math.PI + 1.0 ? tempSum2 : tempSum1;
    }

    public final GeneralPath path() {
        if (this.path != null) {
            return this.path;
        }
        this.path = new GeneralPath(1, this.n);
        this.path.moveTo(this.xs[0], this.ys[0]);
        for (int i = 1; i < this.n; ++i) {
            this.path.lineTo(this.xs[i], this.ys[i]);
        }
        this.path.lineTo(this.xs[0], this.ys[0]);
        this.path.closePath();
        return this.path;
    }

    public final Rectangle2D rectangle() {
        return this.path().getBounds2D();
    }

    public final boolean contains(double x, double y) {
        return this.path().contains(x, y);
    }
}

