/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import shz.ToMap;
import shz.msg.ServerFailureMsg;
import shz.queue.PQueue;

public abstract class ShortestPath {
    protected Node node;
    protected Map<ShortestPath, Integer> nodes;
    protected ShortestPath prev;

    protected ShortestPath(String name, int size) {
        this.node = new Node(name);
        this.nodes = (Map)ToMap.get(size).build();
    }

    public final ShortestPath add(ShortestPath optimal, int weight) {
        this.nodes.put(optimal, weight);
        return this;
    }

    public final Result go(ShortestPath des) {
        this.node.weight = 0;
        this.update();
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>((t, u) -> u - t);
        int count = 0;
        treeMap.put(count++, des.node.name);
        ShortestPath optimal = des;
        while ((optimal = optimal.prev) != null) {
            treeMap.put(count++, optimal.node.name);
        }
        Result result = new Result(des.node.weight, new ArrayList<String>(treeMap.values()));
        this.reset();
        return result;
    }

    protected abstract void update();

    public final void reset() {
        LinkedList<ShortestPath> queue = new LinkedList<ShortestPath>();
        HashSet<String> book = new HashSet<String>();
        queue.offer(this);
        while (!queue.isEmpty()) {
            ShortestPath poll = (ShortestPath)queue.poll();
            poll.node.weight = null;
            poll.prev = null;
            book.add(poll.node.name);
            poll.nodes.forEach((k, v) -> {
                if (!book.contains(k.node.name)) {
                    queue.offer((ShortestPath)k);
                }
            });
        }
    }

    public static final class Dijkstra
    extends ShortestPath {
        public Dijkstra(String name, int size) {
            super(name, size);
        }

        @Override
        protected void update() {
            PQueue<ShortestPath> queue = PQueue.of(Comparator.comparingInt(t -> t.node.weight));
            HashSet<String> book = new HashSet<String>();
            queue.offer(this);
            while (!queue.isEmpty()) {
                ShortestPath poll = queue.poll();
                if (poll == null) continue;
                book.add(poll.node.name);
                poll.nodes.forEach((k, v) -> {
                    int weight = poll.node.weight + v;
                    if (k.node.weight == null || weight < k.node.weight) {
                        k.node.weight = weight;
                        k.prev = poll;
                    }
                    if (!book.contains(k.node.name)) {
                        queue.offer((ShortestPath)k);
                    }
                });
            }
        }
    }

    public static final class BellmanFord
    extends ShortestPath {
        public BellmanFord(String name, int size) {
            super(name, size);
        }

        @Override
        protected void update() {
            LinkedList<ShortestPath> queue = new LinkedList<ShortestPath>();
            HashSet<String> book = new HashSet<String>();
            AtomicInteger atomic = new AtomicInteger();
            this.update0(queue, book, atomic);
            int sum = 0;
            int count = 0;
            while (sum != (sum = atomic.get()) && count++ < book.size()) {
                atomic.set(0);
                book.clear();
                this.update0(queue, book, atomic);
            }
            ServerFailureMsg.requireNon(count >= book.size(), "\u65e0\u6cd5\u786e\u5b9a\u6700\u4f18\u65b9\u6848");
        }

        private void update0(Queue<ShortestPath> queue, Set<String> book, AtomicInteger atomic) {
            queue.offer(this);
            while (!queue.isEmpty()) {
                ShortestPath poll = queue.poll();
                book.add(poll.node.name);
                poll.nodes.forEach((k, v) -> {
                    int weight = poll.node.weight + v;
                    if (k.node.weight == null || weight < k.node.weight) {
                        k.node.weight = weight;
                        k.prev = poll;
                    }
                    if ((weight = k.node.weight + v) < poll.node.weight) {
                        poll.node.weight = weight;
                        poll.prev = k;
                    }
                    if (!book.contains(k.node.name)) {
                        queue.offer((ShortestPath)k);
                    }
                });
                atomic.addAndGet(poll.node.weight);
            }
        }
    }

    public static final class Result {
        int sum;
        List<String> ways;

        Result(int sum, List<String> ways) {
            this.sum = sum;
            this.ways = ways;
        }

        public int sum() {
            return this.sum;
        }

        public List<String> ways() {
            return this.ways;
        }

        public String toString() {
            return "Result{sum=" + this.sum + ", ways=" + this.ways + '}';
        }
    }

    protected static class Node {
        public String name;
        public Integer weight;

        public Node(String name) {
            this.name = name;
        }
    }
}

