/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.util.HashMap;
import java.util.Map;
import shz.Validator;

public final class SparseVector {
    private final Map<Integer, Double> st;

    private SparseVector(int capacity) {
        this.st = new HashMap<Integer, Double>(capacity);
    }

    public static SparseVector of(int capacity) {
        Validator.requireNon(capacity < 0);
        return new SparseVector(capacity);
    }

    public static SparseVector of() {
        return SparseVector.of(16);
    }

    public final int size() {
        return this.st.size();
    }

    public final void put(int key, double val) {
        this.st.put(key, val);
    }

    public final double get(int key) {
        if (!this.st.containsKey(key)) {
            return 0.0;
        }
        return this.st.get(key);
    }

    public final double dot(double[] that) {
        double sum = 0.0;
        for (int i : this.st.keySet()) {
            sum += that[i] * this.get(i);
        }
        return sum;
    }
}

