/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.awt.geom.Rectangle2D;
import shz.Help;
import shz.model.Polygon;

public class Sphere {
    public static final double EARTH_RADIUS = 6378245.0;
    private final double radius;
    public static final double RADIAN = Math.PI / 180;
    public static final double CHINA_LONGITUDE_LEFT = 72.004;
    public static final double CHINA_LONGITUDE_RIGHT = 137.8347;
    public static final double CHINA_LATITUDE_DOWN = 0.8293;
    public static final double CHINA_LATITUDE_UP = 55.8271;

    public Sphere(double radius) {
        this.radius = radius;
    }

    public static Sphere earth() {
        return SphereHolder.EARTH;
    }

    public final double area(double[] xs, double[] ys, int scale) {
        return Help.setScale((new Polygon(xs, ys).degreeSum() - (double)(xs.length - 2) * Math.PI) * this.radius * this.radius, scale);
    }

    public final double distance(double x1, double y1, double x2, double y2, int scale) {
        return Help.setScale(this.radius * Math.acos(Math.cos((x1 - x2) * (Math.PI / 180)) * Math.cos((y1 - y2) * (Math.PI / 180))), scale);
    }

    public static boolean outOfChina(double lon, double lat) {
        return lon < 72.004 || lon > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    public Rectangle2D.Double rectangle(double x, double y, double distance, double lonDifferential, double latDifferential) {
        double lat;
        double lon;
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        double lonMax = lon = 180.0;
        double lonMin = 0.0;
        double latRadius = this.radius * Math.cos(y * (Math.PI / 180));
        while (true) {
            if (latRadius * Math.acos(Math.cos(lon * (Math.PI / 180))) > distance) {
                lonMax = lon;
                lon = (lonMin + lon) / 2.0;
                continue;
            }
            if (lonMax - lon <= lonDifferential) {
                if (x - lon <= -180.0) {
                    rectangle.x = x + lon;
                    rectangle.width = lon - x - 180.0 - rectangle.x;
                    break;
                }
                rectangle.x = x - lon;
                rectangle.width = x + lon - rectangle.x;
                break;
            }
            lonMin = lon;
            lon = (lonMax + lon) / 2.0;
        }
        double latMax = lat = 90.0;
        double latMin = 0.0;
        while (true) {
            if (this.radius * Math.acos(Math.cos(lat * (Math.PI / 180))) > distance) {
                latMax = lat;
                lat = (latMin + lat) / 2.0;
                continue;
            }
            if (latMax - lat <= latDifferential) break;
            latMin = lat;
            lat = (latMax + lat) / 2.0;
        }
        rectangle.y = Math.max(y - lat, -90.0);
        rectangle.height = y + lat - rectangle.y;
        return rectangle;
    }

    public Rectangle2D.Double rectangle(double x, double y, double distance) {
        return this.rectangle(x, y, distance, 1.0E-5, 5.0E-6);
    }

    private static final class SphereHolder {
        private static final Sphere EARTH = new Sphere(6378245.0);

        private SphereHolder() {
        }
    }
}

