/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import shz.PRException;

public final class SyncRequest<T> {
    private volatile T response;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicInteger state = new AtomicInteger();

    private SyncRequest() {
    }

    public static <T> SyncRequest<T> of() {
        return new SyncRequest<T>();
    }

    public T waitFor(long timeout, TimeUnit unit) throws TimeoutException {
        block8: {
            this.state.compareAndSet(0, 1);
            try {
                if (timeout <= 0L) {
                    this.latch.await();
                } else {
                    this.latch.await(timeout, unit);
                }
            }
            catch (InterruptedException e) {
                if (this.state.get() != 1) break block8;
                throw PRException.of(e);
            }
        }
        if (this.state.compareAndSet(1, 2)) {
            throw new TimeoutException();
        }
        while (this.latch.getCount() != 0L) {
            try {
                this.latch.await(500L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.response;
    }

    public boolean reach(T response) {
        if (!this.state.compareAndSet(0, 2) && !this.state.compareAndSet(1, 2)) {
            return false;
        }
        this.response = response;
        this.latch.countDown();
        return true;
    }
}

