/*
 * Decompiled with CFR 0.152.
 */
package shz.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import shz.ToList;
import shz.ToMap;
import shz.Validator;

public class TreeNode<T extends TreeNode<T>> {
    protected String id;
    protected List<T> childes;

    public final int leafCount() {
        if (Validator.isEmpty(this.childes)) {
            return 1;
        }
        return this.childes.stream().map(TreeNode::leafCount).reduce(Integer::sum).orElse(0);
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final List<T> getChildes() {
        return this.childes;
    }

    public final void setChildes(List<T> childes) {
        this.childes = childes;
    }

    public String toString() {
        return "TreeNode{id='" + this.id + '\'' + ", childes=" + this.childes + '}';
    }

    public static <E, K, T extends TreeNode<T>, R> List<T> group(List<E> list, BiFunction<K, List<T>, T> mapper, BiFunction<K, R, T> lastMapper, Collector<E, ?, R> lastCollector, Function<E, K> ... classifiers) {
        if (Validator.isEmpty(list)) {
            return Collections.emptyList();
        }
        Collector<E, ?, Map<K, Object>> collector = Collectors.groupingBy(classifiers[classifiers.length - 1], lastCollector);
        for (int i = classifiers.length - 2; i >= 0; --i) {
            collector = Collectors.groupingBy(classifiers[i], collector);
        }
        return TreeNode.mergeGroup(list.stream().collect(collector), mapper, lastMapper);
    }

    private static <K, T extends TreeNode<T>, R> List<T> mergeGroup(Map<K, ?> group, BiFunction<K, List<T>, T> mapper, BiFunction<K, R, T> lastMapper) {
        return ToList.explicitCollect(group.keySet().stream().map(k -> {
            Object nextGroup = group.get(k);
            return nextGroup instanceof Map ? (TreeNode)mapper.apply(k, TreeNode.mergeGroup((Map)nextGroup, mapper, lastMapper)) : (TreeNode)lastMapper.apply(k, nextGroup);
        }), group.size());
    }

    public static <T extends TreeNode<T>> void sort(List<T> nodes, Comparator<T> comparator) {
        if (Validator.isEmpty(nodes)) {
            return;
        }
        nodes.sort(comparator);
        nodes.forEach(node -> TreeNode.sort(node.getChildes(), comparator));
    }

    public static <T extends TreeNode<T>> List<T> merge(List<T> nodes, List<T> otherNodes, BiFunction<T, T, T> merger) {
        if (Validator.isEmpty(nodes)) {
            return Validator.isEmpty(otherNodes) ? Collections.emptyList() : otherNodes;
        }
        if (Validator.isEmpty(otherNodes)) {
            return nodes;
        }
        Map map = ToMap.collect(nodes.stream(), TreeNode::getId, Function.identity());
        Map otherMap = ToMap.collect(otherNodes.stream(), TreeNode::getId, Function.identity());
        HashSet<String> ids = new HashSet<String>(map.keySet());
        HashSet<String> otherIds = new HashSet<String>(otherMap.keySet());
        if (!otherIds.removeAll(ids) || !otherIds.isEmpty()) {
            ids.addAll(otherIds);
        }
        return ToList.explicitCollect(ids.stream().map(k -> {
            TreeNode t = (TreeNode)map.get(k);
            TreeNode other = (TreeNode)otherMap.get(k);
            if (t == null) {
                return other;
            }
            if (other == null) {
                return t;
            }
            TreeNode result = (TreeNode)merger.apply(t, other);
            result.setChildes(TreeNode.merge(t.getChildes(), other.getChildes(), merger));
            return result;
        }), ids.size());
    }
}

