/*
 * Decompiled with CFR 0.152.
 */
package shz.msg;

import shz.Help;
import shz.PRException;
import shz.Validator;
import shz.msg.FailureMsg;

public interface ClientFailureMsg
extends FailureMsg {
    @Override
    default public int code() {
        return 400;
    }

    public static ClientFailureMsg fail(String msg) {
        return () -> msg;
    }

    public static ClientFailureMsg fail(String format, Object ... args) {
        return ClientFailureMsg.fail(Help.format(format, args));
    }

    public static void requireNon(boolean condition, String msg) {
        if (condition) {
            throw PRException.of(ClientFailureMsg.fail(msg));
        }
    }

    public static void requireNon(boolean condition, String format, Object ... args) {
        if (condition) {
            throw PRException.of(ClientFailureMsg.fail(format, args));
        }
    }

    public static void requireNonNull(Object obj, String msg) {
        if (obj == null) {
            throw PRException.of(ClientFailureMsg.fail(msg));
        }
    }

    public static void requireNonNull(Object obj, String format, Object ... args) {
        if (obj == null) {
            throw PRException.of(ClientFailureMsg.fail(format, args));
        }
    }

    public static void requireNonEmpty(Object obj, String msg) {
        if (Validator.isEmpty(obj)) {
            throw PRException.of(ClientFailureMsg.fail(msg));
        }
    }

    public static void requireNonEmpty(Object obj, String format, Object ... args) {
        if (Validator.isEmpty(obj)) {
            throw PRException.of(ClientFailureMsg.fail(format, args));
        }
    }

    public static void requireNonBlank(Object obj, String msg) {
        if (Validator.isBlank(obj)) {
            throw PRException.of(ClientFailureMsg.fail(msg));
        }
    }

    public static void requireNonBlank(Object obj, String format, Object ... args) {
        if (Validator.isBlank(obj)) {
            throw PRException.of(ClientFailureMsg.fail(format, args));
        }
    }
}

