/*
 * Decompiled with CFR 0.152.
 */
package shz.msg;

import shz.Help;
import shz.PRException;
import shz.Validator;
import shz.msg.FailureMsg;

public interface ServerFailureMsg
extends FailureMsg {
    @Override
    default public int code() {
        return 500;
    }

    public static ServerFailureMsg fail(String msg) {
        return () -> msg;
    }

    public static ServerFailureMsg fail(String format, Object ... args) {
        return ServerFailureMsg.fail(Help.format(format, args));
    }

    public static void requireNon(boolean condition, String msg) {
        if (condition) {
            throw PRException.of(ServerFailureMsg.fail(msg));
        }
    }

    public static void requireNon(boolean condition, String format, Object ... args) {
        if (condition) {
            throw PRException.of(ServerFailureMsg.fail(format, args));
        }
    }

    public static void requireNonNull(Object obj, String msg) {
        if (obj == null) {
            throw PRException.of(ServerFailureMsg.fail(msg));
        }
    }

    public static void requireNonNull(Object obj, String format, Object ... args) {
        if (obj == null) {
            throw PRException.of(ServerFailureMsg.fail(format, args));
        }
    }

    public static void requireNonEmpty(Object obj, String msg) {
        if (Validator.isEmpty(obj)) {
            throw PRException.of(ServerFailureMsg.fail(msg));
        }
    }

    public static void requireNonEmpty(Object obj, String format, Object ... args) {
        if (Validator.isEmpty(obj)) {
            throw PRException.of(ServerFailureMsg.fail(format, args));
        }
    }

    public static void requireNonBlank(Object obj, String msg) {
        if (Validator.isBlank(obj)) {
            throw PRException.of(ServerFailureMsg.fail(msg));
        }
    }

    public static void requireNonBlank(Object obj, String format, Object ... args) {
        if (Validator.isBlank(obj)) {
            throw PRException.of(ServerFailureMsg.fail(format, args));
        }
    }
}

