/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import java.util.Iterator;

public abstract class ArrayQueue<E>
implements Iterable<E> {
    protected static final int DEFAULT_CAPACITY = 8;
    protected int capacity;
    protected int size;
    protected int tail;
    protected int head;

    protected ArrayQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity + 1;
    }

    protected abstract E get(int var1);

    @Override
    public final Iterator<E> iterator() {
        return new ArrayQueueIterator();
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    protected final void beforeOffer() {
        if (this.size == this.capacity - 1) {
            if (this.capacity == Integer.MAX_VALUE) {
                throw new OutOfMemoryError();
            }
            int newCap = this.capacity >= 64 ? this.capacity + (this.capacity >> 1) : this.capacity << 1;
            this.resize(newCap < 0 ? Integer.MAX_VALUE : newCap);
        }
    }

    protected abstract void resize(int var1);

    protected final void afterOffer() {
        this.tail = (this.tail + 1) % this.capacity;
        ++this.size;
    }

    protected final void afterPoll() {
        this.setNull(this.head);
        this.head = (this.head + 1) % this.capacity;
        --this.size;
        this.reduce();
    }

    private void reduce() {
        if (this.capacity > 64) {
            int newCap = this.size + 1 + (this.size + 1 >> 1);
            if (newCap + (newCap >> 1) <= this.capacity) {
                this.resize(newCap);
            }
        } else if (this.size + 1 <= this.capacity >>> 2) {
            this.resize(this.capacity >> 1);
        }
    }

    protected abstract void setNull(int var1);

    public final void removeTail() {
        this.tail = this.tail == 0 ? this.capacity - 1 : --this.tail;
        this.setNull(this.tail);
        --this.size;
        this.reduce();
    }

    public final class ArrayQueueIterator
    implements Iterator<E> {
        private int current;

        public ArrayQueueIterator() {
            this.current = ArrayQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current != ArrayQueue.this.tail;
        }

        @Override
        public E next() {
            Object e = ArrayQueue.this.get(this.current);
            this.current = (this.current + 1) % ArrayQueue.this.capacity;
            return e;
        }
    }
}

