/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class BArrayQueue
extends ArrayQueue<Byte> {
    protected byte[] es;

    protected BArrayQueue(int capacity) {
        super(capacity);
        this.es = new byte[capacity];
    }

    public static BArrayQueue of(int capacity) {
        return new BArrayQueue(capacity);
    }

    public static BArrayQueue of() {
        return BArrayQueue.of(8);
    }

    @Override
    protected final Byte get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        byte[] temp = new byte[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = 0;
    }

    public final void offer(byte e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final byte poll() {
        byte e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final byte head() {
        return this.es[this.head];
    }

    public final byte tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

