/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class DArrayQueue
extends ArrayQueue<Double> {
    protected double[] es;

    protected DArrayQueue(int capacity) {
        super(capacity);
        this.es = new double[capacity];
    }

    public static DArrayQueue of(int capacity) {
        return new DArrayQueue(capacity);
    }

    public static DArrayQueue of() {
        return DArrayQueue.of(8);
    }

    @Override
    protected final Double get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        double[] temp = new double[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = 0.0;
    }

    public final void offer(double e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final double poll() {
        double e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final double head() {
        return this.es[this.head];
    }

    public final double tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

