/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class IArrayQueue
extends ArrayQueue<Integer> {
    protected int[] es;

    protected IArrayQueue(int capacity) {
        super(capacity);
        this.es = new int[capacity];
    }

    public static IArrayQueue of(int capacity) {
        return new IArrayQueue(capacity);
    }

    public static IArrayQueue of() {
        return IArrayQueue.of(8);
    }

    @Override
    protected final Integer get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        int[] temp = new int[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = 0;
    }

    public final void offer(int e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final int poll() {
        int e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final int head() {
        return this.es[this.head];
    }

    public final int tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

