/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class JArrayQueue
extends ArrayQueue<Long> {
    protected long[] es;

    protected JArrayQueue(int capacity) {
        super(capacity);
        this.es = new long[capacity];
    }

    public static JArrayQueue of(int capacity) {
        return new JArrayQueue(capacity);
    }

    public static JArrayQueue of() {
        return JArrayQueue.of(8);
    }

    @Override
    protected final Long get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        long[] temp = new long[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = 0L;
    }

    public final void offer(long e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final long poll() {
        long e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final long head() {
        return this.es[this.head];
    }

    public final long tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

